package com.xdja.combox.treeview;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

/**
 * 树形控件适配器
 * 
 * @author hhz
 * 
 */
@SuppressWarnings("rawtypes")
public class TreeViewAdapter extends ArrayAdapter {

	private Bitmap collapse; // 折叠图标；
	private Bitmap expand; // 展开图标
	private Context context; // 控件所在上下文
	private float mTextSize = -1.0f; // 设置文本字体大小；
	private int mTextColor = -1; // 设置文本字体颜色；
	private ArrayList<TreeElementBean> rootEleList = new ArrayList<TreeElementBean>(); // 树形控件的根元素；

	public Bitmap getCollapse() {
		return collapse;
	}

	public void setCollapse(Bitmap collapse) {
		this.collapse = collapse;
	}

	public Bitmap getExpand() {
		return expand;
	}

	public void setExpand(Bitmap expand) {
		this.expand = expand;
	}

	public float getmTextSize() {
		return mTextSize;
	}

	public void setmTextSize(float mTextSize) {
		this.mTextSize = mTextSize;
	}

	public int getmTextColor() {
		return mTextColor;
	}

	public void setmTextColor(int mTextColor) {
		this.mTextColor = mTextColor;
	}

	@SuppressWarnings("unchecked")
	public TreeViewAdapter(Context context, int textViewResourceId,
			List<TreeElementBean> list) {
		super(context, textViewResourceId, list);
		/*
		 * 遍历数据源元素填充树形控件的根元素；
		 */
		for (TreeElementBean element : list) {
			int level = element.getLevel();
			if (level == 0) {
				rootEleList.add(element);
			}
		}
		this.context = context;
		try {
			/*
			 * 读取asset中的资源文件；
			 */
			InputStream stream_collapse = context.getAssets().open(
					"collapse.png");
			collapse = BitmapFactory.decodeStream(stream_collapse);
			InputStream stream_expand = context.getAssets().open("expand.png");
			expand = BitmapFactory.decodeStream(stream_expand);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public int getCount() {
		return rootEleList.size();
	}

	public Object getItem(int position) {
		return rootEleList.get(position);
	}

	public long getItemId(int position) {
		return position;
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		LinearLayout ly = new LinearLayout(context); // 创建线性布局
		ly.setOrientation(LinearLayout.HORIZONTAL); // 设置线性布局中子控件排列方式为水平排列；
		ly.setLayoutParams(new ListView.LayoutParams(LayoutParams.FILL_PARENT,
				LayoutParams.FILL_PARENT)); // 设置线性布局在父容器中布局参数；
		ly.setGravity(Gravity.CENTER_VERTICAL); // 设置线性布局中控件垂直居中；
		TextView text = new TextView(context); // 创建文本控件；
		if (mTextColor != -1) {
			text.setTextColor(mTextColor);
		}
		if (mTextSize != -1.0f) {
			text.setTextSize(mTextSize);
		}
		text.setSingleLine(true); // 设置单行显示；
		ImageView icon = new ImageView(context); // 创建图片视图控件；
		LinearLayout.LayoutParams lyParams = new LinearLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT); // 创建在线性布局中的布局参数；
		ly.addView(icon, lyParams); // 添加子空间
		ly.addView(text, lyParams);
		ViewGroup.MarginLayoutParams mp = (ViewGroup.MarginLayoutParams) icon
				.getLayoutParams();
		mp.rightMargin = 6; // 设置图片视图的右外边距为6dp

		int level = rootEleList.get(position).getLevel();
		icon.setPadding(15 * (level + 1), icon.getPaddingTop(), 0,
				icon.getPaddingBottom()); // 设置图片视图的内边距；
		/*
		 * 初始化控件数据；
		 */
		text.setText(rootEleList.get(position).getNodeName());
		if (rootEleList.get(position).isHasChild()
				&& (rootEleList.get(position).isExpanded() == false)) {
			icon.setImageBitmap(collapse);
		} else if (rootEleList.get(position).isHasChild()
				&& (rootEleList.get(position).isExpanded() == true)) {
			icon.setImageBitmap(expand);
		} else if (!rootEleList.get(position).isHasChild()) {
			icon.setImageBitmap(collapse);
			icon.setVisibility(View.INVISIBLE);
		}
		return ly;
	}

	public void onClick(int position, ArrayList<TreeElementBean> subNodeList,
			TreeViewAdapter treeViewAdapter,
			OnLeafClickListener onLeafClickListener) {
		if (subNodeList == null || treeViewAdapter == null) {
			return;
		}
		/*
		 * 当点击的是叶子节点时，相应的事件，由用户提供；
		 */
		if (!rootEleList.get(position).isHasChild()) {
			if (onLeafClickListener == null) {
				return;
			}
			onLeafClickListener.setOnLeafClick();
		}

		/*
		 * 当点击的非叶子节点； 1、此节点为展开时；获取此节点的所有子节点，将子节点从根节点移除，重新加载数据；
		 * 2、次节点为折叠时；获取此节点的所有子节点，将子节点添加到根节点中，重新加载数据；
		 */
		if (rootEleList.get(position).isExpanded()) {
			rootEleList.get(position).setExpanded(false);
			TreeElementBean element = rootEleList.get(position);
			ArrayList<TreeElementBean> temp = new ArrayList<TreeElementBean>();

			for (int i = position + 1; i < rootEleList.size(); i++) {
				if (element.getLevel() >= rootEleList.get(i).getLevel()) {
					break;
				}
				temp.add(rootEleList.get(i));
			}

			rootEleList.removeAll(temp);

			treeViewAdapter.notifyDataSetChanged();

		} else {
			rootEleList.get(position).setExpanded(true);

			for (TreeElementBean element : subNodeList) {
				int j = 1;
				if (element.getUpNodeId() == rootEleList.get(position).getId()) {
					element.setExpanded(false);
					rootEleList.add(position + j, element);
					j++;
				}
			}
			treeViewAdapter.notifyDataSetChanged();
		}
	}

}
