/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.combox.dialog.XDRotater;
import com.xdja.combox.dialog.XDScaler;
import java.io.IOException;
import java.io.InputStream;

public class XDAlertDialog {
    private AlertDialog ad;
    private String title = "\u63d0\u793a";
    private String message;
    private int alert_type = 0;
    private Context mCxt;
    private Drawable d1;
    private Drawable d2;
    private Drawable d3;
    private Drawable d4;
    public static final int ALERT_RIGHT = 0;
    public static final int ALERT_ERROR = 1;
    public static final int ALERT_REMIND = 2;
    public static final int ALERT_WARNING = 3;
    private LinearLayout main_layout;
    private LinearLayout text_layout;
    private LinearLayout img_layout;
    private LinearLayout more_layout;
    private TextView tv;
    private EditText et;
    private ImageView img;
    private Boolean imgbtnFlag = false;
    private int imgbtnSize = 50;
    private XDRotater rotater;
    private XDScaler scaler;

    public XDAlertDialog(Context cx) {
        this.mCxt = cx;
        this.ad = new AlertDialog.Builder(cx).create();
        this.ad.setTitle((CharSequence)this.title);
        this.ad.setMessage((CharSequence)this.message);
        this.d3 = XDAlertDialog.getDrawableFromAssets(this.mCxt, "xddialog_remind.png");
        this.ad.setIcon(this.d3);
    }

    public void setButton(CharSequence text, DialogInterface.OnClickListener listener) {
        if (this.ad != null) {
            this.ad.setButton(text, listener);
        }
    }

    public void setButton2(CharSequence text, DialogInterface.OnClickListener listener) {
        if (this.ad != null) {
            this.ad.setButton2(text, listener);
        }
    }

    public void setButton3(CharSequence text, DialogInterface.OnClickListener listener) {
        if (this.ad != null) {
            this.ad.setButton3(text, listener);
        }
    }

    private View InitView(Context ctx) {
        Context temp = ctx;
        this.main_layout = new LinearLayout(ctx);
        this.main_layout.setOrientation(1);
        this.main_layout.setPadding(5, 0, 5, 0);
        this.text_layout = new LinearLayout(ctx);
        this.tv = new TextView(ctx);
        this.tv.setTextColor(-1);
        this.tv.setTextSize(18.0f);
        this.img = new ImageView(ctx);
        this.img.setBackgroundDrawable(XDAlertDialog.getDrawableFromAssets(ctx, "xddialog_down.png"));
        this.text_layout.addView((View)this.tv, -2, -2);
        this.rotater = new XDRotater();
        this.scaler = new XDScaler();
        this.img.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!XDAlertDialog.this.imgbtnFlag.booleanValue()) {
                    XDAlertDialog.this.rotater.create(0.0f, 180.0f).setDuration(800L).rotate((View)XDAlertDialog.this.img);
                    XDAlertDialog.this.more_layout.setClickable(false);
                    XDAlertDialog.this.more_layout.getChildAt(0).setEnabled(false);
                    XDAlertDialog.this.more_layout.getChildAt(0).setClickable(false);
                    XDAlertDialog.this.scaler.create(1.0f, 1.0f, 0.0f, 1.0f).setDuration(100).scale((View)XDAlertDialog.this.more_layout);
                    XDAlertDialog.this.imgbtnFlag = true;
                } else {
                    XDAlertDialog.this.rotater.create(180.0f, 0.0f).setDuration(800L).rotate((View)XDAlertDialog.this.img);
                    XDAlertDialog.this.more_layout.setClickable(false);
                    XDAlertDialog.this.more_layout.getChildAt(0).setEnabled(false);
                    XDAlertDialog.this.more_layout.getChildAt(0).setClickable(false);
                    XDAlertDialog.this.scaler.create(1.0f, 1.0f, 0.0f, 1.0f).setDuration(800).disscale((View)XDAlertDialog.this.more_layout);
                    XDAlertDialog.this.imgbtnFlag = false;
                }
            }
        });
        this.img_layout = new LinearLayout(ctx);
        this.img_layout.addView((View)this.img, this.imgbtnSize, this.imgbtnSize);
        this.img_layout.setGravity(5);
        this.more_layout = new LinearLayout(ctx);
        this.et = new EditText(ctx);
        this.et.setEnabled(false);
        this.et.setFocusable(false);
        this.et.setClickable(false);
        this.et.setTextSize(14.0f);
        this.et.setBackgroundColor(-1);
        this.et.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.more_layout.addView((View)this.et, -2, -2);
        this.more_layout.setBackgroundColor(-1);
        this.more_layout.setVisibility(8);
        this.more_layout.setClickable(false);
        this.main_layout.addView((View)this.text_layout, -1, -2);
        this.main_layout.addView((View)this.img_layout, -1, -2);
        this.main_layout.addView((View)this.more_layout, -1, -2);
        return this.main_layout;
    }

    public XDAlertDialog(Context cx, String title, String msg, int alertType) {
        this.mCxt = cx;
        if (!"".equals(title)) {
            this.title = title;
        }
        this.message = msg;
        this.alert_type = alertType;
        this.ad = new AlertDialog.Builder(cx).create();
        this.ad.setTitle((CharSequence)title);
        this.ad.setMessage((CharSequence)this.message);
        this.setAlertType(this.alert_type);
        this.ad.setButton(-1, (CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
    }

    public XDAlertDialog(Context cx, String title, int alertType, String brief, String detail, boolean isDisplayDetail) {
        this.mCxt = cx;
        if (!"".equals(title)) {
            this.title = title;
        }
        this.alert_type = alertType;
        this.ad = new AlertDialog.Builder(cx).create();
        this.ad.setTitle((CharSequence)title);
        this.setAlertType(this.alert_type);
        this.ad.setButton(-1, (CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        this.ad.setView(this.InitView(cx));
        this.setBriefText(brief);
        this.setDetaillText(detail);
        this.setImageButtonDisplay(isDisplayDetail);
    }

    public static void openDialog(Context cx, String title, String message, int type) {
        AlertDialog ad = new AlertDialog.Builder(cx).create();
        ad.setTitle((CharSequence)title);
        ad.setMessage((CharSequence)message);
        switch (type) {
            case 0: {
                Drawable d1 = XDAlertDialog.getDrawableFromAssets(cx, "xddialog_right.png");
                ad.setIcon(d1);
                break;
            }
            case 1: {
                Drawable d2 = XDAlertDialog.getDrawableFromAssets(cx, "xddialog_error.png");
                ad.setIcon(d2);
                break;
            }
            case 2: {
                Drawable d3 = XDAlertDialog.getDrawableFromAssets(cx, "xddialog_remind.png");
                ad.setIcon(d3);
                break;
            }
            case 3: {
                Drawable d4 = XDAlertDialog.getDrawableFromAssets(cx, "xddialog_warning.png");
                ad.setIcon(d4);
                break;
            }
            default: {
                Drawable d5 = XDAlertDialog.getDrawableFromAssets(cx, "xddialog_remind.png");
                ad.setIcon(d5);
            }
        }
        ad.setButton(-1, (CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        ad.show();
    }

    public void setButton(int buttonType, String msg, DialogInterface.OnClickListener listener) {
        if (buttonType != -1 && buttonType != -2 && buttonType != -3) {
            buttonType = -1;
        }
        this.ad.setButton(buttonType, (CharSequence)msg, listener);
    }

    public void setIcon(Drawable d) {
        this.ad.setIcon(d);
    }

    public void setTitle(String t) {
        this.ad.setTitle((CharSequence)t);
    }

    public void setMessage(String msg) {
        this.ad.setMessage((CharSequence)msg);
    }

    public void setAlertType(int type) {
        switch (type) {
            case 0: {
                this.d1 = XDAlertDialog.getDrawableFromAssets(this.mCxt, "xddialog_right.png");
                this.ad.setIcon(this.d1);
                break;
            }
            case 1: {
                this.d2 = XDAlertDialog.getDrawableFromAssets(this.mCxt, "xddialog_error.png");
                this.ad.setIcon(this.d2);
                break;
            }
            case 2: {
                this.d3 = XDAlertDialog.getDrawableFromAssets(this.mCxt, "xddialog_remind.png");
                this.ad.setIcon(this.d3);
                break;
            }
            case 3: {
                this.d4 = XDAlertDialog.getDrawableFromAssets(this.mCxt, "xddialog_warning.png");
                this.ad.setIcon(this.d4);
                break;
            }
            default: {
                this.d3 = XDAlertDialog.getDrawableFromAssets(this.mCxt, "xddialog_remind.png");
                this.ad.setIcon(this.d3);
            }
        }
    }

    public void show() {
        this.ad.show();
    }

    public static NinePatchDrawable get9ImageFromAssetsFile(Context context, String FileName) {
        try {
            InputStream stream = context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap getImageFromAssetsFile(Context cont, String fileName) {
        Bitmap image = null;
        AssetManager am = cont.getResources().getAssets();
        try {
            InputStream is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return image;
    }

    public void setBriefText(String brief) {
        this.tv.setText((CharSequence)brief);
    }

    public void setDetaillText(String detail) {
        this.et.setText((CharSequence)detail);
    }

    public void setBriefTextSize(int size) {
        this.tv.setTextSize((float)size);
    }

    public void setDetaillTextSize(int size) {
        this.et.setTextSize((float)size);
    }

    public void setImageButtonDisplay(Boolean display) {
        if (display.booleanValue()) {
            this.img.setVisibility(0);
        } else {
            this.img.setVisibility(8);
        }
    }

    public void setImageButtonSize(int size) {
        this.img.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(size, size));
    }

    public static Drawable getDrawableFromAssets(Context cx, String imgName) {
        InputStream is = null;
        try {
            is = cx.getResources().getAssets().open(imgName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
        BitmapDrawable bd = new BitmapDrawable(bitmap);
        return bd;
    }
}

