/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.dialog;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;

public class XDTranslateBar {
    private float START_X = -100.0f;
    private float END_X = 80.0f;
    private float START_Y = 150.0f;
    private float END_Y = 150.0f;
    private int CURRENT_Y_POSITION = -100;
    private int _X = 20;
    private int TIME = 2000;
    private int SPEED = 1000;
    private int DEFAULT_COLOR = -1;
    private TextView NoticeBar;
    private Animation _animation_start;
    private Animation _animation_end;
    private AnimationSet _animationSet;
    private Context ctx;

    public XDTranslateBar(Context context) {
        this.Init(context);
        this.ctx = context;
    }

    private void Init(Context context) {
        this.NoticeBar = new TextView(context);
        this.NoticeBar.setVisibility(8);
        this.NoticeBar.setBackgroundColor(this.DEFAULT_COLOR);
    }

    public XDTranslateBar setMove(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta) {
        this.START_X = fromXDelta - (float)this._X;
        this.END_X = toXDelta;
        this.START_Y = fromYDelta;
        this.END_Y = toYDelta;
        return this;
    }

    public XDTranslateBar setNoticeText(String notice) {
        this.NoticeBar.setText((CharSequence)notice);
        return this;
    }

    public XDTranslateBar setBarColor(int color) {
        this.NoticeBar.setBackgroundColor(color);
        return this;
    }

    public XDTranslateBar setBarDrawable(Drawable background) {
        this.NoticeBar.setBackgroundDrawable(background);
        return this;
    }

    public XDTranslateBar setTextSize(int size) {
        this.NoticeBar.setTextSize((float)size);
        return this;
    }

    public void show() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(0, 0, 0, this.CURRENT_Y_POSITION);
        ((Activity)this.ctx).addContentView((View)this.NoticeBar, (ViewGroup.LayoutParams)params);
        this.NoticeBar.setVisibility(0);
        this.NoticeBar.startAnimation((Animation)this._animationSet);
    }

    public XDTranslateBar create(String text) {
        this.NoticeBar.setText((CharSequence)text);
        this.START_X -= (float)this._X;
        this._animation_start = new TranslateAnimation(this.START_X, this.END_X, this.START_Y, this.END_Y);
        this._animationSet = new AnimationSet(true);
        this._animationSet.addAnimation(this._animation_start);
        this._animationSet.setFillAfter(true);
        this._animationSet.setDuration((long)this.SPEED);
        this._animationSet.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                try {
                    Thread.sleep(XDTranslateBar.this.TIME);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                XDTranslateBar.this.NoticeBar.startAnimation(XDTranslateBar.this._animation_end);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this._animation_end = new TranslateAnimation(this.END_X, this.START_X, this.END_Y, this.START_Y);
        this._animation_end.setDuration((long)this.SPEED);
        this._animation_end.setFillAfter(true);
        return this;
    }

    public View getView() {
        return this.NoticeBar;
    }

    public XDTranslateBar setShowTime(int time) {
        this.TIME = time;
        return this;
    }

    public XDTranslateBar setSpeed(int speed) {
        this.SPEED = speed;
        return this;
    }
}

