/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.inputbutton;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.combox.inputbutton.XDEditText;
import com.xdja.combox.utils.DensityUtil;
import java.util.HashMap;

public class XDEditTextView
extends RelativeLayout {
    private Context mContext = null;
    private HashMap<String, Integer> attrsMap = null;
    private XDEditText mEditText = null;
    private TextView mTextView = null;
    private int layoutType = 1;
    private int displayType = 1;
    private int layoutHeight = -2;
    private int layoutWidth = -1;
    private int textviewWidth = -2;
    private LinearLayout ll = null;

    public XDEditTextView(Context context, int displayType) {
        this(context, null);
        this.setDisplayType(displayType);
    }

    public XDEditTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mEditText = new XDEditText(context);
        this.mTextView = new TextView(context);
        this.mTextView.setGravity(17);
        this.mTextView.setSingleLine(false);
        this.initialAttrMap(context);
        this.analysisAttrs(this.attrsMap, attrs);
        this.initialControl(context);
    }

    private void initialAttrMap(Context context) {
        this.attrsMap = new HashMap();
        this.attrsMap.put("displaytype", 0);
        this.attrsMap.put("edittext_background", 1);
        this.attrsMap.put("textview_background", 2);
        this.attrsMap.put("textview_textcolor", 3);
        this.attrsMap.put("edittext_textcolor", 4);
        this.attrsMap.put("edittext_textsize", 5);
        this.attrsMap.put("textview_textsize", 6);
        this.attrsMap.put("textview_text", 7);
        this.attrsMap.put("edittext_text", 8);
        this.attrsMap.put("textview_visiable", 9);
        this.attrsMap.put("layouttype", 10);
        this.attrsMap.put("edittext_enable", 12);
        this.attrsMap.put("edittext_digits", 13);
        this.attrsMap.put("edittext_maxlength", 14);
        this.attrsMap.put("textview_width", 15);
        this.attrsMap.put("layout_widht", 16);
        this.attrsMap.put("layout_height", 17);
    }

    private void analysisAttrs(HashMap<String, Integer> attrsMap, AttributeSet attrs) {
        int attrId = -1;
        if (attrs != null) {
            int attrsCount = attrs.getAttributeCount();
            block19: for (int i = 0; i < attrsCount; ++i) {
                if (!attrsMap.containsKey(attrs.getAttributeName(i))) continue;
                attrId = attrsMap.get(attrs.getAttributeName(i));
                switch (attrId) {
                    case 0: {
                        this.setBackgroundByType(attrs.getAttributeValue(i));
                        continue block19;
                    }
                    case 1: {
                        this.setEditTextBackground(attrs.getAttributeResourceValue(i, -1));
                        continue block19;
                    }
                    case 2: {
                        this.setTextViewBackground(attrs.getAttributeResourceValue(i, -1));
                        continue block19;
                    }
                    case 3: {
                        this.setTextViewTextColor(attrs.getAttributeResourceValue(i, -1));
                        continue block19;
                    }
                    case 4: {
                        this.setEditTextTextColor(attrs.getAttributeResourceValue(i, -1));
                        continue block19;
                    }
                    case 5: {
                        this.setEditText_textSize(this.formatFloatVlaue(attrs.getAttributeValue(i)));
                        continue block19;
                    }
                    case 6: {
                        this.setTextView_textSize(this.formatFloatVlaue(attrs.getAttributeValue(i)));
                        continue block19;
                    }
                    case 7: {
                        this.setTextView_text(attrs.getAttributeValue(i));
                        continue block19;
                    }
                    case 8: {
                        this.setEditText_text(attrs.getAttributeValue(i));
                        continue block19;
                    }
                    case 9: {
                        this.setTextView_visiable(attrs.getAttributeBooleanValue(i, true));
                        continue block19;
                    }
                    case 10: {
                        this.layoutType = attrs.getAttributeIntValue(i, 1);
                        continue block19;
                    }
                    case 12: {
                        this.setEditText_enable(attrs.getAttributeBooleanValue(i, true));
                        continue block19;
                    }
                    case 13: {
                        this.setEditText_digits(attrs.getAttributeValue(i));
                        continue block19;
                    }
                    case 14: {
                        this.setEditText_maxLength(attrs.getAttributeIntValue(i, 100));
                        continue block19;
                    }
                    case 15: {
                        this.textviewWidth = this.formatIntVlaue(attrs.getAttributeValue(i));
                        this.setTextView_width(this.textviewWidth);
                        continue block19;
                    }
                    case 16: {
                        this.layoutWidth = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block19;
                    }
                    case 17: {
                        this.layoutHeight = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block19;
                    }
                }
            }
        }
    }

    public void setControlSize(int width, int height) {
        this.layoutHeight = height;
        this.layoutWidth = width;
        this.initialControl(this.mContext);
    }

    private void initialControl(Context context) {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.layoutWidth, this.layoutHeight));
        this.setPadding(0, 0, 0, 0);
        this.removeAllViews();
        this.setGravity(16);
        if (this.layoutType == 0) {
            if (this.ll != null && this.ll.getChildCount() > 0) {
                this.ll.removeAllViews();
            }
            this.ll = new LinearLayout(context);
            this.ll.setOrientation(0);
            this.ll.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.layoutHeight));
            LinearLayout.LayoutParams textViewLayoutParams = new LinearLayout.LayoutParams(this.textviewWidth, this.layoutHeight);
            this.ll.addView((View)this.mTextView, (ViewGroup.LayoutParams)textViewLayoutParams);
            LinearLayout.LayoutParams editTextLayoutParams = new LinearLayout.LayoutParams(-1, this.layoutHeight);
            editTextLayoutParams.weight = 1.0f;
            this.mEditText.setPadding(DensityUtil.dp2px(this.mContext, 5.0f), 0, 0, 0);
            this.ll.addView((View)this.mEditText, (ViewGroup.LayoutParams)editTextLayoutParams);
            this.addView((View)this.ll);
        } else if (this.layoutType == 1) {
            RelativeLayout.LayoutParams editTextLayoutParams = new RelativeLayout.LayoutParams(-1, this.layoutHeight);
            this.addView((View)this.mEditText, (ViewGroup.LayoutParams)editTextLayoutParams);
            RelativeLayout.LayoutParams textViewLayoutParams = new RelativeLayout.LayoutParams(this.textviewWidth, this.layoutHeight);
            textViewLayoutParams.addRule(5, this.mEditText.getId());
            textViewLayoutParams.addRule(15, this.getId());
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)textViewLayoutParams);
            this.mEditText.setPadding(this.mTextView.getWidth() + DensityUtil.dp2px(this.mContext, 5.0f), 0, 0, 0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.layoutType == 1) {
            this.mEditText.setPadding(this.mTextView.getWidth() + DensityUtil.dp2px(this.mContext, 5.0f), 0, 0, 0);
        }
    }

    private void setBackgroundByType(String typeStr) {
        if (typeStr != null) {
            if (typeStr.equals("0")) {
                this.displayType = 0;
            } else if (typeStr.equals("1")) {
                this.displayType = 1;
            }
            this.mEditText.setDisplayType(this.displayType);
        }
    }

    private void setEditTextTextColor(int resourceId) {
        if (resourceId > 0) {
            this.setEditText_textColor(this.getContext().getResources().getColor(resourceId));
        }
    }

    private void setTextViewTextColor(int resourceId) {
        boolean isFormat = true;
        if (resourceId > 0) {
            try {
                this.setTextView_textColor(this.getContext().getResources().getColor(resourceId));
            }
            catch (Exception ex) {
                isFormat = false;
            }
        }
        if (!isFormat) {
            try {
                this.setTextView_textColor(resourceId);
            }
            catch (Exception e) {
                Log.e((String)"\u9519\u8bef\u7684\u989c\u8272\u503c", (String)(resourceId + "\u4e3a\u9519\u8bef\u7684\u989c\u8272\u503c"));
            }
        }
    }

    private void setTextViewBackground(int resourceId) {
        if (resourceId > 0) {
            this.setTextView_background(resourceId);
        }
    }

    private void setEditTextBackground(int resourceId) {
        if (resourceId > 0) {
            this.setEditText_background(resourceId);
        }
    }

    private float formatFloatVlaue(String val) {
        boolean isFormat = true;
        float value = 14.0f;
        if (val.endsWith("sp")) {
            val = val.substring(0, val.length() - 2);
        }
        try {
            value = Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            isFormat = false;
        }
        if (!isFormat) {
            try {
                value = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u4e0d\u80fd\u88ab\u8f6c\u5316\u4e3afloat\u7c7b\u578b"));
            }
        }
        return value;
    }

    private int formatIntVlaue(String val) {
        int value = -1;
        if (val.equals("wrap_content")) {
            value = -2;
        } else if (val.equals("fill_parent")) {
            value = -1;
        } else if (val.endsWith("dp") || val.endsWith("dip")) {
            if (val.endsWith("dp")) {
                val = val.substring(0, val.length() - 2);
            } else if (val.endsWith("dip")) {
                val = val.substring(0, val.length() - 5);
            }
            try {
                value = Integer.parseInt(val);
                value = DensityUtil.dp2px(this.mContext, value);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
            }
        } else {
            if (val.endsWith("px")) {
                val = val.substring(0, val.length() - 2);
            }
            try {
                value = Integer.parseInt(val);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
                Log.v((String)"pxValue", (String)(value + ""));
            }
        }
        return value;
    }

    public void setTextView_visiable(boolean visiable) {
        if (visiable) {
            this.mTextView.setVisibility(0);
        } else {
            this.mTextView.setVisibility(8);
        }
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(int displayType) {
        this.displayType = displayType;
        this.mEditText.setDisplayType(displayType);
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(int layoutType) {
        this.layoutType = layoutType;
        this.initialControl(this.mContext);
    }

    public Editable getEditText_text() {
        return this.mEditText.getText();
    }

    public void setEditText_text(String mEditText_text) {
        this.mEditText.setText(mEditText_text);
    }

    public CharSequence getTextView_text() {
        return this.mTextView.getText();
    }

    public void setTextView_text(String mTextView_text) {
        this.mTextView.setText((CharSequence)mTextView_text);
    }

    public float getTextView_textSize() {
        return this.mTextView.getTextSize();
    }

    public void setTextView_textSize(float mTextView_textSize) {
        this.mTextView.setTextSize(mTextView_textSize);
    }

    public float getEditText_textSize() {
        return this.mEditText.getTextSize();
    }

    public void setEditText_textSize(float mEditText_textSize) {
        this.mEditText.setTextSize(mEditText_textSize);
    }

    public void setEditText_textColor(int mEditText_textColor) {
        this.mEditText.setTextColor(mEditText_textColor);
    }

    public void setTextView_textColor(int mTextView_textColor) {
        this.mTextView.setTextColor(mTextView_textColor);
    }

    public Drawable getTextView_background() {
        return this.mTextView.getBackground();
    }

    public void setTextView_background(int resid) {
        this.mTextView.setBackgroundResource(resid);
    }

    public Drawable getEditText_background() {
        return this.mEditText.getBackground();
    }

    public void setEditText_background(int resid) {
        this.mEditText.setBackgroundResource(resid);
    }

    public void setEditText_enable(boolean enable) {
        this.mEditText.setEnabled(enable);
        if (!enable) {
            this.mEditText.setFocusable(false);
            this.mEditText.setFocusableInTouchMode(false);
        } else {
            this.mEditText.setFocusable(true);
            this.mEditText.setFocusableInTouchMode(true);
            this.mEditText.requestFocus();
        }
    }

    public void setEditText_digits(String digits) {
        this.mEditText.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)digits));
    }

    public void setEditText_maxLength(int maxLength) {
        InputFilter[] filter = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        this.mEditText.setFilters(filter);
    }

    public void setTextView_width(int textviewWidth) {
        this.textviewWidth = textviewWidth;
        this.initialControl(this.mContext);
    }

    public XDEditText getEditText() {
        return this.mEditText;
    }

    public void addEditText_TextChangedListener(TextWatcher watcher) {
        this.mEditText.addTextChangedListener(watcher);
    }

    public void setEditText_OnClickListener(View.OnClickListener l) {
        this.mEditText.setOnClickListener(l);
    }

    public void setEditText_OnTouchListener(View.OnTouchListener l) {
        this.mEditText.setOnTouchListener(l);
    }

    public void setEditText_OnLongClickListener(View.OnLongClickListener l) {
        this.mEditText.setOnLongClickListener(l);
    }

    public void setEditText_OnCreateContextMenuListener(View.OnCreateContextMenuListener l) {
        this.mEditText.setOnCreateContextMenuListener(l);
    }

    public void setEditText_OnFocusChangeListener(View.OnFocusChangeListener l) {
        this.mEditText.setOnFocusChangeListener(l);
    }

    public void setEditText_OnKeyListener(View.OnKeyListener l) {
        this.mEditText.setOnKeyListener(l);
    }

    public void setEditText_PaddingRight(int right) {
        if (this.layoutType == 1) {
            this.mEditText.setPadding(this.mTextView.getWidth() + DensityUtil.dp2px(this.mContext, 5.0f), 0, right, 0);
        } else if (this.layoutType == 0) {
            this.mEditText.setPadding(DensityUtil.dp2px(this.mContext, 5.0f), 0, right, 0);
        }
    }
}

