/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.keyboard;

import android.content.Context;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import com.xdja.combox.keyboard.InputSoftKeyBoard;

public class EditInput {
    private static EditText editText;
    private static long timeOnTouchDown;
    private static long timeOnTouchUp;

    public static void setEdit(String resultString) {
        editText.setText((CharSequence)resultString);
        Editable etext = editText.getText();
        int position = etext.length();
        Selection.setSelection((Spannable)etext, (int)position);
        editText.setFocusable(true);
        editText.requestFocus();
    }

    public static void inputSetting(final EditText Edit, final Context ctxContext, final String defaultPanel, final Boolean passwd, final String text) {
        Edit.setInputType(0);
        Edit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InputMethodManager imm = (InputMethodManager)ctxContext.getSystemService("input_method");
                imm.hideSoftInputFromWindow(((EditText)v).getWindowToken(), 0);
                editText = Edit;
                String inputsString = "" + Edit.getText().toString().replace(" ", "");
                InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext, Edit, defaultPanel, passwd, text);
            }
        });
        if (passwd.booleanValue()) {
            Edit.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
        Edit.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    editText = Edit;
                    String inputsString = "" + Edit.getText().toString().replace(" ", "");
                    InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext, Edit, defaultPanel, passwd, text);
                }
            }
        });
    }

    public static void inputSettingButton(final EditText Edit, final Context ctxContext, final String defaultPanel, final Boolean passwd, final String text, ImageButton btn) {
        Edit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InputMethodManager imm = (InputMethodManager)ctxContext.getSystemService("input_method");
                imm.hideSoftInputFromWindow(((EditText)v).getWindowToken(), 0);
                editText = Edit;
                String inputsString = "" + Edit.getText().toString().replace(" ", "");
                InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext, Edit, defaultPanel, passwd, text);
            }
        });
        if (passwd.booleanValue()) {
            Edit.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
        if (btn != null) {
            btn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InputMethodManager imm = (InputMethodManager)ctxContext.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(Edit.getWindowToken(), 0);
                    editText = Edit;
                    InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext, Edit, defaultPanel, passwd, text);
                }
            });
        }
    }

    public static boolean isEditTextChinese(EditText editT) {
        String temp = editT.getText().toString();
        if (temp.length() > 0) {
            for (int i = 0; i < temp.length(); ++i) {
                if (EditInput.isChinese(temp.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    static {
        timeOnTouchDown = 0L;
        timeOnTouchUp = 0L;
    }
}

