/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.spinner;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.xdja.combox.spinner.SpinnerItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class XDSpinner
extends Spinner {
    private Context mcontext = null;
    public String Styletype = "0";
    private Drawable[] roundDrawable = null;
    private Drawable[] squareDrawable = null;
    private Drawable[] setDrawable = null;
    private Drawable defaultDrawable = null;
    private int layout_span = -1;
    private int layout_drop = -1;
    private int TextColor = -16777216;
    private int TextSize = 18;
    private ArrayList<SpinnerItem> data = null;
    public static final int SHOW_TYPE = 0;
    public static final int SHOW_TYPE_RADIOBUTTON = 1;
    public static final String DATA_CODE = "1";
    public static final String DATA_TEXT = "0";

    public XDSpinner(Context context) {
        super(context);
        this.mcontext = context;
    }

    public XDSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mcontext = context;
        String temp = null;
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            int resourceId;
            if ("Styletype".equals(attrs.getAttributeName(i))) {
                temp = attrs.getAttributeValue(i);
                continue;
            }
            if ("background".equals(attrs.getAttributeName(i))) {
                resourceId = attrs.getAttributeResourceValue(i, 0);
                if (resourceId <= 0) continue;
                this.defaultDrawable = this.getResources().getDrawable(resourceId);
                continue;
            }
            if ("layoutspan".equals(attrs.getAttributeName(i))) {
                resourceId = attrs.getAttributeResourceValue(i, 0);
                if (resourceId <= 0) continue;
                this.layout_span = resourceId;
                continue;
            }
            if (!"layoutdrop".equals(attrs.getAttributeName(i)) || (resourceId = attrs.getAttributeResourceValue(i, 0)) <= 0) continue;
            this.layout_drop = resourceId;
        }
        if (this.defaultDrawable == null) {
            if (temp != null) {
                this.Styletype = temp;
                this.initDrawable(this.Styletype);
            } else {
                this.Styletype = DATA_CODE;
                this.initDrawable(this.Styletype);
            }
        } else {
            this.setBackgroundDrawable(this.defaultDrawable);
        }
    }

    private static NinePatchDrawable get9ImageFromAssetsFile(Context context, String FileName) {
        try {
            InputStream stream = context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap getBitmap(Context context, String FileName) {
        Bitmap bitmap;
        try {
            InputStream stream = context.getAssets().open(FileName);
            bitmap = BitmapFactory.decodeStream((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return bitmap;
    }

    private void initDrawable(String Styletype) {
        if (Styletype.equals(DATA_CODE)) {
            this.roundDrawable = new Drawable[3];
            this.roundDrawable[0] = XDSpinner.get9ImageFromAssetsFile(this.mcontext, "xdspinner_dropdown_normal.9.png");
            this.roundDrawable[1] = XDSpinner.get9ImageFromAssetsFile(this.mcontext, "xdspinner_dropdown_selected.9.png");
            this.roundDrawable[2] = XDSpinner.get9ImageFromAssetsFile(this.mcontext, "xdspinner_dropdown_selected.9.png");
            this.setBackgroundDrawable((Drawable)this.setBg(this.roundDrawable));
        }
        if (Styletype.equals("2")) {
            this.squareDrawable = new Drawable[3];
            this.squareDrawable[0] = XDSpinner.get9ImageFromAssetsFile(this.mcontext, "xdspinner_normal.9.png");
            this.squareDrawable[1] = XDSpinner.get9ImageFromAssetsFile(this.mcontext, "xdspinner_select.9.png");
            this.squareDrawable[2] = XDSpinner.get9ImageFromAssetsFile(this.mcontext, "xdspinner_select.9.png");
            this.setBackgroundDrawable((Drawable)this.setBg(this.squareDrawable));
        }
    }

    private StateListDrawable setBg(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_STATE_SET, drawables[2]);
        return bg;
    }

    public void FillData(final ArrayList<SpinnerItem> temp, int showtype) {
        if (temp != null) {
            this.data = temp;
            if (showtype != 0 && showtype != 1) {
                showtype = 1;
            }
            if (showtype == 0) {
                final Bitmap bmp = XDSpinner.getBitmap(this.mcontext, "xdspinnerimage.png");
                ArrayAdapter<SpinnerItem> adapter = new ArrayAdapter<SpinnerItem>(this.mcontext, 17367048, temp){

                    public View getDropDownView(int position, View convertView, ViewGroup parent) {
                        LinearLayout view = new LinearLayout(XDSpinner.this.mcontext);
                        view.setOrientation(0);
                        ImageView imageView = new ImageView(XDSpinner.this.mcontext);
                        imageView.setImageBitmap(bmp);
                        imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                        imageView.setPadding(5, 2, 2, 2);
                        imageView.setVisibility(4);
                        TextView tv = new TextView(XDSpinner.this.mcontext);
                        tv.setText((CharSequence)((SpinnerItem)temp.get(position)).toString());
                        tv.setTextSize((float)XDSpinner.this.TextSize);
                        tv.setTextColor(XDSpinner.this.TextColor);
                        tv.setPadding(5, 5, 2, 5);
                        view.addView((View)imageView);
                        view.addView((View)tv);
                        if (XDSpinner.this.getSelectedItemId() == (long)position) {
                            imageView.setVisibility(0);
                        }
                        return view;
                    }
                };
                this.setAdapter((SpinnerAdapter)adapter);
            }
            if (showtype == 1) {
                ArrayAdapter arrayAdapter;
                Log.i((String)"layout_span", (String)(this.layout_span + "*"));
                Log.i((String)"layout_drop", (String)(this.layout_drop + "*"));
                if (this.layout_span == -1) {
                    arrayAdapter = new ArrayAdapter(this.mcontext, 17367048, temp);
                    if (this.layout_drop == -1) {
                        arrayAdapter.setDropDownViewResource(0x1090009);
                    } else {
                        arrayAdapter.setDropDownViewResource(this.layout_drop);
                    }
                    this.setAdapter((SpinnerAdapter)arrayAdapter);
                } else {
                    arrayAdapter = new ArrayAdapter(this.mcontext, this.layout_span, temp);
                    if (this.layout_drop == -1) {
                        arrayAdapter.setDropDownViewResource(0x1090009);
                    } else {
                        arrayAdapter.setDropDownViewResource(this.layout_drop);
                    }
                    this.setAdapter((SpinnerAdapter)arrayAdapter);
                }
            }
        }
    }

    public void setDataCodeSelection(String code) {
        if (this.data == null) {
            return;
        }
        Boolean temp = false;
        for (int i = 0; i < this.data.size(); ++i) {
            String text = this.data.get(i).GetValue();
            if (!text.equals(code)) continue;
            this.setSelection(i);
            temp = true;
            break;
        }
    }

    public void setDataTextSelection(String valuetext) {
        if (this.data == null) {
            return;
        }
        Boolean temp = false;
        for (int i = 0; i < this.data.size(); ++i) {
            String text = this.data.get(i).GetText();
            if (!text.equals(valuetext)) continue;
            this.setSelection(i, true);
            temp = true;
            break;
        }
    }

    public String getSpinnerCodeOrValue(String flag) {
        String temp = "";
        if (flag == null) {
            return "\u8bf7\u8f93\u5165\u6709\u6548\u7684\u53d6\u503c";
        }
        if (this.data != null) {
            int location = Integer.valueOf(String.valueOf(this.getSelectedItemId()));
            if (flag.equals(DATA_CODE)) {
                temp = this.data.get(location).GetValue();
            }
            if (flag.equals(DATA_TEXT)) {
                temp = this.data.get(location).GetText();
            }
        }
        return temp;
    }

    public void setTextSize(int size) {
        if (size >= -1) {
            this.TextSize = size;
        }
    }

    public void setTextColor(int color2) {
        this.TextColor = color2;
    }

    public void setStyletype(String showtype) {
        this.Styletype = showtype;
        this.initDrawable(this.Styletype);
    }

    public void setBackground(Drawable normal, Drawable select) {
        this.setDrawable = new Drawable[3];
        this.setDrawable[0] = normal;
        this.setDrawable[1] = select;
        this.setDrawable[2] = select;
        this.setBackgroundDrawable((Drawable)this.setBg(this.setDrawable));
    }
}

