/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.tabhost;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TextView;
import com.xdja.combox.tabhost.JumpPoint;
import com.xdja.combox.tabhost.OnClickTabControl;
import com.xdja.combox.utils.DensityUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class TabControl {
    private TabHost m_TabHost;
    private static Context m_context;
    private int displayCount = 3;
    private int TabWidth = 0;
    private int currenttablocation = 0;
    private int lasttablocation = -1;
    private OnClickTabControl Tablistener = null;
    private static int textSize;
    private static int textColor;
    private String[] Tabshowtext = null;
    private List<Bitmap> showbmps = null;
    private int[] showviewId = null;
    private static Drawable tabselect;
    private static Drawable tabunselect;
    private static Drawable tabdivider;
    private View[] TabView = null;
    private TextView Lable = null;
    private int Lablesize = 18;
    private int LableColor = -16777216;
    private Drawable LableBackground = null;
    private int LableBackgroundcolor = -1;
    private Boolean ShowLable = false;
    private Boolean ShowPoint = false;
    private Boolean ShowTable = false;
    private JumpPoint point = null;
    private int radius = 10;

    public TabControl(Context context, OnClickTabControl listener) {
        m_context = context;
        this.Tablistener = listener;
        this.initDrawable();
    }

    public TabControl(Context context) {
        m_context = context;
        this.initDrawable();
    }

    private void setupTab(String tag, String text, Bitmap bmp) {
        View tabview = null;
        tabview = bmp == null ? TabControl.createTabView(this.m_TabHost.getContext(), text, null) : TabControl.createTabView(this.m_TabHost.getContext(), text, bmp);
        TabHost.TabSpec setContent = this.m_TabHost.newTabSpec(tag).setIndicator(tabview).setContent(new TabHost.TabContentFactory(){

            public View createTabContent(String tag) {
                return TabControl.initLinearLayout();
            }
        });
        this.m_TabHost.addTab(setContent);
    }

    private static View createTabView(Context context, String text, Bitmap bmp) {
        LinearLayout mLinearLayout = new LinearLayout(context);
        mLinearLayout.setGravity(17);
        mLinearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, DensityUtil.dp2px(context, 63.0f)));
        mLinearLayout.setOrientation(1);
        if (bmp != null) {
            ImageView mimage = new ImageView(context);
            mimage.setLayoutParams(new ViewGroup.LayoutParams(DensityUtil.dp2px(context, 35.0f), DensityUtil.dp2px(context, 35.0f)));
            mimage.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            mimage.setPadding(0, DensityUtil.dp2px(context, 5.0f), 0, 0);
            mimage.setImageBitmap(bmp);
            mLinearLayout.addView((View)mimage);
        }
        if (text != null) {
            TextView mtext = new TextView(context);
            mtext.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            mtext.setTextSize((float)textSize);
            mtext.setTextColor(textColor);
            mtext.setGravity(17);
            mtext.setPadding(0, DensityUtil.dp2px(context, 5.0f), 0, 0);
            mLinearLayout.addView((View)mtext);
            mtext.setText((CharSequence)text);
        }
        if (tabunselect != null) {
            mLinearLayout.setBackgroundDrawable(tabunselect);
        }
        return mLinearLayout;
    }

    private void setTabsNum(int displayCount) {
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)m_context).getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        this.TabWidth = dm.widthPixels / displayCount;
        TabWidget tabWidget = this.m_TabHost.getTabWidget();
        int count = tabWidget.getTabCount();
        for (int i = 0; i < count; ++i) {
            tabWidget.getChildTabViewAt(i).setMinimumWidth(screenWidth / displayCount);
        }
    }

    private void setSelect(int selectab) {
        View vvv = this.m_TabHost.getTabWidget().getChildTabViewAt(selectab);
        if (tabselect != null) {
            vvv.setBackgroundDrawable(tabselect);
        }
        if (this.lasttablocation >= 0) {
            View vv = this.m_TabHost.getTabWidget().getChildTabViewAt(this.lasttablocation);
            if (tabunselect != null) {
                vv.setBackgroundDrawable(tabunselect);
            }
        }
    }

    public void SetTabTextSize(int size) {
        textSize = size;
    }

    public void SetTabsBackground(List<Bitmap> bmps) {
        this.showbmps = bmps;
    }

    public void SetTabTextColor(int _textColor) {
        textColor = _textColor;
    }

    public void SetTabDispaly(int number) {
        this.displayCount = number;
    }

    public int getCurrenttab() {
        return this.m_TabHost.getCurrentTab();
    }

    public void SetLableSize(int size) {
        this.Lablesize = size;
    }

    public void SetLableColor(int color2) {
        this.LableColor = color2;
    }

    public void SetLableBackground(Drawable bg) {
        this.LableBackground = bg;
    }

    public void SetLableBackground(int color2) {
        this.LableBackgroundcolor = color2;
    }

    public void ShowTabHost() {
        this.m_TabHost.setup();
        if (tabdivider != null) {
            this.m_TabHost.getTabWidget().setDividerDrawable(tabdivider);
        }
        int length = this.Tabshowtext.length;
        if (this.showbmps == null) {
            for (int i = 0; i < length; ++i) {
                this.setupTab(String.valueOf(i), this.Tabshowtext[i], null);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.setupTab(String.valueOf(i), this.Tabshowtext[i], this.showbmps.get(i));
            }
        }
        this.lasttablocation = -1;
        this.setSelect(this.currenttablocation);
        this.setTabsNum(this.displayCount);
    }

    public void SetTabBitmap(Drawable select, Drawable unselect, Drawable divider) {
        tabselect = select;
        tabunselect = unselect;
        tabdivider = divider;
    }

    private void initDrawable() {
        try {
            tabdivider = this.get9ImageFromAssetsFile("tabcontrol_tab_divider.9.png");
            tabunselect = this.getDrawableFromAssetsFile("tabcontrol_tab_unselect.png");
            tabselect = this.getDrawableFromAssetsFile("tabcontrol_tab_select.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u83b7\u53d6\u9ed8\u8ba4\u56fe\u7247\u8d44\u6e90\u51fa\u9519");
        }
    }

    private NinePatchDrawable get9ImageFromAssetsFile(String FileName) {
        try {
            InputStream stream = m_context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Drawable getDrawableFromAssetsFile(String FileName) {
        BitmapDrawable temp = null;
        try {
            InputStream stream = m_context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            temp = new BitmapDrawable(bitmap);
            return temp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TabHost AddTab(View[] _tabview, String[] _text) {
        this.TabView = _tabview;
        this.Tabshowtext = _text;
        for (int i = 0; i < this.TabView.length; ++i) {
            this.TabView[i].setId(i);
        }
        return this.InitTabHost();
    }

    public void setCurrenttab(int position) {
        this.m_TabHost.setCurrentTab(position);
    }

    public void setShowLable(Boolean _showLable) {
        this.ShowLable = _showLable;
    }

    public void setShowPoint(Boolean _showPoint) {
        this.ShowPoint = _showPoint;
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)m_context).getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        this.radius = DensityUtil.dp2px(m_context, 6.0f);
    }

    public void setShowTable(Boolean _showtab) {
        this.ShowTable = _showtab;
    }

    private TabHost InitTabHost() {
        this.m_TabHost = new TabHost(m_context);
        this.m_TabHost.setId(0x1020012);
        LinearLayout.LayoutParams m_table = new LinearLayout.LayoutParams(-1, -1);
        this.m_TabHost.setLayoutParams((ViewGroup.LayoutParams)m_table);
        LinearLayout m_layout = new LinearLayout(m_context);
        m_layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        m_layout.setOrientation(1);
        if (this.ShowLable.booleanValue()) {
            LinearLayout m_Lablelayout = new LinearLayout(m_context);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.topMargin = 4;
            layoutParams.bottomMargin = 6;
            m_Lablelayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            m_Lablelayout.setOrientation(1);
            if (this.LableBackground != null) {
                m_Lablelayout.setBackgroundDrawable(this.LableBackground);
            } else {
                m_Lablelayout.setBackgroundColor(this.LableBackgroundcolor);
            }
            this.Lable = new TextView(m_context);
            this.Lable.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            m_Lablelayout.addView((View)this.Lable);
            this.Lable.setTextSize((float)this.Lablesize);
            this.Lable.setTextColor(this.LableColor);
            m_layout.addView((View)m_Lablelayout);
        }
        if (this.ShowPoint.booleanValue() && !this.ShowLable.booleanValue()) {
            this.point = new JumpPoint(m_context, this.TabView.length, this.radius);
            this.point.setBackgroundDrawable(Drawable.createFromStream((InputStream)m_context.getClass().getClassLoader().getResourceAsStream("assets/XDTabHost_unselect.png"), (String)"9.png"));
            this.point.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.radius * 4));
            m_layout.addView((View)this.point);
        }
        final ViewPager viewPage = new ViewPager(m_context);
        LinearLayout.LayoutParams viewPage_layoutParams = new LinearLayout.LayoutParams(-1, -2);
        viewPage_layoutParams.weight = 1.0f;
        viewPage.setLayoutParams((ViewGroup.LayoutParams)viewPage_layoutParams);
        m_layout.addView((View)viewPage);
        FrameLayout m_framelayout = new FrameLayout(m_context);
        m_framelayout.setId(0x1020011);
        LinearLayout.LayoutParams framelayout_layoutParams = new LinearLayout.LayoutParams(-1, -2);
        framelayout_layoutParams.weight = 1.0f;
        m_framelayout.setVisibility(8);
        m_framelayout.setLayoutParams((ViewGroup.LayoutParams)framelayout_layoutParams);
        m_layout.addView((View)m_framelayout);
        TabWidget m_tabWidget = new TabWidget(m_context);
        m_tabWidget.setId(16908307);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        lp.addRule(12);
        m_tabWidget.setLayoutParams((ViewGroup.LayoutParams)lp);
        final HorizontalScrollView m_horizontalscroll = new HorizontalScrollView(m_context);
        LinearLayout.LayoutParams horizontalscroll_layoutParams = new LinearLayout.LayoutParams(-1, -2);
        horizontalscroll_layoutParams.weight = 0.0f;
        m_horizontalscroll.setLayoutParams((ViewGroup.LayoutParams)horizontalscroll_layoutParams);
        m_horizontalscroll.setVerticalScrollBarEnabled(true);
        m_horizontalscroll.setDrawingCacheBackgroundColor(-65536);
        m_horizontalscroll.setFadingEdgeLength(0);
        m_horizontalscroll.addView((View)m_tabWidget);
        if (!this.ShowTable.booleanValue()) {
            m_horizontalscroll.setVisibility(8);
        }
        m_layout.addView((View)m_horizontalscroll);
        m_tabWidget.setStripEnabled(false);
        this.m_TabHost.addView((View)m_layout);
        this.m_TabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener(){

            public void onTabChanged(String tabId) {
                TabControl.this.lasttablocation = TabControl.this.currenttablocation;
                TabControl.this.currenttablocation = TabControl.this.m_TabHost.getCurrentTab();
                TabControl.this.setSelect(TabControl.this.m_TabHost.getCurrentTab());
                if (TabControl.this.Tablistener != null) {
                    TabControl.this.Tablistener.OnClickTab(tabId);
                }
                if (TabControl.this.ShowLable.booleanValue()) {
                    TabControl.this.Lable.setText((CharSequence)TabControl.this.Tabshowtext[TabControl.this.currenttablocation]);
                }
                viewPage.setCurrentItem(Integer.valueOf(tabId).intValue());
                if (TabControl.this.ShowPoint.booleanValue() && !TabControl.this.ShowLable.booleanValue()) {
                    TabControl.this.point.setPageState(Integer.valueOf(tabId));
                }
            }
        });
        viewPage.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (TabControl.this.Tablistener != null) {
                    TabControl.this.Tablistener.ChangeView();
                }
                return false;
            }
        });
        MyPagerAdapter myAdapter = new MyPagerAdapter();
        viewPage.setAdapter((PagerAdapter)myAdapter);
        viewPage.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int arg0) {
                TabControl.this.m_TabHost.setCurrentTab(arg0);
                if (TabControl.this.lasttablocation > arg0 && arg0 % TabControl.this.displayCount + 1 >= TabControl.this.displayCount) {
                    m_horizontalscroll.scrollTo((arg0 - TabControl.this.displayCount + 1) * TabControl.this.TabWidth, 0);
                }
                if (TabControl.this.lasttablocation <= arg0 && arg0 >= TabControl.this.displayCount) {
                    m_horizontalscroll.scrollTo((arg0 - TabControl.this.displayCount + 1) * TabControl.this.TabWidth, 0);
                }
                if (TabControl.this.Tablistener != null) {
                    TabControl.this.Tablistener.ChangeView();
                }
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageScrollStateChanged(int arg0) {
            }
        });
        return this.m_TabHost;
    }

    private static LinearLayout initLinearLayout() {
        LinearLayout tempLayout = new LinearLayout(m_context);
        return tempLayout;
    }

    static {
        textSize = 18;
        textColor = -1;
        tabselect = null;
        tabunselect = null;
        tabdivider = null;
    }

    private class MyPagerAdapter
    extends PagerAdapter {
        private MyPagerAdapter() {
        }

        public void destroyItem(View arg0, int arg1, Object arg2) {
            ((ViewPager)arg0).removeView(TabControl.this.TabView[arg1]);
        }

        public void finishUpdate(View arg0) {
        }

        public int getCount() {
            return TabControl.this.TabView.length;
        }

        public Object instantiateItem(View arg0, int arg1) {
            ((ViewPager)arg0).addView(TabControl.this.TabView[arg1], 0);
            return TabControl.this.TabView[arg1];
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }

        public void restoreState(Parcelable arg0, ClassLoader arg1) {
        }

        public Parcelable saveState() {
            return null;
        }

        public void startUpdate(View arg0) {
        }
    }
}

