/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.nutnet;

import com.xdja.Exception.CErrorInfo;
import com.xdja.gprsconverter.convert.ConvertFactory;
import com.xdja.nutnet.Callback;
import com.xdja.nutnet.NutNetClient;
import com.xdja.nutnet.NutNetLog;
import com.xdja.publicclass.SocketManager;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

public class SocketRequest<Q, T> {
    private static final String TAG = SocketRequest.class.getSimpleName();
    public static final int SAFE_CHANNEL = 1;
    public static final int UNSAFE_CHANNEL = 0;
    private Disposable mDisposable;
    private SocketManager socketManager;
    private int isSafe;

    public Observable<T> sendRequest(final @NonNull Q request, final @NonNull Class<T> classOfT) {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(@NonNull ObservableEmitter<T> e) throws Exception {
                String requestStr = ConvertFactory.generateXML((Object)request);
                NutNetLog.i(TAG, "requestStr=" + requestStr);
                NutNetClient.Config config = NutNetClient.getInstance().getConfig();
                SocketRequest.this.isSafe = config.isSafe() ? 1 : 0;
                SocketManager.setTimeout((long)(config.getConnectTimeout() * 1000));
                SocketRequest.this.socketManager = new SocketManager(SocketRequest.this.isSafe, config.getHost(), config.getPort());
                String response = SocketRequest.this.socketManager.execute(requestStr);
                NutNetLog.i(TAG, "response=" + response);
                CErrorInfo.paserErrorMsg((String)response);
                if (CErrorInfo.isError && !CErrorInfo.message.contains("\u4fee\u6539\u5bc6\u7801\u6210\u529f")) {
                    if (CErrorInfo.code.equals("0x13014034") || CErrorInfo.message.contains("\u767b\u5f55\u8d85\u65f6")) {
                        config.getTimeoutListener().onTimeout();
                    }
                    Throwable throwable = new Throwable(response);
                    e.onError(throwable);
                } else {
                    e.onNext(new ConvertFactory().parserResponse(response, classOfT));
                    e.onComplete();
                }
            }
        });
        return observable;
    }

    public void sendRequest(@NonNull Q request, @NonNull Class<T> classOfT, final @NonNull Callback<T> callback) {
        this.sendRequest(request, classOfT).observeOn(Schedulers.io()).subscribeOn(AndroidSchedulers.mainThread()).subscribe(new Observer<T>(){

            public void onSubscribe(@NonNull Disposable d) {
                NutNetLog.i(TAG, "onSubscribe");
                SocketRequest.this.mDisposable = d;
                callback.onStart();
            }

            public void onNext(@NonNull T t) {
                NutNetLog.i(TAG, "onNext");
                callback.onSuccess(t);
            }

            public void onError(@NonNull Throwable e) {
                NutNetLog.i(TAG, "onError");
                CErrorInfo.paserErrorMsg((String)e.getMessage());
                callback.onFial(CErrorInfo.code, CErrorInfo.message);
            }

            public void onComplete() {
                NutNetLog.i(TAG, "onComplete");
            }
        });
    }

    public void cancel() {
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
        if (this.socketManager != null) {
            this.socketManager.disConnect();
        }
    }
}

