package com.xdja.nutnet;

/**
 * Created by Guojie on 2017/9/6.
 */

public class NutNetClient {
    private static NutNetClient instance;
    private Config config;
    private String host;
    private String port;
    private boolean showLog;
    private boolean isSafe;
    private int connectTimeout;

    private NutNetClient() {
        config = new Config();
    }

    public Config getConfig() {
        return config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public static NutNetClient getInstance() {
        if (instance == null) {
            synchronized (NutNetClient.class) {
                if (instance == null) {
                    instance = new NutNetClient();
                }
            }
        }
        return instance;
    }

    public static class Config {
        private String host;
        private String port;
        private boolean showLog;
        private boolean isSafe;
        private int connectTimeout;
        private TimeoutListener timeoutListener;

        public Config() {
            host = "127.0.0.1";
            port = "2003";
            showLog = true;
            isSafe = true;
            connectTimeout = 30;
        }

        public Config setHost(String host) {
            this.host = host;
            return this;
        }

        public Config setPort(String port) {
            this.port = port;
            return this;
        }

        public Config showLog(boolean showLog) {
            this.showLog = showLog;
            return this;
        }

        public Config setSafe(boolean isSafe) {
            this.isSafe = isSafe;
            return this;
        }

        public Config setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public TimeoutListener getTimeoutListener() {
            return timeoutListener;
        }

        public void setTimeoutListener(TimeoutListener timeoutListener) {
            this.timeoutListener = timeoutListener;
        }

        public String getHost() {
            return host;
        }

        public String getPort() {
            return port;
        }

        public boolean isShowLog() {
            return showLog;
        }

        public boolean isSafe() {
            return isSafe;
        }

        public int getConnectTimeout() {
            return connectTimeout;
        }
    }
}
