package com.xdja.nutnet;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

/**
 * Created by Guojie on 2017/9/6.
 */

public class NutNetClient {
    private static final String SP_NAME = "config.sp";
    private static NutNetClient instance;
    private Config config;
    private String host;
    private String port;
    private boolean showLog;
    private boolean isSafe;
    private int connectTimeout;
    private Context mcontext;
    private SharedPreferences sp;

    private NutNetClient() {
        config = new Config();
    }

    public void setConfig(Config config) {
        this.config.setHost(config.getHost())
                .setPort(config.getPort())
                .setConnectTimeout(config.getConnectTimeout())
                .setSafe(config.isSafe)
                .setTimeoutListener(config.getTimeoutListener());
    }

    public Config getConfig() {
        return config;
    }

    public static NutNetClient getInstance() {
        if (instance == null) {
            synchronized (NutNetClient.class) {
                if (instance == null) {
                    instance = new NutNetClient();
                }
            }
        }
        return instance;
    }

    public NutNetClient init(Context context) {
        mcontext = context.getApplicationContext();
        sp = mcontext.getSharedPreferences(SP_NAME, Context.MODE_PRIVATE);
        return instance;
    }

    public static class Config {
        private String host;
        private String port;
        private boolean showLog;
        private boolean isSafe;
        private int connectTimeout;
        private TimeoutListener timeoutListener;

        public Config() {
            host = "127.0.0.1";
            port = "2003";
            showLog = true;
            isSafe = true;
            connectTimeout = 30;
        }

        public Config setHost(String host) {
            this.host = host;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit()
                        .putString("ip", host)
                        .commit();
            }
            return this;
        }

        public Config setPort(String port) {
            this.port = port;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit()
                        .putString("port", port)
                        .commit();
            }
            return this;
        }

        public Config showLog(boolean showLog) {
            this.showLog = showLog;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit()
                        .putBoolean("showlog", showLog)
                        .commit();
            }
            return this;
        }

        public Config setSafe(boolean isSafe) {
            this.isSafe = isSafe;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit()
                        .putBoolean("isSafe", isSafe)
                        .commit();
            }
            return this;
        }

        public Config setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public TimeoutListener getTimeoutListener() {
            return timeoutListener;
        }

        public void setTimeoutListener(TimeoutListener timeoutListener) {
            this.timeoutListener = timeoutListener;
        }

        public String getHost() {
            if (NutNetClient.getInstance().sp!=null){
                SharedPreferences sharedPreferences=NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty(sharedPreferences.getString("ip",""))){
                    return sharedPreferences.getString("ip","");
                }
                return host;
            }
            return host;
        }

        public String getPort() {
            if (NutNetClient.getInstance().sp!=null){
                SharedPreferences sharedPreferences=NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty(sharedPreferences.getString("port",""))){
                    return sharedPreferences.getString("port","");
                }
                return port;
            }
            return port;
        }

        public boolean isShowLog() {
            if (NutNetClient.getInstance().sp!=null){
                SharedPreferences sharedPreferences=NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty(sharedPreferences.getString("port",""))){
                    return sharedPreferences.getBoolean("showlog",true);
                }
                return showLog;
            }
            return showLog;
        }

        public boolean isSafe() {
            if (NutNetClient.getInstance().sp!=null){
                SharedPreferences sharedPreferences=NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty(sharedPreferences.getString("port",""))){
                    return sharedPreferences.getBoolean("isSafe",true);
                }
                return isSafe;
            }
            return isSafe;
        }

        public int getConnectTimeout() {
            return connectTimeout;
        }
    }
}
