/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.nutnet;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.xdja.nutnet.TimeoutListener;

public class NutNetClient {
    private static final String SP_NAME = "config.sp";
    private static NutNetClient instance;
    private Config config = new Config();
    private String host;
    private String port;
    private boolean showLog;
    private boolean isSafe;
    private int connectTimeout;
    private Context mcontext;
    private SharedPreferences sp;

    private NutNetClient() {
    }

    public void setConfig(Config config) {
        this.config.setHost(config.getHost()).setPort(config.getPort()).setConnectTimeout(config.getConnectTimeout()).setSafe(config.isSafe).setTimeoutListener(config.getTimeoutListener());
    }

    public Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NutNetClient getInstance() {
        if (instance != null) return instance;
        Class<NutNetClient> clazz = NutNetClient.class;
        synchronized (NutNetClient.class) {
            if (instance != null) return instance;
            instance = new NutNetClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public NutNetClient init(Context context) {
        this.mcontext = context.getApplicationContext();
        this.sp = this.mcontext.getSharedPreferences(SP_NAME, 0);
        return instance;
    }

    public static class Config {
        private String host = "127.0.0.1";
        private String port = "2003";
        private boolean showLog = true;
        private boolean isSafe = true;
        private int connectTimeout = 30;
        private TimeoutListener timeoutListener;

        public Config setHost(String host) {
            this.host = host;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit().putString("ip", host).commit();
            }
            return this;
        }

        public Config setPort(String port) {
            this.port = port;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit().putString("port", port).commit();
            }
            return this;
        }

        public Config showLog(boolean showLog) {
            this.showLog = showLog;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit().putBoolean("showlog", showLog).commit();
            }
            return this;
        }

        public Config setSafe(boolean isSafe) {
            this.isSafe = isSafe;
            if (NutNetClient.getInstance().sp != null) {
                NutNetClient.getInstance().sp.edit().putBoolean("isSafe", isSafe).commit();
            }
            return this;
        }

        public Config setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public TimeoutListener getTimeoutListener() {
            return this.timeoutListener;
        }

        public Config setTimeoutListener(TimeoutListener timeoutListener) {
            this.timeoutListener = timeoutListener;
            return this;
        }

        public String getHost() {
            if (NutNetClient.getInstance().sp != null) {
                SharedPreferences sharedPreferences = NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty((CharSequence)sharedPreferences.getString("ip", ""))) {
                    return sharedPreferences.getString("ip", "");
                }
                return this.host;
            }
            return this.host;
        }

        public String getPort() {
            if (NutNetClient.getInstance().sp != null) {
                SharedPreferences sharedPreferences = NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty((CharSequence)sharedPreferences.getString("port", ""))) {
                    return sharedPreferences.getString("port", "");
                }
                return this.port;
            }
            return this.port;
        }

        public boolean isShowLog() {
            if (NutNetClient.getInstance().sp != null) {
                SharedPreferences sharedPreferences = NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty((CharSequence)sharedPreferences.getString("port", ""))) {
                    return sharedPreferences.getBoolean("showlog", true);
                }
                return this.showLog;
            }
            return this.showLog;
        }

        public boolean isSafe() {
            if (NutNetClient.getInstance().sp != null) {
                SharedPreferences sharedPreferences = NutNetClient.getInstance().sp;
                if (!TextUtils.isEmpty((CharSequence)sharedPreferences.getString("port", ""))) {
                    return sharedPreferences.getBoolean("isSafe", true);
                }
                return this.isSafe;
            }
            return this.isSafe;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }
    }
}

