package com.xdja.Exception;

public class CErrorInfo {
	static String[][] ErrMsgList = new String[][] { 
			
			/*
			 * Tf卡错误信息
			 */
			{"0x10010001","未知错误"},
			{"0x10010002","参数错误"},
			{"0x10010003","参数不足"},
			{"0x10010010","数据错误"},
			{"0x10010011","应用错定"},
			{"0x10010012","文件不存在"},
			{"0x10010013","命令不存在"},
			{"0x10010014","文件空间不足"},
			{"0x10010015","未取随机数"},
			{"0x10010016","文件已存在"},
			{"0x10010017","文件内容错"},
			{"0x10010018","错误的状态"},
			{"0x10010019","卡锁定"},
			{"0x10010021","命令与内容不附"},
			{"0x10010022","权限不够"},
			{"0x10010023","密钥死锁"},
			{"0x10010024","口令错误"},
			{"0x10010032","MAC错误"},
			{"0x10010033","密钥不存在"},
			{"0x10010034","密钥类型错"},
			{"0x10010035","密钥文件不存在"},
			{"0x10010100","未找到卡"},
			{"0x10010101","非安全TF卡"},
			{"0x10010102","读卡标识失败"},
			{"0x10010103","指定盘不存在"},
			{"0x10010200","发送指令失败"},
			{"0x10010201","接收指令失败"},
			{"0x10010202","分配内存失败"},
			{"0x10010203","响应信息解码错误"},
			{"0x10010204","返回错误长度"},
			{"0x10010205","缓冲区长度不够"},
			{"0x10010206","接收命令超时"},
			{"0x10010207","接收命令标签无效"},
			{"0x10010208","COS没有收到指令,可以选择重新发送"},
			{"0x10010209","COS忙,需要等待"},
			{"0x10010300","调用者传输参数错误"},
			{"0x10010301","数据过长"},
			{"0x10010302","数据无效"},
			{"0x10010303","数据校验失败"},
			{"0x10010400","卡复位错误"},
			{"0x10010500","导入导出公钥错误"},
			{"0x10010501","导入私钥错误"},
			{"0x10010550","当前容器已经被使用"},
			{"0x10010551","当前容器未使用"},
			{"0x10010552","超过最大容器个数"},
			{"0x10010559","卡内无容器"},
			{"0x10010600","读写卡内文件错误"},
			{"0x10010800","事务标识创建失败"},
			{"0x10010801","事务标识检测超时"},
			{"0x10010900","输出缓冲区错误"},
			{"0x10011000","句柄无效"},
			
			/*
			 * 安全客户端错误信息
			 */
			{"0x10021001","参数无效"},
			{"0x10021002","安全卡未初始化或未认证"},
			{"0x10021003","处理线程启动失败"},
			{"0x10021100","网络异常"},
			{"0x10021101","IP地址无效"},
			{"0x10021102","连接错误"},
			{"0x10021103","发送数据失败"},
			{"0x10021104","接收数据失败"},
			{"0x10021105","接收数据超时"},
			{"0x10021106","没有建立拨号连接"},
			{"0x10021107","拨号连接错误"},
			{"0x10021108","拨号连接已经断开"},
			{"0x10021109","数据过大"},
			{"0x10021110","数据无效"},
			{"0x10021111","接收数据"},
			{"0x10021112","远程主机强行关闭"},
			{"0x10021120","SSL握手错误"},
			{"0x10021121","客户端CLIENTHELLO错误"},
			{"0x10021122","服务端SERVERHELLO错误"},
			{"0x10021123","读取根证书错误"},
			{"0x10021124","验证服务器证书失败"},
			{"0x10021125","取服务端公钥"},
			{"0x10021126","证书不被支持"},
			{"0x10021127","证书已经撤消"},
			{"0x10021128","证书过期"},
			{"0x10021129","服务端密钥交换错误"},
			{"0x10021130","客户端证书请求错误"},
			{"0x10021131","取客户端证书失败"},
			{"0x10021132","客户端证书校验错误"},
			{"0x10021133","客户端证书无效"},
			{"0x10021138","客户端交换加密算法失败"},
			{"0x10021139","客户端交换密钥错误"},
			{"0x10021140","转换主密钥失败"},
			{"0x10021141","密钥分配内存失败"},
			{"0x10021142","交换加密说明错误"},
			{"0x10021149","时间校验失败,请确认系统当前时间"},
			{"0x10021150","结束消息错误"},
			{"0x10021151","交换加密说明失败"},
			{"0x10021160","加密数据失败"},
			{"0x10021161","解密数据失败"},
			{"0x10021162","摘要检验出错"},
			{"0x10021170","传输过程记录标签无效"},
			{"0x10021171","记录消息无效"},
			{"0x10021501","检测终端信息失败"},
			{"0x10021502","终端状态认证失败"},
			{"0x10021503","启动命令服务失败"},
			{"0x10021504","终端无任何权限"},
			{"0x10021505","安全TF卡认证失败"},
			{"0x10021506","启动SSL认证模块失败"},
			{"0x10021507","TF卡号校验失败"},
			{"0x10021508","手机IMEI号校验失败"},
			{"0x10021509","IMSI号校验失败"},
			{"0x10021510","信息已收集,待审核"},
			{"0x10021511","认证接口未知错误"},
			{"0x10021601","虚拟网卡启动失败"},
			{"0x10021602","虚拟网卡IP设置失败"},
			{"0x10021603","添加路由信息失败"},
			
			/*
			 * 应用连接安全客户端的错误
			 */
			{ "0x10032001", "安全客户端连接建立超时" }, { "0x10032002", "未正常登录到安全客户端" },
			{ "0x10032003", "启动安全客户端失败" }, { "0x10032004", "状态认证返回格式不正确" },
			{ "0x10032005", "连接状态查询端口失败" }, { "0x10032006", "接收状态查询数据失败" },
			{ "0x10032007", "安全客户端程序不存在" }, { "0x10032008", "连接安全客户端失败" },
			{ "0x10032009", "连接vpn服务失败" }, { "0x10032010", "vpn连接建立超时" },
			
			/*
			 * 查询或者插入更新后，后台无响应错误代码
			 */
			{ "0x10032100", "后台未返回数据" }, { "0x10032101", "后台返回数据无效" },
			{ "0x10032102", "分页信息分析失败" }, 
			
			/*
			 * 外部设备错误代码客户端网络错误代码
			 */
			{ "0x10032200", "打开打印机串口失败" }, { "0x10032201", "打印失败" },
			{ "0x10032202", "关闭打印机串口失败" }, { "0x10032203", "打开二代证读卡器串口失败" },
			{ "0x10032204", "二代证读卡器读卡失败" }, { "0x10032205", "关闭二代证读卡器串口失败" },
			{ "0x10032300", "连接网络失败,请检查网络是否开启" }, { "0x10032301", "发送数据不能为空" },
			{ "0x10032302", "发送数据超时" }, { "0x10032303", "发送数据失败" },
			{ "0x10032304", "连接服务器失败,IP或者端口不正确" },
			{ "0x10032305", "接收数据解压出错" }, { "0x10032306", "接收数据异常,数据接收失败" },
			{ "0x10032307", "接收数据超时" }, { "0x10032308", "输出流对象为空" },
			{ "0x10032309", "输入流对象为空" }, { "0x10032310", "检测安全代理失败" },
			{ "0x10032311", "无线网络连接失败" }, { "0x10032312", "取数据长度错误" },
			{ "0x10032313", "未收到任何数据" }, 
			
			/*
			 * 客户端数据错误代码
			 */
			{ "0x10032400", "生成请求字符失效" },
			{ "0x10032401", "获取sim卡信息失败" }, { "0x10032402", "数据库初始化失败" },
			{ "0x10032403", "获取APN列表信息失败" }, { "0x10032404", "查询系统配制信息失败" },
			{ "0x10032405", "打开数据库错误" }, { "0x10032406", "执行exe_cmd函数出错" },
			{ "0x10032407", "执行get_datareader函数出错" },
			{ "0x10032408", "执行get_dataset函数出错" },
			{ "0x10032409", "执行exe_rownum函数出错" },
			{ "0x10032410", "执行get_cmdline函数出错" },
			{ "0x10032411", "执行GetSingle函数出错" }, { "0x10032412", "填充公用代码失败" },
			{ "0x10032413", "xml文档转换失败,可能是数据包接收不完整" },
			{ "0x10032414", "启动升级程序失败" }, { "0x10032415", "升级文件不存在" },
			{ "0x10032416", "本地认证失败" }, { "0x10032417", "加载处理窗体失败" },
			{ "0x10032418", "查找图标文件失败" }, { "0x10032419", "返回时间格式不正确" },
			{ "0x10032420", "生成配置文件失败" }, { "0x10032421", "数据转换失败" },
			{ "0x10032422", "修改图片大小错误" }, { "0x10032423", "照片过大,内存溢出" } };

	static String[][] ErrPromptList = new String[][] {
			{ "0x10010001", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010002", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010003", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010011", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010012", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010013", "提示：提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010015", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010016", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010017", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010018", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010019", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010021", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010022", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010023", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010032", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010033", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010034", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010035", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010100", "提示：请确认是否插好安全TF卡或插入的是非安全TF卡" },
			{ "0x10010101", "提示：请确认是否插好安全TF卡或插入的是非安全TF卡" },
			{ "0x10010102", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010103", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010200", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010201", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010202", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010203", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010204", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010300", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010400", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010500", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010501", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010600", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10010900", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10011000", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021001", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021002", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021100", "提示：请检查是否'数据开启'或者寻找强信号源" },
			{ "0x10021101", "提示:请查看安全客户端IP地址是否设置正确" },
			{ "0x10021102", "提示:请查看安全客户端IP地址是否设置正确" },
			{ "0x10021103", "提示：请重新提交内容或退出警务通重新登录" },

			{ "0x10021104", "提示：请重新提交内容" },
			{ "0x10021105", "提示：请退出当前查询，重试" },
			{ "0x10021106", "提示：请检查是否'数据开启'或者寻找强信号源" },
			{ "0x10021107", "提示：请检查手机卡是否正常或'数据开启'是否打开" },
			{ "0x10021108", "提示：请检查手机卡是否正常或'数据开启'是否打开" },
			{ "0x10021109", "提示：请重新提交内容" },
			{ "0x10010302", "提示：请重新提交内容" },
			{ "0x10021111", "接收数据" },
			{ "0x10021120", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021121", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021122", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021123", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021124", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021125", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021129", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021130", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021131", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021132", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021133", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021138", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021139", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021140", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021141", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021142", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021150", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021151", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021160", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021161", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021162", "提示:请重新拔插安全TF卡或重启手机" },
//			{ "-2000", "请退出警务通系统重新登录" },

			{ "0x10021502", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021503", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021504", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021505", "提示:请重新拔插安全TF卡或重启手机" },//
			{ "0x10021506", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021601", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021602", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021603", "提示:请重新拔插安全TF卡或重启手机" },
			{ "0x10021149", "提示:请调整把手机时间调整为当前时间" },
			// 应用连接安全客户端的错误

			// 应用连接安全客户端的错误
			//******************************没有友情提示 start***********************************
			{ "0x10032001", "安全客户端连接建立超时" }, { "0x10032002", "未正常登录到安全客户端" },
			{ "0x10032003", "启动安全客户端失败" }, { "0x10032004", "状态认证返回格式不正确" },
			{ "0x10032005", "连接状态查询端口失败" }, { "0x10032006", "接收状态查询数据失败" },
			{ "0x10032007", "安全客户端程序不存在" },
			{ "0x10032009", "提示:可能是当前网络信号弱,请检查安全客户端是否存在或是否能单独启动成功" },
			{ "0x10032010", "提示:请检查手机网络信号是否太差" }, { "0x10032101", "后台返回数据无效" },
			{ "0x10032102", "分页信息分析失败" }, { "0x10032200", "打开打印机串口失败" }, { "0x10032201", "打印失败" },
			{ "0x10032202", "关闭打印机串口失败" }, { "0x10032203", "打开二代证读卡器串口失败" },
			{ "0x10032204", "二代证读卡器读卡失败" }, { "0x10032205", "关闭二代证读卡器串口失败" },
			{ "0x10032302", "发送数据超时" }, { "0x10032310", "检测安全代理失败" },
			{ "0x10032311", "无线网络连接失败" }, { "0x10032312", "取数据长度错误" },
			{ "0x10032313", "未收到任何数据" }, { "0x10032404", "查询系统配制信息失败" },
			{ "0x10032405", "打开数据库错误" }, { "0x10032406", "执行exe_cmd函数出错" },
			{ "0x10032407", "执行get_datareader函数出错" },
			{ "0x10032408", "执行get_dataset函数出错" },
			{ "0x10032409", "执行exe_rownum函数出错" },
			{ "0x10032410", "执行get_cmdline函数出错" },
			{ "0x10032411", "执行GetSingle函数出错" }, { "0x10032412", "填充公用代码失败" },
			{ "0x10032413", "xml文档转换失败,可能是数据包接收不完整" },
			{ "0x10032414", "启动升级程序失败" }, { "0x10032415", "升级文件不存在" },
			{ "0x10032416", "本地认证失败" }, { "0x10032417", "加载处理窗体失败" },
			{ "0x10032418", "查找图标文件失败" }, { "0x10032419", "返回时间格式不正确" },
			{ "0x10032420", "生成配置文件失败" }, { "0x10032421", "数据转换失败" },
			{ "0x10032422", "修改图片大小错误" }, { "0x10032423", "照片过大,内存溢出" },
			//********************************end******************************************
			
//			{ "-2502", "" },
			// 查询或者插入更新后，后台无响应错误
			{ "0x10032100", "提示:请检查网络是否正常或退出警务通重新登陆" },
			// 客户端网络错误
			{ "0x10032300", "提示:请检查是否'数据开启'或者寻找强信号源" },
			{ "0x10032008", "提示:请检查安全客户端是否正常或退出警务通重新登陆" },
			// { "-2802", "提示:请退出警务通重新登录再试" },
			{ "0x10032303", "提示:请检查网络是否正常或重新登陆警务通" },
			{ "0x10032304", "提示:请检查警务通配置IP地址是否设置正确" },
			{ "0x10032305", "提示:请检查网络是否正常或重新登陆警务通" },
			{ "0x10032306", "提示:网络不稳定或者信号不好,请调整所处位置,或者重新进行当前操作" },
			{ "0x10032307", "提示:请检查网络是否正常或重新登陆警务通" },
			{ "0x10032308", "提示:请检查网络是否正常或重新登陆警务通" },
			{ "0x10032309", "提示:请检查网络是否正常或重新登陆警务通" },
			{ "0x10032301", "提示:请检查网络是否正常或重新登陆警务通" },
			// 其他错误提示
			{ "0x10032400", "提示:上传数据失败，请检查输入项，再重新上传" },
			{ "0x10032401", "提示:检查手机sim卡是否正确安装或者当前手机是否正在连接到电脑" },
			// 客户端数据库错误
			{ "0x10032402", "提示:警务通已经损坏请重新安全警务通软件" },
			{ "0x10032403", "提示:请检查手机sim卡是否正常或重新启动手机" }

	};
	
	static String[][] ErroMesg2tf = {
		{"0x10010001", "-1"},
		{"0x10010002", "-2"},
		{"0x10010003", "-3"},
		{"0x10010010","-10"},
		{"0x10010011","-11"},
		{"0x10010012","-12"},
		{"0x10010013","-13"},
		{"0x10010014","-14"},
		{"0x10010015","-15"},
		{"0x10010016","-16"},
		{"0x10010017","-17"},
		{"0x10010018","-18"},
		{"0x10010019","-19"},
		{"0x10010021","-21"},
		{"0x10010022","-22"},
		{"0x10010023","-23"},
		{"0x10010024","-24"},
		{"0x10010032","-32"},
		{"0x10010033","-33"},
		{"0x10010034","-34"},
		{"0x10010035","-35"},
		{"0x10010100","-100"},
		{"0x10010101","-101"},
		{"0x10010102","-102"},
		{"0x10010103","-103"},
		{"0x10010200","-200"},
		{"0x10010201","-201"},
		{"0x10010202","-202"},
		{"0x10010203","-203"},
		{"0x10010204","-204"},
		{"0x10010205","-205"},
		{"0x10010206","-206"},
		{"0x10010207","-207"},
		{"0x10010208","-208"},
		{"0x10010209","-209"},
		{"0x10010300","-300"},
		{"0x10010301","-301"},
		{"0x10010302","-302"},
		{"0x10010303","-303"},
		{"0x10010400","-400"},
		{"0x10010500","-500"},
		{"0x10010501","-501"},
		{"0x10010550","-550"},
		{"0x10010551","-551"},
		{"0x10010552","-552"},
		{"0x10010559","-559"},
		{"0x10010600","-600"},
		{"0x10010800","-800"},
		{"0x10010801","-801"},
		{"0x10010900","-900"},
		{"0x10011000","-1000"},
		{"0x10021001","-1001"},
		{"0x10021002","-1002"},
		{"0x10021003","-1003"},
		{"0x10021100","-1100"},
		{"0x10021101","-1101"},
		{"0x10021102","-1102"},
		{"0x10021103","-1103"},
		{"0x10021104","-1104"},
		{"0x10021105","-1105"},
		{"0x10021106","-1106"},
		{"0x10021107","-1107"},
		{"0x10021108","-1108"},
		{"0x10021109","-1109"},
		{"0x10021110","-1110"},
		{"0x10021111","-1111"},
		{"0x10021112","-1112"},
		{"0x10021120","-1120"},
		{"0x10021121","-1121"},
		{"0x10021122","-1122"},
		{"0x10021123","-1123"},
		{"0x10021124","-1124"},
		{"0x10021125","-1125"},
		{"0x10021126","-1126"},
		{"0x10021127","-1127"},
		{"0x10021128","-1128"},
		{"0x10021129","-1129"},
		{"0x10021130","-1130"},
		{"0x10021131","-1131"},
		{"0x10021132","-1132"},
		{"0x10021133","-1133"},
		{"0x10021138","-1138"},
		{"0x10021139","-1139"},
		{"0x10021140","-1140"},
		{"0x10021141","-1141"},
		{"0x10021142","-1142"},
		{"0x10021149","-1149"},
		{"0x10021150","-1150"},
		{"0x10021151","-1151"},
		{"0x10021160","-1160"},
		{"0x10021161","-1161"},
		{"0x10021162","-1162"},
		{"0x10021170","-1170"},
		{"0x10021171","-1171"},
		{"0x10021501","-1501"},
		{"0x10021502","-1502"},
		{"0x10021503","-1503"},
		{"0x10021504","-1504"},
		{"0x10021505","-1505"},
		{"0x10021506","-1506"},
		{"0x10021507","-1507"},
		{"0x10021508","-1508"},
		{"0x10021509","-1509"},
		{"0x10021510","-1510"},
		{"0x10021511","-1511"},
		{"0x10021601","-1601"},
		{"0x10021602","-1602"},
		{"0x10021603","-1603"}
	};
	
	static String[][] tf2ErroMesg = {
		{"-1","0x10010001"},
		{"-2","0x10010002"},
		{"-3","0x10010003"},
		{"-10","0x10010010"},
		{"-11","0x10010011"},
		{"-12","0x10010012"},
		{"-13","0x10010013"},
		{"-14","0x10010014"},
		{"-15","0x10010015"},
		{"-16","0x10010016"},
		{"-17","0x10010017"},
		{"-18","0x10010018"},
		{"-19","0x10010019"},
		{"-21","0x10010021"},
		{"-22","0x10010022"},
		{"-23","0x10010023"},
		{"-24","0x10010024"},
		{"-32","0x10010032"},
		{"-33","0x10010033"},
		{"-34","0x10010034"},
		{"-35","0x10010035"},
		{"-100","0x10010100"},
		{"-101","0x10010101"},
		{"-102","0x10010102"},
		{"-103","0x10010103"},
		{"-200","0x10010200"},
		{"-201","0x10010201"},
		{"-202","0x10010202"},
		{"-203","0x10010203"},
		{"-204","0x10010204"},
		{"-205","0x10010205"},
		{"-206","0x10010206"},
		{"-207","0x10010207"},
		{"-208","0x10010208"},
		{"-209","0x10010209"},
		{"-300","0x10010300"},
		{"-301","0x10010301"},
		{"-302","0x10010302"},
		{"-303","0x10010303"},
		{"-400","0x10010400"},
		{"-500","0x10010500"},
		{"-501","0x10010501"},
		{"-550","0x10010550"},
		{"-551","0x10010551"},
		{"-552","0x10010552"},
		{"-559","0x10010559"},
		{"-600","0x10010600"},
		{"-800","0x10010800"},
		{"-801","0x10010801"},
		{"-900","0x10010900"},
		{"-1000","0x10011000"},
		{"-1001","0x10021001"},
		{"-1002","0x10021002"},
		{"-1003","0x10021003"},
		{"-1100","0x10021100"},
		{"-1101","0x10021101"},
		{"-1102","0x10021102"},
		{"-1103","0x10021103"},
		{"-1104","0x10021104"},
		{"-1105","0x10021105"},
		{"-1106","0x10021106"},
		{"-1107","0x10021107"},
		{"-1108","0x10021108"},
		{"-1109","0x10021109"},
		{"-1110","0x10021110"},
		{"-1111","0x10021111"},
		{"-1112","0x10021112"},
		{"-1120","0x10021120"},
		{"-1121","0x10021121"},
		{"-1122","0x10021122"},
		{"-1123","0x10021123"},
		{"-1124","0x10021124"},
		{"-1125","0x10021125"},
		{"-1126","0x10021126"},
		{"-1127","0x10021127"},
		{"-1128","0x10021128"},
		{"-1129","0x10021129"},
		{"-1130","0x10021130"},
		{"-1131","0x10021131"},
		{"-1132","0x10021132"},
		{"-1133","0x10021133"},
		{"-1138","0x10021138"},
		{"-1139","0x10021139"},
		{"-1140","0x10021140"},
		{"-1141","0x10021141"},
		{"-1142","0x10021142"},
		{"-1149","0x10021149"},
		{"-1150","0x10021150"},
		{"-1151","0x10021151"},
		{"-1160","0x10021160"},
		{"-1161","0x10021161"},
		{"-1162","0x10021162"},
		{"-1170","0x10021170"},
		{"-1171","0x10021171"},
		{"-1501","0x10021501"},
		{"-1502","0x10021502"},
		{"-1503","0x10021503"},
		{"-1504","0x10021504"},
		{"-1505","0x10021505"},
		{"-1506","0x10021506"},
		{"-1507","0x10021507"},
		{"-1508","0x10021508"},
		{"-1509","0x10021509"},
		{"-1510","0x10021510"},
		{"-1511","0x10021511"},
		{"-1601","0x10021601"},
		{"-1602","0x10021602"},
		{"-1603","0x10021603"}
	};
	
	/**
	 * 根据错误消息找到错误代码（TF错误）
	 * @param MsgID 错误消息ID
	 * @return 错误代码
	 */
	public static String getTf2ErrorCode(String MsgID) {
		
		if (MsgID != null && MsgID.substring(0, 1).equals("-")) {
			for (int i = 0; i < tf2ErroMesg.length; i++) {
				
				if (tf2ErroMesg[i][0].equals(MsgID)) {
					return MsgID = tf2ErroMesg[i][1];
				}
			}
		}
		
		return "";
	}
	
	/**
	 * 根据错误代码找到错误消息（TF错误）
	 * @param MsgID 错误代码
	 * @return 错误消息
	 */
	public static String errorCode2GetTf(String MsgID) {
		
		for (int i = 0; i < ErroMesg2tf.length; i++) {
			
			if (ErroMesg2tf[i][0].equals(MsgID)) {
				return MsgID = ErroMesg2tf[i][1];
			}
		}
		return "";
	}


	/**
	 * 根据错误编号取友情提示信息
	 * @param MsgID 错误ID
	 * @return 对应的友情提示
	 */
	public static String getCPramMsg(String MsgID) {
		
		if (MsgID != null && MsgID.substring(0, 1).equals("-")) {
			for (int i = 0; i < tf2ErroMesg.length; i++) {
				
				if (tf2ErroMesg[i][0].equals(MsgID)) {
					MsgID = tf2ErroMesg[i][1];
					break;
				}
			}
		}
		
		for (int i = 0; i < ErrPromptList.length; i++) {

			if (ErrPromptList[i][0].equals(MsgID)) {
				return ErrPromptList[i][1];
			}
		}
		return "";
	}

	/**
	 * 根据错误编号取错误描述信息
	 * @param MsgID  错误ID
	 * @return  对应的错误信息
	 */
	public static String getCErrMsg(String MsgID) {
		if (MsgID != null && MsgID.substring(0, 1).equals("-")) {
			for (int i = 0; i < tf2ErroMesg.length; i++) {
				
				if (tf2ErroMesg[i][0].equals(MsgID)) {
					MsgID = tf2ErroMesg[i][1];
					break;
				}
			}
		}
		for (int i = 0; i < ErrMsgList.length; i++) {
			
			if (ErrMsgList[i][0].equals(MsgID)) {
				return ErrMsgList[i][1];
			}
		}
		return "";
	}

	/**
	 * 根据错误编号取错误信息和友情提示
	 * 
	 * @param 错误ID
	 * @return 对应的错误信息+友情提示
	 */
	public static String getMsg(String MsgID) {
		return getCPramMsg(MsgID) + "\r\n" + "错误:" + MsgID + ":"
				+ getCErrMsg(MsgID);
	}
	
	//是否有错误
	public static boolean isError = true;
	//错误的中文描述
	public static String message = "";
	//错误代码
	public static String code = "未定义错误";
	
	/**
	 * 根据错误描述解析错误信息
	 * @param msg 错误信息
	 */
	public static void paserErrorMsg(String msg) {
		isError = true;//回复现场
		if (msg == null) {
			message = "保存失败，未返回结果!";
		} else if (msg.length() < 2) {
			message = "发送失败，未返回数据";
		} else if (msg.startsWith("-")) {
			message = CErrorInfo.getMsg(msg);
			code = CErrorInfo.getTf2ErrorCode(msg);
		} else if (msg.startsWith("0x00000000") || msg.startsWith("0x1301")) {
			message = msg.substring(10);
			code = msg.substring(0, 10);
		} else if (msg.startsWith("0x1003")) {
			message = CErrorInfo.getCPramMsg(msg.substring(0, 10));
			code = msg.substring(0, 10);
		} else isError = false;
		
	}
}
