/*
 * 网络通信类，负责发送和接收数据,并进行数据压缩和解压
 * and open the template in the editor.
 */
package com.xdja.publicclass;

import android.content.Context;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ClientSocket implements Runnable {
	@SuppressWarnings("unused")
	private Context context;
	private String sip = null;// 服务器IP
	private String sport = null;// 服务器端口
	private static Socket conn = null;
	public InputStream sin = null;// 网络输入流
	public OutputStream sou = null;// 网络输出流
	private static String connstr = null;// 连接字符串
	public String errmsg = "";// 全局错误信息
	public String sendstr = null;// 要发送的字符串
	public String recstr = null;// 接收到的字符串
	public boolean connected = false;// 是否已经连接网络
	public boolean sended = false;// 是否发送成功
	public static final int PACKAGE_SIZE = 1024;// 传输包大小
	public long TIMEOUT = 60000;// 超时时长(30秒)
	public SocketListener sl = null;// 网络收发事件接收者
	public String reqtag = "";// 请求类别，在事件通知时回送
	
	public boolean isBigData = false;    //added by sunwx at 20120328 大附件上传使用 

//	public ClientSocket() {
//		sip = UserCache.serverIP;
//		sport = UserCache.serverPort;
//	}
	
		
	public ClientSocket(SocketListener sl, String reqtag) {
		this.sl = sl;
		this.reqtag = reqtag;
	}

	public ClientSocket(String sendstr) {
		this.sendstr = sendstr;
	}

	public ClientSocket(SocketListener sl, String reqtag, String sendstr) {
		this.sl = sl;
		this.sendstr = sendstr;
		this.reqtag = reqtag;
	}

	/**
	 * 指定连接服务器的参数
	 * 
	 * @param ip
	 *            服务器IP
	 * @param port
	 *            服务器端口号
	 */
	public ClientSocket(String ip, String port) {

		sip = ip;
		sport = port;
	}
	
	
	/**
	 * 大附件上传使用
	 * added by sunwx at 20120328 
	 * @param ip
	 *            服务器IP
	 * @param port
	 *            服务器端口号
	 * @param isBigData
	 *            是否为长数据
	 */
	public ClientSocket(String ip, String port, boolean isBigData) {

		sip = ip;
		sport = port;
		this.isBigData = isBigData;
		TIMEOUT = 600000;            //10分钟超时
	}


	/**
	 * 连接服务器
	 * 
	 * @return 成功返回0 不成功返回-1 errmsg中包含错误信息
	 */
	public int connect() {
		setConnected(false);
		// Thread connThread = new Thread(new Connecter(), "conn_hread");
		Thread connThread = new Thread(new Connecter());
		connThread.start();
		long ctime = System.currentTimeMillis();
		while (!connected) {

			if (System.currentTimeMillis() - ctime > TIMEOUT) {
//				sl.passResult(reqtag, "-1 连接网络超时");

				errmsg = "连接网络超时";
				// connThread.interrupt();
				connThread = null;
				notifyListener();
				break;
			}
			if (!connThread.isAlive()) {
				break;
			}
		}
		if (connected) {
			return 0;
		} else {
			return -1;
		}
	}

	/**
	 * 断开连接
	 */
	public void disConnect() {

		try {
			if(sin!=null)
			{
			sin.close();
			}
			if(sou!=null)
			{
			sou.close();
			}
			if(conn!=null)
			{
				conn.close();
			}
			setConnected(false);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	public void notifyListener() {
		synchronized (this) {
			try {
				this.notify();
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println(e.getMessage());
			}
		}
	}

	/**
	 * 线程调用此方法发送数据
	 */
	public void receiveData() {
		if (sl == null) {
			return;
		}
		if (connect() != 0) {
			sl.passResult(reqtag, "-1 连接网络失败");
			notifyListener();
			return;
		}
		if (sendstr == null || sendstr.equals("")) {
			sl.passResult(reqtag, "-1 发送数据不能为空");
			notifyListener();
			return;
		}
		setSended(false);
		Sender sender = new Sender();
		// Thread sendthread = new Thread(sender, "send_thread");
		Thread sendthread = new Thread(sender);
		sendthread.start();
		long ctime = System.currentTimeMillis();
		// debug infor
		System.out.println("begin to seng： " + sip + sport);
		while (!sended) {
			if (System.currentTimeMillis() - ctime >= TIMEOUT) {
				// sendthread.interrupt();
				sendthread = null;
				setSended(false);
				sl.passResult(reqtag, "-1 发送数据超时");
				notifyListener();
				return;
			}
			if (!sendthread.isAlive()) {
				break;
			}
		}
		if (!sended) {
			sl.passResult(reqtag, "-1 发送数据失败：" + recstr);
			notifyListener();
			return;
		}
		// Thread recthread = new Thread(new Receiver(), "rec_thread");
		setRecstr(null);
		Thread recthread = new Thread(new Receiver());
		recthread.start();

		ctime = System.currentTimeMillis();
		// debug infor
		System.out.println("begin to receive：" + sip + sport);
		while (recstr == null) {
			if (System.currentTimeMillis() - ctime >= TIMEOUT) {
				// recthread.interrupt();
				recthread = null;
				sl.passResult(reqtag, "-1 接收数据超时");
				notifyListener();
				return;
			}
		}
		sl.passResult(reqtag, recstr);
		disConnect();
		notifyListener();
	}

	/**
	 * 发送并接收数据
	 * 
	 * @param senddata
	 *            要发送的数据
	 * @return 接收到的数据
	 */
	public String receiveData(String senddata) {
		if (!connected) {
			return ("-1 连接网络失败");
		}

		setSended(false);
		sendstr = senddata;
		// Thread sendthread = new Thread(new Sender(), "rec_thread");
		Thread sendthread = new Thread(new Sender());
		sendthread.start();
		long ctime = System.currentTimeMillis();
		while (!sended) {
			if (System.currentTimeMillis() - ctime >= TIMEOUT) {
				// sendthread.interrupt();
				sendthread = null;
				setSended(false);
				setRecstr("-1 发送数据超时");
				break;
			}
			if (!sendthread.isAlive()) {
				break;
			}
		}
		if (!sended)// 如果发送成功
		{
			disConnect();
			return ("-1 发送数据失败");
		}
		// Thread recthread = new Thread(new Receiver(), "rec_thread");
		Thread recthread = new Thread(new Receiver());
		recthread.start();
		setRecstr(null);
		ctime = System.currentTimeMillis();
		while (recstr == null) {
			if (System.currentTimeMillis() - ctime >= TIMEOUT) {
				// recthread.interrupt();
				recthread = null;
				setRecstr("-1 接收数据超时");
				break;
			}
		}
		disConnect();
		return recstr;
	}

	/**
	 * 设置服务器IP
	 * 
	 * @param sip
	 *            当前要连接服务器的IP
	 */
	public void setSip(String sip) {
		this.sip = sip;
	}

	/**
	 * 设置要连接服务器的端口
	 * 
	 * @param sport
	 *            当前连接的服务器端口
	 */
	public void setSport(String sport) {
		this.sport = sport;
	}

	/**
	 * 设置从网络收到的内容
	 * 
	 * @param rec
	 *            实际收到或设置的内容
	 */
	synchronized public void setRecstr(String rec) {
		recstr = rec;
	}

	/**
	 * 设置要发送的字符串
	 * 
	 * @param sendstr
	 *            要发送的字符串
	 */
	synchronized public void setSendStr(String sendstr) {
		this.sendstr = sendstr;
	}

	/**
	 * 设置事件接收者
	 * 
	 * @param sl
	 *            事件接收类
	 */
	synchronized public void setListener(SocketListener sl) {
		this.sl = sl;
	}

	/**
	 * 设置请求类别
	 * 
	 * @param reqtag
	 *            请求类别
	 */
	synchronized public void setReqtag(String reqtag) {
		this.reqtag = reqtag;
	}

	/**
	 * 设置是否发送数据成功
	 * 
	 * @param state
	 */
	synchronized public void setSended(boolean state) {
		sended = state;
	}

	/**
	 * 设置是否已经连接网络
	 * 
	 * @param state
	 *            连网状态
	 */
	synchronized public void setConnected(boolean state) {
		connected = state;
	}

	/**
	 * 连接网络，由于j2me在连网时不能放到一个线程中，所以单独起线程连网
	 */
	class Connecter implements Runnable {

		Connecter() {
		}

		public void run() {
			connectNetwork();
		}

		private void connectNetwork() {
			try {
				if (sip == null || sport == null || sip.equals("")
						|| sport.equals("")) {
					if (sl != null) {
						sl.passResult(reqtag, "-1 连接服务器失败，IP或端口设置不正确");
						notifyListener();
					}
					setConnected(false);
					return;
				}

				conn = new Socket(sip, Integer.parseInt(sport));
				sin = conn.getInputStream();
				sou = conn.getOutputStream();
				setConnected(true);
				// debug infor
				System.out.println("connect ok：" + sip + sport);
			} catch (Exception e) {
				errmsg = e.getMessage();
				setConnected(false);
				// debug infor
				System.out.println("connect error：" + sip + sport);
				System.out.println(errmsg);
			}
		}
	}

	/**
	 * 发送数据类，单独线程
	 */
	class Sender implements Runnable {

		Sender() {
		}

		public void run() {
			if(isBigData){
				sendBigData();
			} else {
				sendData();
			}
		}

		/**
		 * 发送数据
		 */
		private void sendData() {
			if (!connected) {
				setRecstr("-1 网络未连接");
				setSended(false);
				return;
			}
			if (sou == null) {
				setRecstr("-1 网络初始化失败");
				setSended(false);
				return;
			}
			byte[] sendbyte = Functions.formatSocketSendData(sendstr);			
			// if (sendbyte.length <= PACKAGE_SIZE) {
			try {
				sou.write(sendbyte);
				sou.flush();
				setSended(true);// 设置发送标志为真
			} catch (IOException ex) {
				ex.printStackTrace();
				setSended(true);// 设置发送标志为真
			}
			/*
			 * } else { int sendlen = sendbyte.length; int sendpoint = 0; int
			 * clen = 0; while (sendlen > 0) { try { if (sendlen - sendpoint >=
			 * PACKAGE_SIZE) { clen = PACKAGE_SIZE; } else { clen = sendlen -
			 * sendpoint; } sou.wwrite(sendbyte, sendpoint, clen); sou.flush();
			 * sendpoint = sendlen - PACKAGE_SIZE; sendlen -= PACKAGE_SIZE; }
			 * catch (IOException ex) { ex.printStackTrace(); setSended(false);
			 * } } setSended(true); }
			 */
		}
		
		/** added by sunwx at 20120328
		 * 发送长数据
		 */
		private void sendBigData() {
			if (!connected) {
				setRecstr("-1 网络未连接");
				setSended(false);
				return;
			}
			if (sou == null) {
				setRecstr("-1 网络初始化失败");
				setSended(false);
				return;
			}
			//byte[] sendbyte = Functions.FormatSocketSendData(sendstr);
			byte[] sendbyte = sendstr.getBytes();
			byte[] lenbyte = Functions.intToBytes4(sendbyte.length);
			// if (sendbyte.length <= PACKAGE_SIZE) {
			try {
				sou.write(lenbyte);
				sou.write(sendbyte);
				sou.flush();
				setSended(true);// 设置发送标志为真
			} catch (IOException ex) {
				ex.printStackTrace();
				setSended(true);// 设置发送标志为真
			}
		}
	}

	/**
	 * 接收数据，可放入单独的线程中
	 */
	class Receiver implements Runnable {

		Receiver() {
		}

		public void run() {
			if(isBigData){
				receiveBigData();
			} else {
				receiveData();
			}
		}

		private void receiveData() {
			if (sin == null) {
				setRecstr("-1 网络连接无效");
				return;
			}
			try {
				byte[] lengthBuf = new byte[4];
				readFully(sin, lengthBuf);
				int length = Functions.bytes4ToInt(lengthBuf);
				byte[] temp = new byte[length];
				readFully(sin, temp);
				byte[] unzipdata;

				unzipdata = Gzip.unzip(temp);
				
				String result = new String(unzipdata, "UTF-8");
				setRecstr(result);
			} catch (IOException ex) {
				System.out.println("************"+ex.getMessage());
//				ex.printStackTrace();
				setRecstr("-1 请检查网络连接是否正常, 请稍后重试!");
			}

			disConnect();// 关闭连接
		}
		
		
		
		private void receiveBigData() {
			if (sin == null) {
				setRecstr("-1 网络连接无效");
				return;
			}
			try {
				byte[] lengthBuf = new byte[4];
				readFully(sin, lengthBuf);
				int length = Functions.bytes4ToInt(lengthBuf);
				byte[] temp = new byte[length];
				readFully(sin, temp);
				//byte[] unzipdata;
//				if (logIn.isDesjm) {
//					DesEcrypt de = new DesEcrypt();
//					unzipdata = de.DesEncrypt(temp, 0);
//				} else {
//					unzipdata = Gzip.unzip(temp);
//				}
//				String result = new String(unzipdata, "UTF-8");
//				setRecstr(result);
				setRecstr(new String(temp));
			} catch (IOException ex) {
				ex.printStackTrace();
				setRecstr("-1 请检查网络连接是否正常, 请稍后重试!");
			}

			disConnect();// 关闭连接
		}
		
	}

	private static void readFully(InputStream in, byte[] buffer)
			throws IOException {
		int bytesRead = 0;
		while (bytesRead < buffer.length) {
			int count = in.read(buffer, bytesRead, buffer.length - bytesRead);
			if (count == -1) {
				throw new IOException("Input stream closed");
			}
			bytesRead += count;
		}
	}

	public void run() {
		this.receiveData();
	}

	public void shutDownThread() {
		this.disConnect();
	}
 /************************字典更新添加的功能*******************************/
	/**
	 * 长连接发送数据
	 * 
	 * @param senddata
	 *            要发送的数据
	 * @return 结果
	 */
	public String sendDataLong(String senddata) {
		if (!connected) {
			return ("-1 连接网络失败");
		}

		setSended(false);
		sendstr = senddata;
		Thread sendthread = new Thread(new Sender());
		sendthread.start();
		long ctime = System.currentTimeMillis();
		while (!sended) {
			if (System.currentTimeMillis() - ctime >= TIMEOUT) {
				// sendthread.interrupt();
				sendthread = null;
				setSended(false);
				setRecstr("-1 发送数据超时");
				break;
			}
			if (!sendthread.isAlive()) {
				break;
			}
		}
		if (!sended)// 如果发送成功
		{
			disConnect();
			return ("-1 发送数据失败");
		}
		return "0";
	}

}
