package com.xdja.publicclass;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class DBHelper {
    public static final String TAG = "DBHelper";// 调试标签
    public  SQLiteDatabase db;
    private SQLiteDatabase sqliteDB = null;//
    private String DBFile;//数据库全路径
    private String DBName;//数据库名称
    private Context context;//上下文句柄

    /**
     * 初始化数据操作类
     *
     * @param _context 当前窗体句柄
     * @param dbFile   数据库全路径
     * @param dbName   数据库名称
     */
    public DBHelper(Context _context, String dbFile, String dbName) {
        this.context = _context;
        this.DBFile = dbFile;
        this.DBName = dbName;
        openDatabase();
    }

    public DBHelper(String dbFile, String dbName) {
        this.DBFile = dbFile;
        this.DBName = dbName;
        if (sqliteDB == null) {
            sqliteDB = SQLiteDatabase.openDatabase(DBFile, null, 0);
        } else {
            if (!sqliteDB.isOpen())
                sqliteDB = SQLiteDatabase.openDatabase(DBFile, null, 0);
        }
        db = sqliteDB;
    }

    //将数据库文件写入应用程序私有目录下
    private void copyToPrivateDir() {
        if (context == null || DBFile == null || DBName == null)
            throw new NullPointerException();
        /*
		 * 拷贝数据库文件
		 */
        if (!(new File(DBFile).exists())) {

            InputStream in = null;
            FileOutputStream out = null;

            try {
                in = (InputStream) context.getResources().getAssets()
                        .open(DBName);
                out = context.openFileOutput(DBName, Context.MODE_PRIVATE);

                byte[] buffer = new byte[8192];
                int count = 0;
                // 开始复制dictionary.db文件
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                }
            } catch (Exception ioe) {
                ioe.printStackTrace();
                return;
            } finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }

        }
    }

    // ==================end构造处理====================

    // ==================数据库处理====================

    /**
     * 打开数据库
     */
    public void openDatabase() {
        if (sqliteDB == null) {
            copyToPrivateDir();
            sqliteDB = SQLiteDatabase.openDatabase(DBFile, null, 0);
        } else {
            if (!sqliteDB.isOpen())
                sqliteDB = SQLiteDatabase.openDatabase(DBFile, null, 0);
        }
    }

    /**
     * 关闭数据库
     */
    public void closeDatabase() {
        sqliteDB.close();
    }

    public void close() {
        this.sqliteDB.close();
    }

    /**
     * 开启事务
     */
    public void beginTransaction() {
        if (isClosed()) {
            openDatabase();
        }
        sqliteDB.beginTransaction();
    }

    public String getLocalConfig(String tablename, String configName) {
        this.openDatabase();
        Cursor c = null;

        try {
            String e = "select c_configvalue from " + tablename + " where c_configname = \'" + configName + "\'";
            c = this.sqliteDB.rawQuery(e, (String[]) null);
            if (c == null) {
                return "";
            }

            c.moveToFirst();
            String configValue = c.getString(c.getColumnIndex("c_configvalue"));
            Log.v("DBHelper", "select configName " + configValue);
            c.close();
            String var7 = configValue;
            return var7;
        } catch (Exception var10) {
            var10.printStackTrace();
        } finally {
            if (c != null) {
                c.close();
            }

            this.closeDatabase();
        }

        return "";
    }
    public SQLiteDatabase getDB() {
        return this.sqliteDB;
    }
    /**
     * 提交事务
     */
    public void commitTransaction() {
        // 必须在endTransaction前进行setTransactionSuccessful，否则为回滚
        sqliteDB.setTransactionSuccessful();
        sqliteDB.endTransaction();
    }

    /**
     * 回滚事务
     */
    public void rollback() {
        sqliteDB.endTransaction();
    }

    /**
     * 数据库是否锁定
     *
     * @return 是否
     */
    public boolean isLocked() {
        if (isClosed()) {
            openDatabase();
        }
        if (sqliteDB.isDbLockedByOtherThreads()) {
            return true;
        }
        return false;
    }

    /**
     * 数据库是否关闭
     *
     * @return
     */
    public boolean isClosed() {
        if (!sqliteDB.isOpen()) {
            return true;
        }
        return false;
    }

    // ==================end数据库处理====================

    // ==================操作处理====================

    /**
     * 执行一条语句，返回查询结果。
     *
     * @param 查询结果语句
     * @return 查询结果（String）
     */
    public String getSingle(String SQLString) {
        if (isClosed()) {
            openDatabase();
        }
        Cursor c = null;
        try {
            c = sqliteDB.rawQuery(SQLString, null);
            if (c != null && c.getCount() > 0) {
                c.moveToFirst();
                String name = c.getString(0);
                return name;
            } else {
                return "";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        } finally {
            if (c != null && !c.isClosed()) {
                c.close();
                c = null;
            }
        }

    }

    /**
     * 执行查询SQL语句;
     *
     * @param sql 查询语句
     * @return 查询结果游标
     */
    public Cursor query(String sql) {
        if (isClosed()) {
            openDatabase();
        }
        Cursor c = null;
        try {
            c = sqliteDB.rawQuery(sql, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    /**
     * 执行带参数查询SQL语句
     *
     * @param sql语句
     * @param selectionArgs where条件参数
     * @return 查询结果游标
     */
    public Cursor query(String sql, String[] selectionArgs) {
        if (isClosed()) {
            openDatabase();
        }
        Cursor c = null;
        try {
            c = sqliteDB.rawQuery(sql, selectionArgs);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    /**
     * 执行带参数查询SQL语句
     *
     * @param table         表名
     * @param columns       字段列表
     * @param selection     查询条件字段列表
     * @param selectionArgs 查询条件值列表
     * @return
     */
    public Cursor query(String table, String[] columns, String selection,
                        String[] selectionArgs) {
        if (isClosed()) {
            openDatabase();
        }
        Cursor c = null;
        try {
            c = sqliteDB.query(table, columns, selection, selectionArgs, null,
                    null, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return c;

    }

    /**
     * 执行带参数,分组,排序查询SQL语句
     *
     * @param table         表名
     * @param columns       字段列表
     * @param selection     查询条件字段列表
     * @param selectionArgs 查询条件值列表
     * @param groupBy       分组语句
     * @param having        having语句
     * @param orderBy       排序字段
     * @return
     */
    public Cursor query(String table, String[] columns,
                        String selection, String[] selectionArgs, String groupBy,
                        String having, String orderBy) {
        if (isClosed()) {
            openDatabase();
        }
        Cursor c = null;
        try {
            c = sqliteDB.query(table, columns, selection, selectionArgs, groupBy,
                    having, orderBy);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    /**
     * 新增,更新,删除操作
     *
     * @param sql
     * @throws SQLException
     */
    public void execSQL(String sql) throws SQLException {
        if (isClosed()) {
            openDatabase();
        }
        sqliteDB.execSQL(sql);
    }
    /**
     * 新增,更新,删除操作
     *
     * @param sql
     * @throws SQLException
     */
    public void execSql(String sql) throws SQLException {
        execSQL(sql);
    }
    public static byte[] FormatSocketSendData(String str) {
        if(str == null) {
            return null;
        } else {
            byte[] tbyte = Gzip.zip(getUTF8Bytes(str));
            byte[] lenbyte = IntToBytes4(tbyte.length);
            byte[] allbyte = new byte[tbyte.length + 4];
            System.arraycopy(lenbyte, 0, allbyte, 0, 4);
            System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
            Object tbyte1 = null;
            Object lenbyte1 = null;
            return allbyte;
        }
    }
    public static byte[] getUTF8Bytes(String s) {
        char[] c = s.toCharArray();
        int len = c.length;
        int count = 0;

        for(int b = 0; b < len; ++b) {
            char off = c[b];
            if(off <= 127) {
                ++count;
            } else if(off <= 2047) {
                count += 2;
            } else {
                count += 3;
            }
        }

        byte[] var8 = new byte[count];
        int var9 = 0;

        for(int i = 0; i < len; ++i) {
            char ch = c[i];
            if(ch <= 127) {
                var8[var9++] = (byte)ch;
            } else if(ch <= 2047) {
                var8[var9++] = (byte)(ch >> 6 | 192);
                var8[var9++] = (byte)(ch & 63 | 128);
            } else {
                var8[var9++] = (byte)(ch >> 12 | 224);
                var8[var9++] = (byte)(ch >> 6 & 63 | 128);
                var8[var9++] = (byte)(ch & 63 | 128);
            }
        }

        return var8;
    }

    public static int Bytes4ToInt(byte[] b) {
        short mask = 255;
        boolean temp = false;
        int res = 0;

        for(int i = 0; i < 4; ++i) {
            res <<= 8;
            int var5 = b[i] & mask;
            res |= var5;
        }

        return res;
    }

    public static byte[] IntToBytes4(int num) {
        byte[] b = new byte[4];

        for(int i = 0; i < 4; ++i) {
            b[i] = (byte)(num >> 24 - i * 8);
        }

        return b;
    }
    public void updataLocalConfig(String tablename, String name, String value) {
        this.openDatabase();

        try {
            ContentValues e = new ContentValues();
            e.put("c_configvalue", value);
            String[] selectionArgs = new String[]{name};
            this.db.update(tablename, e, "c_configname==?", selectionArgs);
        } catch (Exception var9) {
            var9.printStackTrace();
        } finally {
            this.closeDatabase();
        }

    }
    /**
     * 带参数的新增,更新,删除操作
     *
     * @param sql
     * @param bindArgs
     * @throws SQLException
     */
    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (isClosed()) {
            openDatabase();
        }
        sqliteDB.execSQL(sql, bindArgs);
    }

    /**
     * 删除语句
     *
     * @param table       表名
     * @param whereClause 条件字段列表
     * @param whereArgs   条件值列表
     * @return
     */
    public int delete(String table, String whereClause,
                      String[] whereArgs) {
        if (isClosed()) {
            openDatabase();
        }
        return sqliteDB.delete(table, whereClause, whereArgs);
    }

    /**
     * 新增数据
     *
     * @param table          表名
     * @param nullColumnHack
     * @param values         数据
     * @return
     */
    public long insert(String table, String nullColumnHack, ContentValues values) {
        if (isClosed()) {
            openDatabase();
        }
        return sqliteDB.insert(table, nullColumnHack, values);
    }


    /**
     * 更新语句
     *
     * @param table       表名
     * @param values      要更新的字段值
     * @param whereClause 更新条件字段
     * @param whereArgs   更新条件字段值
     * @return
     */
    public int update(String table, ContentValues values,
                      String whereClause, String[] whereArgs) {
        if (isClosed()) {
            openDatabase();
        }
        return sqliteDB.update(table, values, whereClause, whereArgs);

    }
    //===================end操作处理==================
}
