package com.xdja.publicclass;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.MessageDigest;

import com.xdja.Exception.CErrorInfo;
import com.xdja.operation.DBHelperOperation;
import com.xdja.publicclass.Functions;
import com.xdja.publicclass.XMLParser;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences.Editor;
import android.os.AsyncTask;
import android.widget.Toast;

/**
 * 交管字典升级功能文件，主要是本地字典的升级
 * */
public class DictUpdata {
	public final static String YWZDXZ = "zdxz";
	public final static String BZDZKXZ = "dzkxz";
	public final static String XZQH	="xzqh";
	private DBHelperOperation dbHelperOperation;
	/** 保存文件的绝对路径 */
	private String fileDir = "/mnt/sdcard";
	private String changeDate = ""; // 服务器更新时间戳
	private Context context = null;
	private String fileName = "";
	private String changeWhosTime;
	private String sessionId;
	private String ip;
	private String port;
	private Intent intent;
	/**
	 * 构造函数
	 * 
	 * @param context
	 *            窗体句柄
	 * @param dbFile
	 *            数据库路径
	 * @param dbName
	 *            数据库名称
	 * @param _dict
	 *            保存目录
	 * @param _fileName
	 * @param sessionId
	 * @param ip
	 * @param port
	 * @param intent 下载出错时返回的intent
	 */
	public DictUpdata(Context context, String dbFile, String dbName,
			String _dict, String _fileName, String sessionId, String ip,
			String port,Intent intent) {
		this.context = context;
		this.fileName = _fileName;
		this.sessionId = sessionId;
		this.ip = ip;
		this.port = port;
		dbHelperOperation = new DBHelperOperation(context, dbFile, dbName);
		// 判断目录是否存在
		this.fileDir = _dict;
		this.intent = intent;
		File fileDir = new File(this.fileDir);
		if (!fileDir.exists()) {
			fileDir.mkdirs();
		}
	}

	/**
	 * 执行下载数据库操作
	 * @param str 数据库文件名
	 * DictUpdata.YWZDXZ
	 * DictUpdata.BZDZKXZ
	 */
	public void startDownLoadFile(String str) {
		String currentfiletime;
		changeWhosTime = str;
		if (str.equals(YWZDXZ)) {
			currentfiletime = dbHelperOperation.getLocalConfig("t_localconfig", "dic_date");
			String[] params = { currentfiletime };
			new QuerydateDic("业务字典").execute(params);
		} else if (str.equals(BZDZKXZ)) {
			currentfiletime = dbHelperOperation.getLocalConfig("t_localconfig", "dzk_date");
			String[] params = { currentfiletime };
			new QuerydateDic("标准地址库").execute(params);
		} else if (str.equals(XZQH)) {
			currentfiletime = dbHelperOperation.getLocalConfig("t_localconfig", "xzqh_date");
			String[] params = { currentfiletime };
			new QuerydateDic("行政区划").execute(params);
		}
	}

	/******************************************** 文件下载代码区 ***************************************************************************/
	public class QuerydateDic extends AsyncTask<String, Integer, Object> {
		private ProgressDialog progressDialog = null;
		XMLParser xmlParser;
		ClientSocket clientSocket = null;
		/** 数据字典名称(中文：交管字典) **/
		private String dbname = "";
		/** 数据字典文件名 **/
		private String dbfilename = "";
		/** 字典文件的绝对路径 **/
		private String filename = "";
		/** 临时文件的绝对路径 **/
		private String tempFilename = null;
		/** 临时文件句柄 **/
		private File tempfile = null;
		/** 要接收的字典文件大小 **/
		private String size = "";
		/** 服务器返回的MD5校验码 **/
		private String receivedCheckcode = "";

		protected QuerydateDic(String name) {
			dbname = name;
		}

		protected void onPreExecute() {
			progressDialog = new ProgressDialog(context);
			progressDialog.setTitle("提示");
			progressDialog.setMessage("检测字典状态...");
			progressDialog.setCancelable(false);
			progressDialog.show();
		}

		protected void onPostExecute(Object obj) {
			String result = (String) obj;
			progressDialog.dismiss();
			if (result.equals("0")) {
				if (changeDate.equals("")) {
					Toast.makeText(context, "字典需要更新，但是没有接收到字典的生成标识",
							Toast.LENGTH_LONG).show();
					return;
				}
				new UpdateDic(dbname, tempfile, tempFilename, size,
						receivedCheckcode, filename).execute(dbfilename);
			} else {
				// XDAlertDialog dialog = null;
				CErrorInfo.paserErrorMsg(result);
				System.out.println(CErrorInfo.isError);
				if (CErrorInfo.isError) {
					Toast.makeText(context, CErrorInfo.message,
							Toast.LENGTH_LONG).show();
					// public void onClick(DialogInterface dialog, int which) {
					if (CErrorInfo.code.equals("0x13014034")) {
//						Intent intent = new Intent();
//						intent.setAction("com.xdja.qdjwt.frame.Login");
						context.startActivity(intent);
						// ActivityStack.finishProgram();
					}
					// }

					// });
					// dialog.show();
					return;
				}
				Toast.makeText(context, (String) obj, Toast.LENGTH_LONG).show();
				if (clientSocket != null) {// 关闭本次连接
					clientSocket.disConnect();
					clientSocket = null;
				}
			}
		}

		@Override
		protected Object doInBackground(String... params) {
			int receivedSize = 0;
			filename = fileDir + "/" + fileName;
			String tempName = fileDir + "/"
					+ fileName.substring(0, fileName.indexOf(".")) + ".mp3";
			XdjaLog.i("tempName", tempName);
			dbfilename = fileName;
			tempFilename = fileDir + "/"
					+ fileName.substring(0, fileName.indexOf(".")) + "_temp.db";
			tempfile = new File(tempFilename);
			if (tempfile.exists()) {
				receivedSize = (int) tempfile.length();
			}
			File file = new File(tempName);
			StringBuilder reqstr = new StringBuilder();
			reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			reqstr.append("<Root>");
			reqstr.append("<ReqType>query_dict</ReqType>");
			reqstr.append("<SessionID>").append(sessionId)
					.append("</SessionID>");
			// add by dut 如果本地没有文件，把日期传空，必须下载
			if (file.exists()) {
				reqstr.append("<ChangeDate>").append(params[0])
						.append("</ChangeDate>");
			} else {
				reqstr.append("<ChangeDate>").append("</ChangeDate>");
			}
			reqstr.append("<Offset>").append(receivedSize).append("</Offset>");
			reqstr.append("<Condition IsRepeat=\"0\" Value=\"\">");
			reqstr.append("<c_name>").append(dbfilename).append("</c_name>");
			reqstr.append("</Condition>");
			reqstr.append("</Root>");

			clientSocket = new ClientSocket(ip, port);
			if (clientSocket.connect() == -1) {
				return "更新字典请求失败";
			}
			XdjaLog.i("request", reqstr.toString());
			String result = clientSocket.receiveData(reqstr.toString());
			XdjaLog.i("result", result);
			if (clientSocket != null) {// 关闭本次连接
				clientSocket.disConnect();
				clientSocket = null;
			}
			if (result == null) {
				return "更新字典请求失败";
			}
			if (result.substring(0, 2).equals("-1")) {
				return result.substring(2);
			}
			if (result.substring(0, 2).equals("00")) {
				return "更新字典请求失败";
			}
			CErrorInfo.paserErrorMsg(result);
			if (CErrorInfo.isError) {
				return result;
			}
			xmlParser = new XMLParser(result);
			changeDate = xmlParser.getElementValue("ChangeDate");
			size = xmlParser.getElementValue("Fsize");
			receivedCheckcode = xmlParser.getElementValue("CheckCode");
			String receiveResult = xmlParser.getElementValue("Result");
			xmlParser.getElementValue("ErrMsg");
			int res = Integer.parseInt(receiveResult);
			xmlParser = null;
			switch (res) {
			case 0:
				return "0";// 进行字典升级,断点续传
			case 1: // 字典不存在";
				return "没有字典文件，请重试";
			case 2: // 字典内容为空
				return "字典内容为空，请重试";
			case 3:// "字典无须更新
				return "字典无需更新";
			case 4: // 偏移量超出文件最大值
			case 5: // 后台字典项改变，mD5值不一致，重新下载
				file.delete();
				receivedSize = 0;
				break;
			default:
				break;
			}
			return "0";
		}
	}

	public class UpdateDic extends AsyncTask<String, Integer, Object> {
		private ProgressDialog mMyProgressDialog = null;
		String dbname = "";// 字典名称
		private String dbfilename = "";// 数据库文件名称
		private int receivedSize = 0;// 当前收到的文件大小
		private File file = null;// 临时文件句柄
		private String tempFilename = null;// 临时文件的绝对路径
		private String size = "";// 要接收的文件大小
		private String receivedCheckcode = "";// 服务器返回的MD5校验码
		private String filename = "";
		ClientSocket cs = null;

		public UpdateDic(String _dbname, File _file, String _tempFilename,
				String _size, String _receivedCheckcode, String _filename) {
			dbname = _dbname;
			file = _file;
			tempFilename = _tempFilename;
			size = _size;
			receivedCheckcode = _receivedCheckcode;
			filename = _filename;
		}

		@Override
		protected void onPreExecute() {
			mMyProgressDialog = new ProgressDialog(context);
			mMyProgressDialog.setMessage("正在下载字典文件");
			// 设置ProgressDialog 进度条进度
			mMyProgressDialog.setMax(100);
			mMyProgressDialog.setProgress(0);
			// 设置ProgressDialog 的进度条是否不明确
			mMyProgressDialog.setIndeterminate(false);
			mMyProgressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
			mMyProgressDialog.setCancelable(false);
			mMyProgressDialog.show();
			super.onPreExecute();
		}

		@Override
		protected void onProgressUpdate(Integer... values) {
			// 更新进度
			mMyProgressDialog.setProgress(values[0]);
			BigDecimal fileofsize = new BigDecimal(values[2] / 1024).setScale(
					0, BigDecimal.ROUND_HALF_UP);
			BigDecimal currentofsize = new BigDecimal(values[1] / 1024)
					.setScale(0, BigDecimal.ROUND_HALF_UP);
//			String loadnumber = String.valueOf(values[0]) + "%";
			mMyProgressDialog.setMessage("正在下载字典文件" + currentofsize.toString()
					+ "K/" + fileofsize.toString() + "K");
		}

		@Override
		protected Object doInBackground(String... params) {
			dbfilename = params[0];
			// add by dut
			if (file != null) {
				receivedSize = (int) file.length();
			}
			// end add
			StringBuilder reqstr = new StringBuilder();
			reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			reqstr.append("<Root>");
			reqstr.append("<ReqType>download_dict</ReqType>");
			reqstr.append("<SessionID>").append(sessionId)
					.append("</SessionID>");
			reqstr.append("<DictMd5>").append(receivedCheckcode)
					.append("</DictMd5>");
			reqstr.append("<Offset>").append(receivedSize).append("</Offset>");
			reqstr.append("<Condition IsRepeat=\"1\" Value=\"\">");
			reqstr.append("<![CDATA[c_name=").append(dbfilename).append("]]>");
			reqstr.append("</Condition>");
			reqstr.append("</Root>");
			cs = new ClientSocket(ip, port);
			if (cs.connect() == -1) {
				return "socket连接失败";
			};
			// 发送完数据不断开，直接接收数据
			String respStr = cs.sendDataLong(reqstr.toString());

			if (!respStr.equals("0")) {
				return "发送数据失败";
			}
			int filesize = Integer.parseInt(size);
			int currentSize = 0;
			boolean flag = true;
			boolean readflag = true;
			currentSize = receivedSize;

			while (currentSize < filesize) {
				// filesize = 30;
				byte[] data = new byte[10240];
				int currentLen = 0;
				byte[] unzipdata;
				try {
					if (cs == null) {
						return "socket连接关闭";
					}
					currentLen = cs.sin.read(data, 0, 10240);
					unzipdata = data;
				} catch (Exception e) {
					if (cs.sin != null) {
						try {
							cs.sin.close();
						} catch (IOException e1) {
							e1.printStackTrace();
						}
					}
					e.printStackTrace();
					return "接收字典文件数据超时";
				}

				if (currentLen == -1) {
					return "接收字典文件数据错误";
				} else {
					currentSize += currentLen;
					FileOutputStream out = null;
					publishProgress(
							((int) ((currentSize / (float) filesize) * 100)),
							currentSize, filesize);
					try {
						out = new FileOutputStream(tempFilename, true);
						// out.write(unzipdata, 0, currentLen);
						out.write(unzipdata, 0, currentLen);
						out.flush();
						out.close();
					} catch (Exception e) {
						e.printStackTrace();
						if (out != null) {
							try {
								out.close();
							} catch (IOException e1) {
								e1.printStackTrace();
							}
						}
						return "字典文件写入错误";
					}
					if (readflag == true) {
						Editor share = context.getSharedPreferences("jwt", 0)
								.edit();
						share.putString("DictMd5" + dbfilename,
								receivedCheckcode);
						share.commit();
						readflag = false;
					}

					// 修改文件给与其他包读的权限
					if ((flag == true) && (file.exists() == true)) {
						try {
							Runtime.getRuntime().exec(
									"chmod 644 " + tempFilename);
							flag = false;
						} catch (Exception e) {
							flag = true;
							e.printStackTrace();
						}
					}
					if (currentSize >= filesize) {
						// 利用校验码进行校验证
						try {
							String Code = getHash(tempFilename, "MD5");
							receivedCheckcode = receivedCheckcode.toLowerCase();
							if (!Code.equals(receivedCheckcode)) {
								Editor share = context.getSharedPreferences(
										"jwt", 0).edit();
								share.putString("DictMd5" + dbfilename,
										"checkfail");
								share.commit();
								file.delete();
								XdjaLog.i("下载文件Md5", Code);
								XdjaLog.i("后台文件Md5", receivedCheckcode);
								return "文件校验失败，请重试！" + Code + ":"
										+ receivedCheckcode;
							} else {
								file.getName();
								String tempStr = fileName.substring(0,
										fileName.indexOf("."))
										+ ".mp3";
								filename = fileDir + "/" + tempStr;
								File origFile = new File(filename);
								file.renameTo(origFile);
							}
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}
			}

			return dbname + "字典更新成功";
		}

		@Override
		protected void onPostExecute(Object result) {
			String resultstr = String.valueOf(result);
			if (resultstr.indexOf("字典更新成功") != -1) {
				if (changeWhosTime.equals(YWZDXZ)) {
					dbHelperOperation.updataLocalConfig("t_localconfig", "dic_date",
							changeDate);
				} 
				else if (changeWhosTime.equals(BZDZKXZ)) {
					dbHelperOperation.updataLocalConfig("t_localconfig", "dzk_date",
							changeDate);
				}
				else if (changeWhosTime.equals(XZQH)) {
					dbHelperOperation.updataLocalConfig("t_localconfig", "xzqh_date",
							changeDate);
				} 
			}
			mMyProgressDialog.dismiss();
			if (cs != null) {// 关闭本次连接
				cs.disConnect();
				cs = null;
			}
			Functions.popAlert(DictUpdata.this.context, "提示", (String) result);
			super.onPostExecute(result);
		}
	}

	private String getHash(String fileName, String hashType) throws Exception {
		InputStream fis;
		fis = new FileInputStream(fileName);// 读取文件
		byte[] buffer = new byte[2048];
		MessageDigest md5 = MessageDigest.getInstance(hashType);
		int numRead = 0;
		while ((numRead = fis.read(buffer)) > 0) {
			md5.update(buffer, 0, numRead);
		}
		fis.close();
		return toHexString(md5.digest());
	}

	private String toHexString(byte[] b) {
		StringBuilder sb = new StringBuilder(b.length * 2);
		for (int i = 0; i < b.length; i++) {
			sb.append(hexChar[(b[i] & 0xf0) >>> 4]);
			sb.append(hexChar[b[i] & 0x0f]);
		}
		return sb.toString();
	}

	private char[] hexChar = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
			'a', 'b', 'c', 'd', 'e', 'f' };
}