package com.xdja.publicclass;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.Socket;
import java.security.MessageDigest;

import org.w3c.dom.NodeList;

import android.os.Handler;
import android.os.Message;

/**
 * 文件上传（参数：文件路径,请求类别,服务器地址,服务器端口,消息回调）
 * 
 * @author szj
 * 
 */
public class FileUpLoadOperation {

	private static final int UPLOAD_ING = 666;// 正在上传
	private static final int UPLOAD_SUCCESS = 999; // 上传成功
	private static final int UPLOAD_FAILURE = -110; // 上传失败
	private static final int UPLOAD_FILENOTFOUND = 000;// 文件路径错误
	private static final int UPLOAD_SERVER_NO_RESPONSE = 121; // 服务器没有响应

	/**
	 * 文件路径
	 */
	private String filepath;

	/**
	 * 文件名
	 */
	private String filename;

	/**
	 * 后台存储文件id
	 */
	private String fileid;

	/**
	 * 文件上传请求类别
	 */
	private String req_type;

	/**
	 * 服务器地址
	 */
	private String serverIP;

	/**
	 * 服务器端口
	 */
	private int serverPort;

	/**
	 * 消息回调接口
	 */
	private FileUploadInterface fileUploadInterface;

	/**
	 * 消息队列,接收线程返回消息
	 */
	private Handler mHandler = new Handler() {
		public void handleMessage(Message msg) {
			fileUploadInterface.sendMsg((FileInfoBean) msg.obj);
		};
	};

	/**
	 * 待上传文件
	 */
	private File file;

	/**
	 * 文件信息
	 */
	private File fileinfo;

	/**
	 * 文件信息路径
	 */
	private String fileinfopath;

	/**
	 * 断点续传文件，已上传字节
	 */
	private long Num = (long) 0;

	/**
	 * 文件信息
	 */
	private FileInfoBean fib;

	/**
	 * 构造函数
	 * 
	 * @param filepath
	 *            文件路径
	 * @param req_type
	 *            请求类别
	 * @param serverIP
	 *            服务器地址
	 * @param serverPort
	 *            服务器端口
	 * @param fileUploadInterface
	 *            消息回调(当前Activity)
	 */
	public FileUpLoadOperation(String filepath, String req_type,
			String serverIP, int serverPort,
			FileUploadInterface fileUploadInterface) {
		this.filepath = filepath;
		this.req_type = req_type;
		this.serverIP = serverIP;
		this.serverPort = serverPort;
		this.fileUploadInterface = fileUploadInterface;
	}

	/**
	 * 异步上传文件
	 */
	public void startUpLoad() {
		new FileUploadThread().start();
	}

	class FileUploadThread extends Thread {
		public void run() {

			fib = new FileInfoBean();
			fib.setFilepath(filepath);
			filename = filepath.substring(filepath.lastIndexOf("/") + 1);
			fib.setFilename(filename);

			// 判断待上传文件是否存在
			file = new File(filepath);
			if (!file.exists()) {
				fib.setMessageid(UPLOAD_FILENOTFOUND);
				Message message = new Message();
				message.obj = fib;
				mHandler.sendMessage(message);
				return;
			}

			// 文件信息路径
			fileinfopath = "/mnt/sdcard/fileinfo/"
					+ filename.substring(0, filename.lastIndexOf(".")) + ".txt";

			// 打开文件信息日志(之前上传失败才有此文件)
			fileinfo = new File(fileinfopath);
			if (!fileinfo.exists()) {
				fileid = "";
			} else {
				try {
					String content = ""; // 文件内容字符串
					InputStream instream = new FileInputStream(fileinfo);
					if (instream != null) {
						InputStreamReader inputreader = new InputStreamReader(
								instream);
						BufferedReader buffreader = new BufferedReader(
								inputreader);
						String line;
						// 分行读取
						while ((line = buffreader.readLine()) != null) {
							content += line;
						}
						instream.close();
						fileid = content;
						if (!fileid.equals("")) {
							Num = queryData(fileid);
						}
					}
				} catch (IOException e) {
					e.printStackTrace();
					fileid = "";
					upLoadData();
				}

			}
			upLoadData();
		}
	}

	/**
	 * 查询
	 * 
	 * @param fileid
	 *            文件id
	 * @return length 文件大小
	 */
	private Long queryData(String fileid) {
		String retXml = ""; // 返回字符串
		StringBuilder sb = new StringBuilder();
		sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		sb.append("<Root>");
		sb.append("<ReqType>binary_file_query</ReqType>");// 请求类别
		sb.append("<SessionID>xdja_bs_test</SessionID>");// 会话ID
		sb.append("<Condition><c_id>" + fileid + "</c_id></Condition>");
		sb.append("</Root>");
		String queryStr = sb.toString();
		retXml = inquire(queryStr);
		// 无记录时或产生错误时
		if (retXml.substring(0, 2).equals("00")
				|| retXml.substring(0, 10).equals("0x00000000")) {
			return (long) 0;
		} else if (retXml.substring(0, 2).equals("-1")
				|| retXml.substring(0, 10).equals("0x13014090")) {
			return (long) 0;
		}
		Long length = QueryAnalyseXML(retXml);
		return length;
	}

	/**
	 * 查询
	 * 
	 * @param reqXml
	 * @return
	 */
	private String inquire(String reqXml) {
		String retXml = null;
		Socket socket = null;
		try {
			byte[] req = reqXml.getBytes("UTF-8");
			byte[] data = new byte[4 + req.length];
			byte[] dataLenth = Functions.intToBytes4(data.length - 4);
			System.arraycopy(dataLenth, 0, data, 0, 4);
			System.arraycopy(req, 0, data, 4, req.length);

			socket = new Socket(serverIP, serverPort);
			socket.setSoLinger(true, 10);
			socket.setSoTimeout(20000);
			BufferedOutputStream bos = new BufferedOutputStream(
					socket.getOutputStream());
			BufferedInputStream bis = new BufferedInputStream(
					socket.getInputStream());
			bos.write(data);
			bos.flush();
			retXml = getResultData(bis);
		} catch (Exception e) {
			e.printStackTrace();
			return "00";
		} finally {
			try {
				if (socket != null) {
					socket.close();
					socket = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				return "00";
			}
		}
		return retXml;
	}

	/**
	 * 获得返回的字符串
	 * 
	 * @param input
	 * @return
	 */
	private String getResultData(BufferedInputStream input) {
		try {
			byte[] lengthBuf = new byte[4];
			readyInput(input, lengthBuf);
			int length = Functions.bytes4ToInt(lengthBuf);
			byte[] savedata = new byte[length];
			readyInput(input, savedata);
			return new String(savedata, "utf-8");
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * 读取流的固定位数到数组中
	 * 
	 * @param input
	 * @param buff
	 */
	private void readyInput(BufferedInputStream input, byte[] buff) {
		int bytesRead = 0;
		try {
			while (bytesRead < buff.length) {
				int count = input
						.read(buff, bytesRead, buff.length - bytesRead);
				bytesRead += count;
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 解析查询时返回的XML文件
	 * 
	 * @param xmldata
	 */
	private Long QueryAnalyseXML(String xmldata) {
		XMLParser xp = new XMLParser(xmldata);
		NodeList values = xp.getDoc().getElementsByTagName("Row");
		NodeList data = values.item(2).getChildNodes();
		String length = data.item(0).getTextContent();
		return Long.parseLong(length);
	}

	/**
	 * 封装协议，上传文件
	 */
	private void upLoadData() {
		try {

			String datalength = String.valueOf(file.length());// 文件总长度
			String c_md5 = getFileMd5(file);// 文件MD5
			byte[] fileData = new byte[20 * 1024];
			String retXml = ""; // 返回字符串
			int count = 0;
			FileInputStream fin = new FileInputStream(file);

			while (true) {

				// 断点续传
				if (Num != (long) 0) {
					fin.skip(Num);
				}

				count = fin.read(fileData);
				if (count == -1) {
					break;
				}

				// 封装上传数据协议
				StringBuffer reqstr = new StringBuffer();
				reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
				reqstr.append("<root>");
				reqstr.append("<sid>xdja_bs_test</sid>");// 会话ID
				reqstr.append("<req_type>" + req_type + "</req_type>");// 请求类别
				reqstr.append("<file_id>" + fileid + "</file_id>");// 当文件较大，需要分段上传，第一段数据提交后会得到一个临时文件ID，
																	// 客户端要存储它，再传后续文件内容时，需要将返回的ID填写在此
				reqstr.append("<file_name>" + filename + "</file_name>");// 完整的文件名，包含扩展名
				reqstr.append("<file_length>" + datalength + "</file_length>");// 文件总长度
				reqstr.append("<md5>" + c_md5 + "</md5>");// 文件MD5（32位小写）值，用于服务端校验文件完整性
				reqstr.append("<data_length>" + String.valueOf(count)
						+ "</data_length>");// 当前段数据长度
				reqstr.append("</root>");
				String xmlStr = reqstr.toString();

				retXml = send(xmlStr, fileData, count);

				// 初次上传，确认文件id
				if ((fileid.equals("")) && (retXml != "")) {
					fileid = retXml.substring(2, retXml.length());
					fib.setMessageid(UPLOAD_ING);
				}
				fib.setFileid(fileid);

				if (retXml == "") {
					fib.setMessageid(UPLOAD_SERVER_NO_RESPONSE);
				} else if (retXml.substring(0, 2).equals("-1")) {
					fib.setMessageid(UPLOAD_FAILURE);
				} else if (retXml.equals("0#本段数据传输完毕")) {
					fib.setMessageid(UPLOAD_ING);
				} else if (retXml.equals("0#文件保存成功")) {
					fib.setMessageid(UPLOAD_SUCCESS);
				}

				Message message = new Message();
				message.obj = fib;
				mHandler.sendMessage(message);
				if ((fib.getMessageid() == UPLOAD_SUCCESS)
						|| (fib.getMessageid() == UPLOAD_ING)) {
					deletelog(fileid);
				} else {
					makelog(fileid);
					break;
				}
			}
			fin.close();
		} catch (Exception e) {
			e.printStackTrace();
			fib.setMessageid(UPLOAD_SERVER_NO_RESPONSE);
			Message message = new Message();
			message.obj = fib;
			mHandler.sendMessage(message);
			makelog(fileid);
		}
	}

	/**
	 * 获取文件的Md5
	 * 
	 * @param file
	 * @return
	 */
	private String getFileMd5(File file) {
		if (!file.isFile()) {
			return null;
		}
		MessageDigest digest = null;
		FileInputStream in = null;
		byte buffer[] = new byte[1024];
		int len;
		try {
			digest = MessageDigest.getInstance("MD5");
			in = new FileInputStream(file);
			while ((len = in.read(buffer, 0, 1024)) != -1) {
				digest.update(buffer, 0, len);
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		BigInteger bigInt = new BigInteger(1, digest.digest());
		if (bigInt.toString(16).length() < 32) {
			String s = "";
			for (int i = 0; i < 32 - bigInt.toString(16).length(); i++) {
				s += "0";
			}
			return s + bigInt.toString(16);
		}
		return bigInt.toString(16);
	}

	/**
	 * 上传文件
	 * 
	 * @param reqXml
	 *            协议xml串
	 * @param fileData
	 *            数据
	 * @return retXml 服务器返回消息
	 */
	private String send(String reqXml, byte[] fileData, int count) {
		String retXml = "";
		Socket socket = null;
		try {
			byte[] data = new byte[4 + 16 + 512 + count];
			byte[] dataLenth = Functions.intToBytes4(data.length - 4);
			byte[] bfp = "binaryFileUpload".getBytes();
			byte[] req = reqXml.getBytes("UTF-8");
			System.arraycopy(dataLenth, 0, data, 0, 4);
			System.arraycopy(bfp, 0, data, 4, 16);
			System.arraycopy(req, 0, data, 20, req.length);
			System.arraycopy(fileData, 0, data, 532, count);

			socket = new Socket(serverIP, serverPort);
			socket.setSoLinger(true, 10);
			socket.setSoTimeout(10000);
			BufferedOutputStream bos = new BufferedOutputStream(
					socket.getOutputStream());
			BufferedInputStream bis = new BufferedInputStream(
					socket.getInputStream());
			bos.write(data);
			bos.flush();
			retXml = getResultData(bis);
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		} finally {
			try {
				if (socket != null) {
					socket.close();
					socket = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				return "";
			}
		}
		return retXml;
	}

	/**
	 * 生成文件信息
	 * 
	 * @param fileid
	 */
	private void makelog(String fileid) {
		fileinfo = new File(fileinfopath);
		fileinfo.delete();
		fileinfo = new File("/sdcard/fileinfo/");
		if (!fileinfo.exists()) {
			fileinfo.mkdirs();
		}
		String content = fileid;
		try {
			OutputStream outstream = new FileOutputStream(fileinfopath);
			OutputStreamWriter out = new OutputStreamWriter(outstream);
			out.write(content);
			out.close();
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 删除文件信息
	 * 
	 * @param fileid
	 */
	private void deletelog(String fileid) {
		fileinfo = new File(fileinfopath);
		fileinfo.delete();
	}
}