package com.xdja.publicclass;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Node;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;

/*
 * Functions.java
 *
 * Created on 2007年8月4日, 上午9:53
 *常用函数汇总
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 * @author mk
 */
public class Functions {

    /**
     * 将Node转换成XML格式字符串
     *
     * @param node XML结点
     * @return XML格式字符串
     */
    public static String nodeToString(Node node) {
        Transformer transformer = null;
        String result = null;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (transformer != null) {
            try {
                StringWriter sw = new StringWriter();
                transformer
                        .transform(new DOMSource(node), new StreamResult(sw));
                return sw.toString();
            } catch (TransformerException te) {
                throw new RuntimeException(te.getMessage());
            }
        }
        return result;
    }

    /**
     * 验证字符串是否为数字组成，纯数字不包括正负号和小数点。
     *
     * @param str要验证的字符串
     * @return 是否验证通过
     */
    public static boolean isNumeric(String str) {
        int i = 0, ch = 0;
        int len;
        if (str == null) {
            return false;
        }
        len = str.length();
        if (len <= 0) {
            return false;
        }
        for (i = 0; i < len; i++) {
            ch = str.charAt(i);
            if (!((ch >= '0' && ch <= '9') || ch == '.' || ch == '-' || ch == '+')) {
                return false;
            }
        }
        return true;
    }

    /**
     * 验证用户权限中是否包含当前查询类别权限
     *
     * @param userpower 用户拥有的权限
     * @param typepower 当前类别的权限
     * @return 是否包含 true/false
     */
    public static boolean validatePower(String userpower, String typepower) {
        if (userpower != null && typepower != null) {
            if (userpower.length() > typepower.length()) {
                if (userpower.indexOf(typepower) != -1) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 身份证15转18
     *
     * @param idCardNo15 待转换的 15 位身份证号码
     * @return 转换后的18位身份证号
     */
    public static String SFZ15TO18(String idCardNo15) {
        return sfz15TO18(idCardNo15);
    }

    /**
     * 身份证15转18
     *
     * @param idCardNo15 待转换的 15 位身份证号码
     * @return 转换后的18位身份证号
     */
    public static String sfz15TO18(String idCardNo15) {
        int century = 19;
        String centuryStr = "" + century;
        if (century < 0 || centuryStr.length() != 2) {
            throw new IllegalArgumentException("世纪数无效！应该是两位的正整数。");
        }
        if (!(isIdCardNo(idCardNo15) && idCardNo15.length() == 15)) {
            throw new IllegalArgumentException("旧的身份证号格式不正确！");
        }
        int[] weight = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5,
                8, 4, 2, 1};

        // 通过加入世纪码, 变成 17 为的新号码本体.
        String newNoBody = idCardNo15.substring(0, 6) + centuryStr
                + idCardNo15.substring(6);

        // 下面算最后一位校验码

        int checkSum = 0;
        for (int i = 0; i < 17; i++) {
            int ai = Integer.parseInt("" + newNoBody.charAt(i)); // 位于 i 位置的数值
            checkSum = checkSum + ai * weight[i];
        }

        int checkNum = checkSum % 11;
        String checkChar = null;

        switch (checkNum) {
            case 0:
                checkChar = "1";
                break;
            case 1:
                checkChar = "0";
                break;
            case 2:
                checkChar = "X";
                break;
            default:
                checkChar = "" + (12 - checkNum);
        }
        return newNoBody + checkChar;
    }

    /**
     * 身份证18转15
     *
     * @param idCardNo18 18位的身份证号
     * @return
     */
    public static String sfz18TO15(String idCardNo18) {

        String result = "";
        if (!(isIdCardNo(idCardNo18) && idCardNo18.length() == 18)) {
            return result;
        }
        try {
            result = idCardNo18.substring(0, 6) + idCardNo18.substring(8, 17);
            return result;
        } catch (Exception e) {
            // TODO: handle exception
            return result;
        }

    }

    /**
     * 判断给定的字符串是不是符合身份证号的要求
     *
     * @param str 身份证号码
     * @return 成功返回true否则返回false
     */
    public static boolean isIdCardNo(String str) {

        if (str == null) {
            return false;
        }

        int len = str.length();
        if (len != 15 && len != 18) {
            return false;
        }

        for (int i = 0; i < len; i++) {
            try {
                Integer.parseInt("" + str.charAt(i));
            } catch (NumberFormatException e) {
                return false;
            }
        }

        return true;
    }

    /**
     * 字符串转utf-8数组
     *
     * @param s 要转换的字符串
     * @return utf8字节数组
     */
    public static byte[] getUTF8Bytes(String s) {
        char[] c = s.toCharArray();
        int len = c.length;
        // Count the number of encoded bytes...
        int count = 0;
        for (int i = 0; i < len; i++) {
            int ch = c[i];
            if (ch <= 0x7f) {
                count++;
            } else {
                if (ch <= 0x7ff) {
                    count += 2;
                } else {
                    count += 3;
                }
            }
        }
        // Now return the encoded bytes...
        byte[] b = new byte[count];
        int off = 0;
        for (int i = 0; i < len; i++) {
            int ch = c[i];
            if (ch <= 0x7f) {
                b[off++] = (byte) ch;
            } else {
                if (ch <= 0x7ff) {
                    b[off++] = (byte) ((ch >> 6) | 0xc0);
                    b[off++] = (byte) ((ch & 0x3f) | 0x80);
                } else {
                    b[off++] = (byte) ((ch >> 12) | 0xe0);
                    b[off++] = (byte) (((ch >> 6) & 0x3f) | 0x80);
                    b[off++] = (byte) ((ch & 0x3f) | 0x80);
                }
            }
        }
        return b;
    }

    /**
     * byte[4]转换成int型
     *
     * @param b 要转换的字节数组
     * @return int型数据
     */
    public static int bytes4ToInt(byte[] b) {
        int mask = 0xff;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 4; i++) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    /**
     * 将int型转换成长度为4的字节数组
     *
     * @param num 要转换的int变量
     * @return byte[4]数据
     */
    public static byte[] intToBytes4(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; i++) {
            b[i] = (byte) (num >> (24 - i * 8));
        }
        return b;
    }

    /**
     * 格式化SOCKET返回的数据流,格式：长度+压缩数组
     *
     * @param str 要转换的字符串
     * @return 转换后的数组
     */
    public static byte[] FormatSocketSendData(String str) {
        return formatSocketSendData(str);
    }
    /**
     * 格式化SOCKET返回的数据流,格式：长度+压缩数组
     *
     * @param str 要转换的字符串
     * @return 转换后的数组
     */
    public static byte[] formatSocketSendData(String str) {

        if (str == null) {
            return null;
        }
        byte[] tbyte = Gzip.zip(getUTF8Bytes(str));

        byte[] lenbyte = intToBytes4(tbyte.length);
        byte[] allbyte = new byte[tbyte.length + 4];
        System.arraycopy(lenbyte, 0, allbyte, 0, 4);
        System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
        tbyte = null;
        lenbyte = null;
        return allbyte;
    }

    /**
     * 格式化SOCKET返回的数据流,格式：长度+压缩数组
     *
     * @param str 要转换的字符串
     * @return 转换后的数组
     */
    public static byte[] formatSocketSendDataNoZip(String str) {

        if (str == null) {
            return null;
        }
        byte[] tbyte = getUTF8Bytes(str);

        byte[] lenbyte = intToBytes4(tbyte.length);
        byte[] allbyte = new byte[tbyte.length + 4];
        System.arraycopy(lenbyte, 0, allbyte, 0, 4);
        System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
        tbyte = null;
        lenbyte = null;
        return allbyte;
    }

    /**
     * 格式化返回结果，将xml头尾加入， 主要针对主查询无结果但需要关联其它查询的情况
     *
     * @param reqtype  请求类别
     * @param relation 关联查询结果
     * @return 转换后的xml字符串
     */
    public static String formatXmlStr(String reqtype, String relation) {
        StringBuffer respstr = new StringBuffer();
        respstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        respstr.append("<RequestAgent>");
        respstr.append("<Type>" + reqtype + "</Type>");
        respstr.append("<Items>");
        respstr.append("<Values>");
        respstr.append("<Row>");
        respstr.append("<Data>result</Data>");
        respstr.append("</Row>");
        respstr.append("<Row>");
        respstr.append("<Data>查询结果</Data>");
        respstr.append("</Row>");
        respstr.append("<Row>");
        respstr.append("<Data>未找到记录!</Data>");
        respstr.append("</Row>");
        respstr.append("</Values>");
        respstr.append(relation);// 附加关联信息
        respstr.append("</Items>");
        respstr.append("</RequestAgent>");
        return respstr.toString();
    }

    /**
     * 去除指定数组中重复的数据
     *
     * @param array 源数组
     * @return 新数组
     */
    public static String[] distinctArray(String[] array) {
        if (array != null && array.length > 1) {
            int m = array.length;
            for (int i = 0; i < array.length; i++) {
                if (i < array.length - 1 && array[i].equals(array[i + 1])) {
                    array[i] = null;
                    m--;
                }
            }
            if (m == array.length) {
                return array;
            }
            String[] tmp = new String[m];
            m = 0;
            for (int i = 0; i < array.length; i++) {
                if (array[i] != null) {
                    tmp[m++] = array[i];
                }
            }
            array = null;
            return tmp;
        }
        return null;
    }

    /**
     * 将字节数组转换为字符串
     *
     * @param bytes 需要转换的字节数组
     * @return 转换后的字符串
     */
    public static String byte2String(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            String s = dis.readUTF();
            // 关闭流
            dis.close();
            bais.close();
            return s;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 装字符串转换成字节数组
     *
     * @param s 源字符串
     * @return 字节数组
     */
    public static byte[] string2Byte(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream bos = new DataOutputStream(baos);
            bos.writeUTF(s);
            byte[] bytes = baos.toByteArray();
            // 关闭流
            bos.close();
            baos.close();
            return bytes;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 分割字符串，原理：检测字符串中的分割字符串，然后取子串
     *
     * @param original 需要分割的字符串
     *                 如：#zdcjJdczl#zdcjEssj#zdcjEscjy#zdcjJdcxl#zdcjFjhs#zdcjQt
     *                 #zdcjSsjgy#zdcjYy#zdcjJmy#xtpzxi#
     * @return 分割后生成的字符串数组
     * @paran regex 分割字符串
     */
    public static String[] split(String original, String regex) {
        // 取子串的起始位置
        int startIndex = 0;
        // 将结果数据先放入Vector中
        Vector<String> v = new Vector<String>();
        // 返回的结果字符串数组
        String[] str = null;
        // 存储取子串时起始位置
        int index = 0;

        // 获得匹配子串的位置
        startIndex = original.indexOf(regex);
        // System.out.println("0" + startIndex);
        // 如果起始字符串的位置小于字符串的长度，则证明没有取到字符串末尾。
        // -1代表取到了末尾
        while (startIndex < original.length() && startIndex != -1) {
            String temp = original.substring(index, startIndex);
            System.out.println(" " + startIndex);
            // 取子串
            v.addElement(temp);
            // 设置取子串的起始位置
            index = startIndex + regex.length();
            // 获得匹配子串的位置
            startIndex = original.indexOf(regex, startIndex + regex.length());
        }

        // 取结束的子串
        v.addElement(original.substring(index + 1 - regex.length()));
        // 将Vector对象转换成数组
        str = new String[v.size()];
        for (int i = 0; i < v.size(); i++) {
            str[i] = (String) v.elementAt(i);
        }

        // 返回生成的数组
        return str;
    }

    /**
     * 获取当前时间
     *
     * @return 当前时间，格式为yyyyMMddHHmmss
     */
    public static String getCurrentDate() {
        String t = "";
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        // 年
        int temp = calendar.get(Calendar.YEAR);
        t += String.valueOf(temp);
        // 月
        temp = calendar.get(Calendar.MONTH);
        if (temp < 10) {
            t += "0" + String.valueOf(temp);
        } else {
            t += String.valueOf(temp);
        }
        // 日
        temp = calendar.get(Calendar.DATE);
        if (temp < 10) {
            t += "0" + String.valueOf(temp);
        } else {
            t += String.valueOf(temp);
        }
        // 时
        temp = calendar.get(Calendar.HOUR);
        if (temp < 10) {
            t += "0" + String.valueOf(temp);
        } else {
            t += String.valueOf(temp);
        }
        // 分
        temp = calendar.get(Calendar.MINUTE);
        if (temp < 10) {
            t += "0" + String.valueOf(temp);
        } else {
            t += String.valueOf(temp);
        }
        // 秒
        temp = calendar.get(Calendar.SECOND);
        if (temp < 10) {
            t += "0" + String.valueOf(temp);
        } else {
            t += String.valueOf(temp);
        }

        return t;
    }

    /**
     * 分隔字符串
     *
     * @param split_str  源字符串
     * @param source_str 分隔符
     * @return 分隔后的数组
     */
    public static String[] mySplit(String split_str, String source_str) {
        if (split_str == "" || source_str == "") {
            return (null);
        }
        Pattern p = Pattern.compile(split_str);
        Matcher m = p.matcher(source_str);
        Vector<String> vStr = new Vector<String>();
        while (m.find()) {
            System.out.println(m.group());
            vStr.add(m.group());
        }
        return (String[]) vStr.toArray();
    }

    /**
     * 组装查询请求串
     *
     * @param sessionID
     * @param reqtype   请求类别
     * @param dbsource  数据源
     * @param isrepeat  是否重复请求
     * @param beginno   开始条目
     * @param condition 查询条件
     * @return 查询请求串
     */
    public static String FormatReqStr(String sessionID, String reqtype,
                                      String dbsource, String isrepeat, String beginno, String condition) {
        return formatReqStr(sessionID, reqtype, dbsource, isrepeat, beginno, condition);
    }

    /**
     * 组装查询请求串
     *
     * @param sessionID
     * @param reqtype   请求类别
     * @param dbsource  数据源
     * @param isrepeat  是否重复请求
     * @param beginno   开始条目
     * @param condition 查询条件
     * @return 查询请求串
     */
    public static String formatReqStr(String sessionID, String reqtype,
                                      String dbsource, String isrepeat, String beginno, String condition) {
        StringBuffer reqstr = new StringBuffer();
        reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<ReqType>" + reqtype + "</ReqType>");
        reqstr.append("<SessionID>" + sessionID + "</SessionID>");
        reqstr.append("<BeginNo>" + beginno + "</BeginNo>");
        reqstr.append("<DataSource>" + dbsource + "</DataSource>");
        reqstr.append("<Condition IsRepeat=\"" + isrepeat + "\" Value=\"\">");
        if (isrepeat == "1") {
            reqstr.append("<![CDATA[" + condition + "]]>");
        } else {
            reqstr.append(condition);
        }
        reqstr.append("</Condition>");
        reqstr.append("</Root>");
        if (reqstr.length() > 0) {
            return reqstr.toString();
        } else {
            return ("-1 生成请求字符失效！");
        }

    }

    /**
     * 组装机动车提取请求字符串
     *
     * @param sessionID
     * @param condition  查询条件
     * @param DataSource 数据源
     * @return 机动车提取请求字符串
     */
    public static String getVehicleInfor(String sessionID, String condition,
                                         String DataSource) {
        StringBuilder reqstr = new StringBuilder();
        reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<ReqType>jdcxxtq</ReqType>");// 利用窗体的Tag属性传递查询类别
        reqstr.append("<SessionID>" + sessionID + "</SessionID>");
        reqstr.append("<BeginNo>1</BeginNo>");
        reqstr.append("<DataSource>" + DataSource + "</DataSource>");
        reqstr.append("<Condition IsRepeat=\"1\" Value=\"\">");
        reqstr.append("<![CDATA[" + condition + "]]>");
        reqstr.append("</Condition>");
        reqstr.append("</Root>");
        return reqstr.toString();
    }

    /**
     * 判断是否是有效的18位或15位居民身份证号码
     *
     * @param identityId ：18位或15位居民身份证号码
     * @return：true： 有效的18位或15位居民身份证号码
     */

    public static boolean isIdentityId(String identityId) {

        if (isEmpty(identityId))
            return false;
        return IdcardUtil.isIdentityCode(identityId);
    }

    /**
     * 判断是否为空串""
     */
    public static boolean isEmpty(String sValue) {
        return TextUtils.isEmpty(sValue);
    }

    /**
     * 身份证号码15位转18位
     *
     * @param id 身份证号
     * @return 18位身份证号
     */
    public static final String getNewId(String id) {
        if (id != null) {
            // 如果最后一位字符为* 则转换为X(大写)
            if (id.length() == 18 && id.substring(17).equalsIgnoreCase("*")) {
                id = id.substring(0, 17) + "X";
            }

            if (isIdentityId(id) && id.length() == 15) {

                final int[] W = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5,
                        8, 4, 2, 1};
                final String[] A = {"1", "0", "X", "9", "8", "7", "6", "5",
                        "4", "3", "2"};
                int i, j, s = 0;
                String newid;
                newid = id;
                newid = newid.substring(0, 6) + "19"
                        + newid.substring(6, id.length());
                for (i = 0; i < newid.length(); i++) {

                    j = Integer.parseInt(newid.substring(i, i + 1)) * W[i];
                    s = s + j;
                }
                s = s % 11;
                newid = newid + A[s];

                return newid.toUpperCase();
            }
        }
        return id.toUpperCase();

    }


    /**
     * 定义弹出对话框
     *
     * @param context 句柄
     * @param title   标题
     * @param msg     消息内容
     */
    public static void popAlert(Context context, String title, String msg) {
        try {
            new AlertDialog.Builder(context)
                    .setTitle(title)
                    .setMessage(msg)
                    .setNeutralButton("确定",
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dlg,
                                                    int which) {

                                }
                            }).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
