package com.xdja.queryparser;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import android.text.TextUtils;

import com.xdja.publicclass.XMLParser;

public class QueryParser {
	private XMLParser xmlParser = null;

	/**
	 * 构造函数
	 * 
	 * @param _xmlParser
	 *            XML解析器
	 */
	public QueryParser(XMLParser _xmlParser) {
		this.xmlParser = _xmlParser;
	}

	/***
	 * 构造函数
	 * 
	 * @param xmlString
	 *            查询结果XML
	 */
	public QueryParser(String xmlString) {
		this.xmlParser = new XMLParser(xmlString);
	}

	/**
	 * 取指定节点值
	 * 
	 * @param name
	 *            节点名称
	 * @return 节点值
	 */
	public String getElementValue(String name) {
		return xmlParser.getElementValue(name);
	}

	/**
	 * 取返回结果中某一字段对应的值,默认取第一条记录的值
	 * 
	 * @param 字段名
	 * @return 取返回结果中某一字段对应的值,默认取第一条记录的值
	 */
	public String getFieldPointValue(String fieldname) {
		return xmlParser.getFieldPointValue(fieldname);
	}

	/**
	 * 取返回结果中某一字段对应的值,可以指定取哪一行的数据值
	 * 
	 * @param 字段名
	 * @param 记录行数
	 * @return 返回数据
	 */
	public String getFieldPointValue(String fieldname, int rowno) {
		return xmlParser.getFieldPointValue(fieldname, rowno);
	}

	/**
	 * 取返回结果中某一字段对应的值的代码属性,默认取第一条记录的值的属性 如果不是代码[没有属性]，则返回节点值
	 * 
	 * @param 字段名
	 * @return 返回属性值
	 */
	public String getFieldPointAttribute(String fieldname) {
		return xmlParser.getFieldPointAttribute(fieldname);
	}

	/**
	 * 取返回结果中某一字段对应的值的代码属性,可以指定取哪个行的数据值 如果不是代码[没有属性]，则返回节点值
	 * 
	 * @param 字段名
	 * @param 记录编号
	 * @return 返回数据
	 */
	public String getFieldPointAttribute(String fieldname, int rowno) {
		return xmlParser.getFieldPointAttribute(fieldname, rowno);
	}

	public NodeList getNodeList(String fieldName) {
		return xmlParser.getNodeList(fieldName);
	}
	/**
	 * 获取中文标题和数据
	 * 
	 * @return 二维数组第一行为中文标题后面是数据
	 */
	public String[][] getCHTitleWithData() {
		/*
		 * 解析XML数据，构建数据源
		 */
		NodeList nl = xmlParser.getNodeList("Row");
		if (nl == null || nl.getLength() < 3) {
			return null;
		}
		// 中文字段Rows
		NodeList chElement = nl.item(1).getChildNodes();
		// 中文字段名长度
		int iCol = chElement.getLength();
		NodeList dataElement = null;
		String[][] items = new String[nl.getLength() - 1][chElement.getLength()];
		for (int i = 2; i < nl.getLength(); i++) {
			// 数据Row
			dataElement = nl.item(i).getChildNodes();
			for (int j = 0; j < iCol; j++) {
				items[0][j] = chElement.item(j).getFirstChild().getNodeValue();
				if (dataElement.item(j).getFirstChild() != null) {
					items[i - 1][j] = dataElement.item(j).getFirstChild()
							.getNodeValue();
				} else {
					items[i - 1][j] = "";
				}
			}
		}
		return items;
	}

	/**
	 * 获取关联结果列表
	 * 
	 * @return 关联结果列表
	 */
	public List<RelNodeBean> getRelNodes() {
		List<RelNodeBean> relNodes = null;
		NodeList nl = xmlParser.getNodeList("RelNode");
		if (nl == null || nl.getLength() == 0) {
			return relNodes;
		}
		relNodes = new ArrayList<RelNodeBean>();
		for (int i = 0; i < nl.getLength(); i++) {
			NodeList relNode = nl.item(i).getChildNodes();
			RelNodeBean relBean = new RelNodeBean();
			if (relNode != null) {
				for (int j = 0; j < relNode.getLength(); j++) {
					Node parentNode = relNode.item(j);
					if (parentNode != null) {
						Node tempNode = parentNode.getFirstChild();
						if (tempNode != null) {
							if (parentNode.getNodeName().equals("Sort")) {
								relBean.setSort(tempNode.getNodeValue());
							} else if (parentNode.getNodeName().equals("Name")) {
								relBean.setName(tempNode.getNodeValue());
							} else if (parentNode.getNodeName().equals(
									"Condition")) {
								relBean.setCondition(tempNode.getNodeValue());
							} else if (parentNode.getNodeName().equals(
									"DbSource")) {
								relBean.setDbSource(tempNode.getNodeValue());
							} else if (parentNode.getNodeName()
									.equals("Alert")) {
								relBean.setAlert(tempNode.getNodeValue());
							}
						}
					}
				}
			}
			relNodes.add(relBean);
		}
		return relNodes;
	}

	/**
	 * 获取照片节点
	 * 
	 * @return 照片节点
	 */
	public GetPhotoBean getPhoto() {
		GetPhotoBean photoBean = null;
		NodeList nl = xmlParser.getNodeList("GetPhoto");
		NodeList photoNode = null;
		if (nl == null || nl.getLength() == 0) {
			return photoBean;
		}
		if (nl.item(0) == null) {
			return photoBean;
		}
		photoNode = nl.item(0).getChildNodes();
		if (photoNode != null) {
			photoBean = new GetPhotoBean();
			for (int i = 0; i < photoNode.getLength(); i++) {
				Node parentNode = photoNode.item(i);
				if (parentNode != null) {
					Node tempNode = parentNode.getFirstChild();
					if (tempNode != null) {
						if (parentNode.getNodeName().equals("ReqType")) {
							photoBean.setReqType(tempNode.getNodeValue());
						} else if (parentNode.getNodeName().equals("ReqTable")) {
							photoBean.setReqTable(tempNode.getNodeValue());
						} else if (parentNode.getNodeName()
								.equals("Condition")) {
							photoBean.setCondition(tempNode.getNodeValue());
						} else if (parentNode.getNodeName().equals("DbSource")) {
							photoBean.setDbSource(tempNode.getNodeValue());
						}
					}
				}
			}
		}
		return photoBean;
	}

	/**
	 * 获取分页节点
	 * 
	 * @return 分页节点信息
	 */
	public PageBean getPage() {
		PageBean pageBean = null;
		NodeList nl = xmlParser.getNodeList("Page");
		NodeList pageNode = null;
		if (nl == null || nl.getLength() == 0) {
			return pageBean;
		}
		if (nl.item(0) == null) {
			return pageBean;
		}
		pageNode = nl.item(0).getChildNodes();
		if (pageNode != null) {
			pageBean = new PageBean();
			for (int i = 0; i < pageNode.getLength(); i++) {
				Node parentNode = pageNode.item(i);
				if (parentNode != null) {

					Node tempNode = parentNode.getFirstChild();
					String temp;
					if (tempNode != null) {
						if (parentNode.getNodeName().equals("Size")) {
							temp = tempNode.getNodeValue();
							if (!TextUtils.isEmpty(temp)) {
								pageBean.setSize(Integer.parseInt(temp));
							}
						} else if (parentNode.getNodeName().equals("TotalLen")) {
							temp = tempNode.getNodeValue();
							if (!TextUtils.isEmpty(temp)) {
								pageBean.setTotalLen(Integer.parseInt(temp));
							}
						} else if (parentNode.getNodeName().equals(
								"CurrentLen")) {
							temp = tempNode.getNodeValue();
							if (!TextUtils.isEmpty(temp)) {
								pageBean.setCurrentLen(Integer.parseInt(temp));
							}
						} else if (parentNode.getNodeName()
								.equals("TotalPage")) {
							temp = tempNode.getNodeValue();
							if (!TextUtils.isEmpty(temp)) {
								pageBean.setTotalPage(Integer.parseInt(temp));
							}
						} else if (parentNode.getNodeName().equals("BeginNo")) {
							temp = tempNode.getNodeValue();
							if (!TextUtils.isEmpty(temp)) {
								pageBean.setBeginNo(Integer.parseInt(temp));
							}
						} else if (parentNode.getNodeName().equals(
								"SourceCondition")) {
							pageBean.setSourceCondition(tempNode.getNodeValue());
						} else if (parentNode.getNodeName().equals(
								"SourceDbSource")) {
							pageBean.setSourceDbSource(tempNode.getNodeValue());
						}
					}
				}
			}
		}

		return pageBean;
	}

}
