package com.xdja.verify;

import android.text.TextUtils;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;

public class EtTagEmptyVerify extends BaseVerify {

	public EtTagEmptyVerify(View _control, String _msg) {
		super(_control, _msg);
	}

	@Override
	public Boolean check() {
		if (this.getControl().getClass() != EditText.class && 
				this.getControl().getClass() != AutoCompleteTextView.class &&
				this.getControl().getClass() != MultiAutoCompleteTextView.class) {
			throw new RuntimeException("不是有效的输入框控件！");
		}
		
		//MultiAutoCompleteTextView->AutoCompleteTextView->EditText->TextView
		EditText editText = ((EditText) this.getControl());
		String str = (String)editText.getTag();
		return !TextUtils.isEmpty(str);
	}

}
