package com.xdja.verify;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import android.util.Log;
import android.view.View;

public class VerifyCenter {
	List<BaseVerify> verifyList = new ArrayList<BaseVerify>();
	private String errorMsg = "";		//错误信息
	private View controlView;			//被验证的控件

	public String getErrorMsg() {
		return errorMsg;
	}

	public View getControlView() {
		return controlView;
	}

	/**
	 * 注册验证
	 * 
	 * @param _type
	 *            验证类型
	 * @param _view
	 *            验证控件
	 * @param _msg
	 *            验证失败返回信息
	 */
	public void registVerify(String verifyType, View _view, String _msg) {
		String classString = verifyType;
//				VerifyProperties.getProperties(_view.getContext())
//				.getProperty(verifyType);
		Log.v("反射类名：", classString);
		try {
			Class<?> baseVerifyClass = Class.forName(classString);
			Constructor<?> constructor = baseVerifyClass
					.getDeclaredConstructor(View.class, String.class);
			BaseVerify baseVerify = (BaseVerify) constructor.newInstance(_view,
					_msg);
			verifyList.add(baseVerify);//com.xdja.jwt.verify.SpSelectVeriry
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 执行验证
	 * 
	 * @param _errorMsg
	 *            返回错误消息
	 * @return
	 */
	public Boolean check() {
		Boolean result = true;
		for (BaseVerify baseVerify : verifyList) {
			try {
				if (!baseVerify.check()) {
					result = false;
					errorMsg = baseVerify.getMsg();
					controlView = baseVerify.getControl();
					break;
				}
			} catch (Exception e) {
				result = false;
				errorMsg = e.getMessage();
				controlView = baseVerify.getControl();
				break;
			}

		}
		return result;
	}
	
	/***
	 * 清除验证列表
	 */
	public void clearVerifyList(){
		verifyList.clear();
	}
}
