package com.xdja.annotation;

import java.lang.reflect.Field;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.view.ViewGroup;

public class JWTInjector {
	
	private static JWTInjector injector;
	 
	private JWTInjector() {}
	
	public static JWTInjector getInstance() {
		if (injector == null) {
			injector = new JWTInjector();
		}
		return injector;
	}
	
	/**
	 * 注入Activity的成员
	 * @param activity
	 * @param field 成员
	 */
	private void injectView(Activity activity, Field field) {
		if (field.isAnnotationPresent(JWTInjectView.class)) {
			JWTInjectView viewInject = field.getAnnotation(JWTInjectView.class);
			int viewId = viewInject.value();
			try {
				field.setAccessible(true);
				field.set(activity, activity.findViewById(viewId));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 注入Activity的成员
	 * @param activity
	 */
	public void injectView(Activity activity) {
		Field[] fields = activity.getClass().getFields();
		if (fields != null && fields.length > 0) {
			for (Field field : fields) {
				if (field.isAnnotationPresent(JWTInjectView.class)) {
					injectView(activity, field);
				}
			}
		}
		Field[] localFields = activity.getClass().getDeclaredFields();
		if (localFields != null && localFields.length > 0) {
			for (Field field : localFields) {
				if (field.isAnnotationPresent(JWTInjectView.class)) {
					injectView(activity, field);
				}
			}
		}
	}
	
	/**
	 * 注入Fragment的成员
	 * @param fragment
	 * @param field 成员
	 */
	private void injectView(Fragment fragment, Field field) {
		if (field.isAnnotationPresent(JWTInjectView.class)) {
			JWTInjectView viewInject = field.getAnnotation(JWTInjectView.class);
			int viewId = viewInject.value();
			try {
				field.setAccessible(true);
				field.set(fragment, fragment.getView().findViewById(viewId));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 注入Fragment的成员
	 * @param fragment
	 * @param view
	 */
	public void injectView(Fragment fragment) {
		//父类与子类所有public属性
		Field[] fields = fragment.getClass().getFields();
		if (fields != null && fields.length > 0) {
			for (Field field : fields) {
				if (field.isAnnotationPresent(JWTInjectView.class)) {
					injectView(fragment, field);
				}
			}
		}
		//本类的所有属性
		Field[] localFields = fragment.getClass().getDeclaredFields();
		if (localFields != null && localFields.length > 0) {
			for (Field field : localFields) {
				if (field.isAnnotationPresent(JWTInjectView.class)) {
					injectView(fragment, field);
				}
			}
		}
	}
	
	/**
	 * 注入ViewGroup的成员
	 * @param viewGroup
	 * @param field 成员
	 */
	private void injectView(ViewGroup viewGroup, Field field) {
		if (field.isAnnotationPresent(JWTInjectView.class)) {
			JWTInjectView viewInject = field.getAnnotation(JWTInjectView.class);
			int viewId = viewInject.value();
			try {
				field.setAccessible(true);
				field.set(viewGroup, viewGroup.findViewById(viewId));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 注入ViewGroup的成员
	 * @param ViewGroup
	 */
	public void injectView(ViewGroup viewGroup) {
		Field[] fields = viewGroup.getClass().getFields();
		if (fields != null && fields.length > 0) {
			for (Field field : fields) {
				if (field.isAnnotationPresent(JWTInjectView.class)) {
					injectView(viewGroup, field);
				}
			}
		}
		Field[] localFields = viewGroup.getClass().getDeclaredFields();
		if (localFields != null && localFields.length > 0) {
			for (Field field : localFields) {
				if (field.isAnnotationPresent(JWTInjectView.class)) {
					injectView(viewGroup, field);
				}
			}
		}
	}

}
