package com.xdja.operation;

import com.xdja.publicclass.DBHelper;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;

public class DBHelperOperation {
	DBHelper dbHelper;
	/**
	 * 初始化数据操作类
	 * 
	 * @param _context
	 *            当前窗体句柄
	 * @param dbFile
	 *            数据库全路径
	 * @param dbName
	 *            数据库名称
	 */
	public DBHelperOperation(Context _context, String dbFile, String dbName) {
		dbHelper = new DBHelper(_context, dbFile, dbName);
	}
	
	public DBHelperOperation(String dbFile, String dbName) {
		dbHelper = new DBHelper(dbFile, dbName);
	}
	
	/**
	 * 从配制表中查询标签对应的值
	 * @param tableName 表名
	 * @param configName 标签名称
	 * @return 标签对应的值
	 */
	public String getLocalConfig(String tableName,String configName)
	{
		try {
			String sql = "select c_configvalue from "+tableName+" where c_configname = '"
					+ configName + "'";
			
			Cursor c = dbHelper.query(sql) ;
			if (c != null) {
				c.moveToFirst();

				String configValue = c.getString(c
						.getColumnIndex("c_configvalue"));
				c.close();
				dbHelper.closeDatabase();
				return configValue;
			} else {
				return "";
			}
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}
	
	/**
	 * 更新配制表中的标签的值
	 * @param tableName 表名
	 * @param name 标签名称
	 * @param value 标签的值
	 */
	public void updataLocalConfig(String tableName, String name, String value) {
		try {
			ContentValues content = new ContentValues();
			content.put("c_configvalue", value);
			String[] selectionArgs = new String[] { name };
			dbHelper.update(tableName, content, "c_configname==?",
					selectionArgs);
		} catch (Exception e) {
			e.printStackTrace();
		} finally{
			dbHelper.closeDatabase();
		}
	}
	
}
