/*
 * 网络通信类，负责发送和接收数据,并进行数据压缩和解压
 * and open the template in the editor.
 */
package com.xdja.publicclass;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import android.os.Build;

/**
 * 
 * @author mk
 */
public class ClientHttp {
	public HttpURLConnection conn = null;
	public String UrlPath = ""; // 连接服务器地址
	public boolean connected = false; // 是否已经连接网络
	public boolean sended = false; // 是否发送成功
	public String sendstr = ""; // 从本地发送到网络的字符串
	public String recstr = ""; // 从网络接收回来了字符串
	public int isys = 0; // 是否压缩的标志
	public static final int TIMEOUT = 100000; // 超时时长(80秒)
	public int isConn = 0; // 长短连接标志0表示短连接，1表示长连接
	public BufferedInputStream in = null; // 网络输入流
	public BufferedOutputStream os = null; // 网络输出流
	public OutputStream osp = null;
	public InputStream inp = null;
	private String sessionId = "";

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * 设置是否压缩
	 * 
	 * @param ys
	 *            压缩标识
	 */
	public void setIsys(int ys) {
		this.isys = ys;
	}

	public int getIsys() {
		return isys;
	}

	/**
	 * 设置连接状态
	 * 
	 * @param type
	 *            设置连接状态0表示短连接，1表示长连接
	 */
	public void setConn(int type) {
		this.isConn = type;
	}

	/**
	 * 获取连接状体
	 */
	public int getConn() {
		return isConn;
	}

	/**
	 * 设置网络连接地址
	 * 
	 * @param urlpath
	 *            服务器地址
	 */
	public void setUrlPath(String urlpath) {
		this.UrlPath = urlpath;
	}

	public String getUrlPath() {
		return this.UrlPath;
	}

	public ClientHttp(String ServerIP, String ServerPort) {
		this.UrlPath = "http://" + ServerIP + ":" + ServerPort
				+ "/oa/CommunicateReflect";
	}

	/**
	 * Http网络连接conn初始化
	 * 
	 * @param contype
	 *            长短连接标识
	 * 
	 */
	public boolean httConn(int conntype) {

		try {
			URL uri;
			uri = new URL(UrlPath + "?");
			String BOUNDARY = java.util.UUID.randomUUID().toString();
			String PREFIX = "--", LINEND = "\r\n";
			String MULTIPART_FROM_DATA = "multipart/form-data";
			// 设置连接conn连接参数post请求方式；
			conn = (HttpURLConnection) uri.openConnection();
			conn.setReadTimeout(6 * 10000); // 缓存的最长时间
			conn.setConnectTimeout(TIMEOUT);
			conn.setDoInput(true);// 允许输入
			conn.setDoOutput(true);// 允许输出
			conn.setUseCaches(false); // 不允许使用缓存
			conn.setRequestMethod("POST");
			conn.setRequestProperty("connection", "keep-alive");
			// conn.setRequestProperty("Content-Type","application/octet-stream");
			// conn.setRequestProperty("Content-Type", MULTIPART_FROM_DATA
			// + ";boundary=" + BOUNDARY);
			/**
			 * 判断android版本是不是2.1 如果是2.1则使用关闭连接模式来解决，连接池的阻塞的错误
			 */
			if (Integer.parseInt(Build.VERSION.SDK) <= Build.VERSION_CODES.ECLAIR_MR1) {
				System.setProperty("http.keepAlive", "false");
			}
			conn.setRequestProperty("content-type", "text/xml");
			// int resCode = conn.getResponseCozde();
			conn.connect();
			// 设置连接状体
			setConn(conntype);

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (ProtocolException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * Http网络连接conn初始化 默认为短连接
	 **/
	public boolean httConn() {

		try {
			URL uri;
			uri = new URL(UrlPath + "?");
			String BOUNDARY = java.util.UUID.randomUUID().toString();
			String PREFIX = "--", LINEND = "\r\n";
			String MULTIPART_FROM_DATA = "multipart/form-data";
			// 设置连接conn连接参数post请求方式；
			conn = (HttpURLConnection) uri.openConnection();
			conn.setReadTimeout(5 * 10000); // 缓存的最长时间
			conn.setConnectTimeout(TIMEOUT);
			conn.setDoInput(true);// 允许输入
			conn.setDoOutput(true);// 允许输出
			conn.setUseCaches(false); // 不允许使用缓存
			conn.setRequestMethod("POST");
			/**
			 * 短连接使用close状态 避免第一次连接成功，第二次连接getResponseCode()返回-1连接不成功的问题。
			 */
			conn.setRequestProperty("connection", "keep-alive");
			/**
			 * 判断android版本是不是2.1 如果是2.1则使用关闭连接模式来解决，连接池的阻塞的错误
			 */
			if (Integer.parseInt(Build.VERSION.SDK) <= Build.VERSION_CODES.ECLAIR_MR1) {
				System.setProperty("http.keepAlive", "false");
			}
			// conn.setRequestProperty("Content-Type","application/octet-stream");
			// conn.setRequestProperty("Content-Type", MULTIPART_FROM_DATA+
			// ";boundary=" + BOUNDARY);
			conn.setRequestProperty("content-type", "text/xml");
			conn.setRequestProperty("Charset", "UTF-8");
			if (sessionId != null && !sessionId.equals("")) {
				conn.setRequestProperty("cookie", sessionId);
			}
			// 设置默认连接为短连接
			setConn(0);
			conn.connect();

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (ProtocolException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * 关闭数据连接
	 */
	public void closeConn() {

		if (isConn == 0) {

			if (conn != null) {
				conn.disconnect();
				conn = null;
			}
		}

	}

	/**
	 * 只发送数据，不接受数据
	 * 
	 * @return 返回发送状态，0为成功，其他状态根据错误代码进行查询。
	 */
	public String sendData(String data) {
		if (!httConn()) {
			return "-2-2800";
		}
		byte[] sendXml = Functions.formatSocketSendData(data);

		try {
			BufferedOutputStream output = new BufferedOutputStream(
					conn.getOutputStream());

			// 发送数据
			output.write(sendXml);
			output.flush();
			output.close();
			output = null;
			BufferedInputStream input = new BufferedInputStream(
					conn.getInputStream());
			input.close();
			closeConn();
			return "0";
		} catch (Exception e1) {

			System.out.println("发生错误：" + e1.getMessage());
			closeConn();
			return "-2-2800";
		}
	}

	/**
	 * 接收网络回传数据
	 * 
	 * @return 返回从服务器接收回来的数据
	 */
	public String RevData() {

		try {
			inp = conn.getInputStream();
			if (inp == null) {
				return "-2-2809";
			}
			in = new BufferedInputStream(inp);
			// int len =in.available();
			byte[] relen = new byte[4];
			in.read(relen, 0, 4);
			int rvlen = Functions.bytes4ToInt(relen);
			byte[] ret = new byte[rvlen];
			readFully(in, ret);
			in.close();
			byte[] realData = new byte[rvlen];
			System.arraycopy(ret, 0, realData, 0, rvlen);
			String temp = new String(realData);
			return temp;
		} catch (IOException e) {
			e.printStackTrace();
			return "-2-2808";
		}
	}

	private static void readFully(BufferedInputStream in, byte[] buffer)
			throws IOException {
		int bytesRead = 0;

		while (bytesRead < buffer.length) {

			int count = in.read(buffer, bytesRead, buffer.length - bytesRead);
			if (count == -1) {
				throw new IOException("Input stream closed");
			}
			bytesRead += count;
		}
	}

	/**
	 * 同步获取发送数据和接收数据
	 * 
	 * @param content
	 *            要发送字符串
	 * @return 返回从服务端接收回来的数据
	 */
	public String sendRequest(String content) {
		long etime = 0;
		long stime = 0;
		String retData = null;
		// 判断网络连接是否可用
		stime = System.currentTimeMillis();
		XdjaLog.w("time", String.valueOf(stime));
		if (!httConn()) {
			System.out.println("-2-2800messages");
			return "-2-2800";
		}
		/**
		 * 办公OA调试后台servlet http 协议使用
		 */

		byte[] sendXml = Functions.formatSocketSendData(content);
		BufferedOutputStream output = null;
		BufferedInputStream input = null;
		try {
			output = new BufferedOutputStream(conn.getOutputStream());
			// 发送数据
			output.write(sendXml);
			output.flush();
			/**
			 * 修改集成安全时候不能发送完数据关闭输出流！
			 * **/
			// output.close();
			// output=null;

			int code = conn.getResponseCode();
			if (code != HttpURLConnection.HTTP_OK) {
				XdjaLog.i("conntStart", String.valueOf(code));
				return "-2-2803";
			}
			System.out.println("code=" + code);
			if (sessionId == null || sessionId.equals("")) {
				sessionId = conn.getHeaderField("set-cookie");
			}
			input = new BufferedInputStream(conn.getInputStream());
			if (input == null) {
				return "-2-2809";
			}

			// byte[] buf = new byte[20480];

			int num = 0;
			// 接收头四个字节
			// int len =in.available();
			/**
			 * 办公OA调试后台servlet http 协议使用
			 */
			byte[] relen = new byte[4];
			input.read(relen, 0, 4);
			int rvlen = Functions.bytes4ToInt(relen); // 当前请求数据包的总长度
			byte[] ret = new byte[rvlen];
			// 全部接收
			readFully(input, ret);
			byte[] realData = new byte[rvlen];
			System.arraycopy(ret, 0, realData, 0, rvlen);
			// byte[] unzipdata = Gzip.unzip(realData);
			retData = new String(realData);

			etime = System.currentTimeMillis();
			XdjaLog.w("time", String.valueOf(etime));
			XdjaLog.w("time", String.valueOf(etime - stime));
			return retData;
		} catch (Exception e) {
			/*
			 * if(output!=null) { try { output.close();
			 * 
			 * } catch (IOException e1) { // TODO Auto-generated catch block
			 * e1.printStackTrace(); } output=null; } if(input!=null) { try {
			 * input.close(); } catch (IOException e1) { // TODO Auto-generated
			 * catch block e1.printStackTrace(); } input=null; }
			 * System.out.println("-2-2808发生错误：" + e.getMessage());
			 * 
			 * closeConn();
			 */
			return "-2-2808";
		} finally {
			if (output != null) {
				try {
					output.close();

				} catch (IOException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
				output = null;
			}
			if (input != null) {
				try {
					input.close();
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
				input = null;
			}
			output = null;
			input = null;
			closeConn();
		}
	}

}