package com.xdja.publicclass;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NodeList;
import com.xdja.Exception.CErrorInfo;

import android.R.bool;
import android.R.integer;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.widget.Toast;

public class MenuManger {
	public interface IMenuListener {
		public void getMenuListener(Boolean _bool);
	}
	
	private IMenuListener listener = null;
	/***
	 * 设置监听
	 * @param _listener
	 */
	public void setListener(IMenuListener _listener)
	{
		listener = _listener;
	}
	// 界面句柄
	private Context context = null;
	// sessionId
	private String sessionID;
	// IP
	private String ip;
	// 端口
	private String port;
	// 数据库操作类
	private DBHelper dbHelper;

	private final String fieldName = "menuMD5";


	// **成功菜单数量
	// 0无需更新
	// -1获取菜单失败
	// -2更新本地菜单失败
	/**
	 * 构造函数
	 * 
	 * @param context
	 *            窗体句柄
	 * @param dbFile
	 *            数据库路径
	 * @param dbName
	 *            数据库名称
	 * @param sessionId
	 * @param ip
	 * @param port
	 */
	public MenuManger(Context context, String dbFile, String dbName,
			String sessionId, String ip, String port) {
		this.context = context;
		this.sessionID = sessionId;
		this.ip = ip;
		this.port = port;
		dbHelper = new DBHelper(context, dbFile, dbName);
	}

	/**
	 * 更新菜单
	 * 
	 * @param menuID
	 *            模块的ID,如果综查100
	 */
	public void updateMenu(String menuID) {
		//如果本地无菜单，直接更新
		if (!isExistMenu()) {
			downMenu(menuID);
		}else {
			//拿上次更新的MD5与后台比对
			String menuMD5 = getMenuMD5();
			if (!TextUtils.isEmpty(menuMD5)) {
				checkMenu(menuID,menuMD5);
			}else {
				downMenu(menuID);
			}
			
		}

	}
	
	/**
	 * 下载菜单数据
	 * @param menuID 菜单ID
	 */
	private void downMenu(String menuID)
	{
		StringBuffer reqstr = new StringBuffer();
		reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		reqstr.append("<Root>");
		reqstr.append("<ReqType>check_menu</ReqType>");
		reqstr.append("<SessionID>" + sessionID + "</SessionID>");
		reqstr.append("<Condition>");
		reqstr.append("<c_fjcd>" + menuID + "</c_fjcd>");
		reqstr.append("</Condition>");
		reqstr.append("</Root>");
		GetMenuTask getMenuTask = new GetMenuTask(reqstr.toString());
		getMenuTask.execute();
	}
	
	/**
	 * 菜单更新检查
	 * @param menuID  菜单ID
	 * @param menuMD5 上次更新的MD5
	 */
	private void checkMenu(String menuID, String menuMD5)
	{
		StringBuffer reqstr = new StringBuffer();
		reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		reqstr.append("<Root>");
		reqstr.append("<ReqType>check_menu</ReqType>");
		reqstr.append("<SessionID>" + sessionID + "</SessionID>");
		reqstr.append("<Condition>");
		reqstr.append("<md5>" + menuMD5 + "</md5>");
		reqstr.append("<c_fjcd>" + menuID + "</c_fjcd>");
		reqstr.append("</Condition>");
		reqstr.append("</Root>");
		GetMenuTask getMenuTask = new GetMenuTask(reqstr.toString());
		getMenuTask.execute();
	}
	
	
	/**
	 * 取菜单的MD5
	 * @return
	 */
	private String getMenuMD5() {
		// 查询本地是否有菜单
		String countString ;
		try {
			countString = dbHelper.getSingle("select c_configvalue from t_localconfig " +
					"where c_configname = '" + fieldName + "'");
		} catch (Exception e) {
			// TODO: handle exception
			countString = "";
		}
		
		return countString;
	}

	private class GetMenuTask extends AsyncTask<String, Integer, Integer> {
		private String reqStr;
		private ProgressDialog progressDialog = null;

		public GetMenuTask(String reqString) {
			this.reqStr = reqString;
		}

		@Override
		protected void onPreExecute() {
			// TODO Auto-generated method stub
			progressDialog = new ProgressDialog(context);
//			progressDialog.setProgressStyle(1);
			progressDialog.setTitle("提示");
			progressDialog.setMessage("正在更新菜单...");
			progressDialog.setCancelable(false);
			progressDialog.show();
		}

		@Override
		protected Integer doInBackground(String... params) {
			// TODO Auto-generated method stub
			SocketManager cs = new SocketManager(0, ip, port);
			String resultData = cs.execute(reqStr);
			XdjaLog.v("resultData", resultData);
			//00表示当前菜单是最新的
			if (resultData.startsWith("0x00")) {
				return 0;
			}
			CErrorInfo.paserErrorMsg(resultData);
			
			if (CErrorInfo.isError) {
				return -1;
			}
			
		
			int updateCount = 0;
			// 开始事务
			try {
				List<String> list = parseSql(resultData);
				dbHelper.beginTransaction();// 开始事务
				dbHelper.execSQL("delete from t_menu"); // 清空数据库中menu表
				// 批量菜单插入sql
				String sql = "";
				for (int i = 0; i < list.size(); i++) {
					sql = list.get(i);
					dbHelper.execSQL(sql);
					publishProgress((int) (i / list.size() * 100));
				}
				dbHelper.commitTransaction();
				updateCount = list.size();
				// 更新菜单MD5
				String menuMD5 = getMD5(resultData);
				XdjaLog.v("menuMD5", menuMD5);
				updateMenuMD5(menuMD5);
			} catch (Exception e) {
				e.printStackTrace();
				dbHelper.rollback();
				return -2;
			} finally {
				dbHelper.closeDatabase();
			}
			return updateCount;

		}

		protected void onProgressUpdate(Integer... values) {
			progressDialog.show();
			// 更新进度
			progressDialog.setProgress(values[0]);
		}

		protected void onPostExecute(Integer result) {
			// TODO Auto-generated method stub
			if (progressDialog.isShowing()) {
				progressDialog.dismiss();
			}
			
			if (result == -1) {
				Toast.makeText(context, "获取菜单信息失败！", Toast.LENGTH_LONG).show();
				listener.getMenuListener(false);
				return;
			}
			if (result == -2) {
				Toast.makeText(context, "更新本地菜单失败！", Toast.LENGTH_LONG).show();
				listener.getMenuListener(false);
				return;
			}

			if (result == 0) {
//				Toast.makeText(context, "菜单已经是最新的！" , Toast.LENGTH_LONG).show();
				listener.getMenuListener(true);
				return;
			}
			Toast.makeText(context, "更新成功，更新菜单数量：" + result, Toast.LENGTH_LONG).show();
			listener.getMenuListener(true);
		}

		/**
		 * 根据后台返回的菜单信息构造SQL语句
		 * 
		 * @param menuStr菜单信息
		 * @return SQL语句集合
		 */
		private List<String> parseSql(String menuStr) {
			List<String> list = new ArrayList<String>();
			XMLParser xmlParser = new XMLParser(menuStr);
			NodeList nodeList = xmlParser.getNodeList("Row");
			String insertSql = "";
			for (int i = 2; i < nodeList.getLength(); i++) {
				String n_id = xmlParser.getFieldPointValue("n_id", i);
				String c_name = xmlParser.getFieldPointValue("c_mc", i);
				String c_parentid = xmlParser.getFieldPointValue("c_fjcd", i);
				String c_status = xmlParser.getFieldPointValue("c_zt", i);
				String c_power = xmlParser.getFieldPointValue("c_qx", i);
				String c_icon = xmlParser.getFieldPointValue("c_tbbh", i);
				String c_from = xmlParser.getFieldPointValue("c_clct", i);
				String c_reqtype = xmlParser.getFieldPointValue("c_qqlb", i);
				String c_order = xmlParser.getFieldPointValue("n_xh", i);
				insertSql = "insert into t_menu (n_fav_order,n_favorites,n_id,c_name,c_parentid,"
						+ "c_status,c_power,c_icon,c_form,c_order,c_reqtype)"
						+ "  values('0', '0', '"
						+ n_id
						+ "','"
						+ c_name
						+ "','"
						+ c_parentid
						+ "','"
						+ c_status
						+ "','"
						+ c_power
						+ "','"
						+ c_icon
						+ "','"
						+ c_from
						+ "',"
						+ c_order + ",'" + c_reqtype + "');";
				list.add(insertSql);
			}
			return list;
		}
	}
	
	/**
	 * 检查本地是否有菜单
	 * 
	 * @return true 有 false 无
	 */
	private boolean isExistMenu() {
		boolean result = false;
		// 查询本地是否有菜单
		String countString = dbHelper
				.getSingle("select count(*) as count from t_menu");
		if (!countString.equals("0")) {
			result = true;
		}
		return result;
	}

	/**
	 * 更新菜单MD5
	 * @param value 新的MD5
	 */
	private void updateMenuMD5(String value) {
		String sqlString; 
//		if (!isExsitMenuMD5()) {
//			sqlString = "insert into t_localconfig(c_configname,c_configvalue) "
//					+ " values('" + fieldName + "','" + value + "')";
//			
//		} else {
//			sqlString = "update t_localconfig set c_configvalue='"+value+"' where " +
//					"c_configname = '" + fieldName + "'";
//		}
		sqlString = "update t_localconfig set c_configvalue='"+value+"' where " +
				"c_configname = '" + fieldName + "'";
		try {
			dbHelper.execSQL(sqlString);
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		} 
	}

	/**
	 * 是否存menuMD5
	 * @return
	 */
//	private boolean isExsitMenuMD5() {
//		boolean result = false;
//		// 查询本地是否有菜单
//		String countString = dbHelper.getSingle("select count(*) as count "
//				+ "from t_localconfig where c_configname = '" + fieldName + "'");
//		if (!countString.equals("0")) {
//			result = true;
//		}
//		return result;
//	}
	
	/**
	 * MD5加密字符串
	 * @param string 源字符串
	 * @return MD5加密后的字符串
	 */
	private String getMD5(String string) {
		byte[] hash = null;
		try {
			hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		StringBuilder hex = new StringBuilder(hash.length * 2);
		for (byte b : hash) {
			if((b & 0xFF) < 0x10) hex.append("0");
			hex.append(Integer.toHexString(b & 0xFF));
		}
		return hex.toString();
	}
}
