/*
 * 网络通信类，负责发送和接收数据,并进行数据压缩和解压
 * and open the template in the editor.
 */
package com.xdja.publicclass;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

import android.R.integer;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.Exception.CErrorInfo;
import com.xdja.publicclass.ClientSocket.Connecter;


/**
 * socket管理器类，用于网络通信
 */
public class SocketManager {
    public static final String tag = "SocketManager";
    private String ip = null;// 服务器IP
    private String port = null;// 服务器端口
    private Socket conn = null;
    private InputStream is = null;// 网络输入流
    private OutputStream os = null;// 网络输出流
    private boolean connected = false;// 是否已经连接网络
    private static long timeout = 40000;// 超时时长(30秒)
    private static int getDateTimeout = 60000;// 超时时长(30秒)
    private int isSafe = 0;
    private boolean isNew = true;
    private boolean isZip = false;
    private int errorCode;

    public SocketManager() {

    }

    /**
     * 设置超时时长
     *
     * @param time
     */
    public static void setTimeout(long time) {
        timeout = time;
    }

    /**
     * 将超时时长重置为默认值40秒
     */
    public static void resetTimeout() {
        timeout = 40000;
    }

    public void setIsZip(boolean _isZip) {
        isZip = _isZip;
    }

    /**
     * 指定连接服务器的参数
     *
     * @param Safe 连接网络前是否先查看安全客户端状态 0：不查看 ；1：查看
     * @param ip   服务器IP
     * @param port 服务器端口号
     */
    public SocketManager(int Safe, String ip, String port) {
        this.isSafe = Safe;
        this.ip = ip;
        this.port = port;
    }

    /**
     * 指定连接服务器的参数(乐山专用)
     *
     * @param Safe 连接网络前是否先查看安全客户端状态 0：不查看 ；1：查看
     * @param ip   服务器IP
     * @param port 服务器端口号
     */
    public SocketManager(int Safe, String ip, String port, boolean isNew) {
        this.isSafe = Safe;
        this.ip = ip;
        this.port = port;
        this.isNew = isNew;
    }

    /**
     * 连接服务器
     *
     * @return 成功返回0 不成功返回-1 errmsg中包含错误信息
     */
    private int connect() {
        if (isSafe == 1) {
            byte[] vpnstate = new byte[100];
            int vpnstatelen = 0;
            String state = "";
            VPNSocket vpnCS = new VPNSocket("127.0.0.1", 3001);
            //modify by dut at 20140305 如果连接失败，调用 vpnCS.recvData程序会崩溃
            if (vpnCS.connect() == -1) {
                return 0x10032008;
            }
            vpnCS.sendData("GETSTATUS");
            vpnstatelen = vpnCS.recvData(vpnstate);
            state = new String(vpnstate, 0, vpnstatelen);
            if (!state.startsWith("OK 100")) {
                return 0x10032008;
            }
            //add by dut at 20140305关闭安全客户端连接
            vpnCS.close();
        }

        setConnected(false);
        if (ip == null || port == null || ip.equals("") || port.equals("")) {
            return 0x10032300;
        }
        try {
            conn = new Socket();
            conn.setSoTimeout(getDateTimeout);
            SocketAddress address = new InetSocketAddress(ip, Integer.parseInt(port));
            conn.connect(address, Integer.parseInt(timeout + ""));
            is = conn.getInputStream();
            os = conn.getOutputStream();
            setConnected(true);
            System.out.println("connect ok：" + ip + " " + port);
            return 0;
        } catch (Exception ex) {
            setConnected(false);
            System.out.println("connect error：" + ip + " " + port);
            ex.printStackTrace();
//			Log.e("SocketManager", ex.getMessage());
            return 0x10032300;
        }
    }

    /**
     * 发送数据
     */
    private int sendMsg(String msg) {
        if (!connected) {
            return 0x10032300;
        }
        if (os == null) {
            return 0x10032308;
        }
        byte[] sendbyte = null;
        if (isZip) {
            sendbyte = Functions.formatSocketSendData(msg);
        } else {
            sendbyte = Functions.formatSocketSendDataNoZip(msg);
        }

//		Log.i("bytelength----------=====================", sendbyte.length+"");
        try {
            os.write(sendbyte);
            os.flush();

            return 0;
        } catch (IOException ex) {
//			Log.e(tag, ex.getMessage());
            ex.printStackTrace();
            return 0x10032303;

        }

    }

    private String receiveMsg() {
        if (is == null) {
            if (isNew) {
                return "0x10032309" + CErrorInfo.getCErrMsg("0x10032309");
            } else {
                return CErrorInfo.errorCode2GetTf("0x10032309") + CErrorInfo.getCErrMsg("0x10032309");
            }
        }
        try {
            byte[] lengthBuf = new byte[4];
            readFully(is, lengthBuf);
            int length = Functions.bytes4ToInt(lengthBuf);
            byte[] temp = new byte[length];
            readFully(is, temp);
            byte[] unzipdata;
            if (isZip) {
                unzipdata = Gzip.unzip(temp);
            } else {
                unzipdata = temp;
            }

            String result = new String(unzipdata, "UTF-8");
            return result;
        } catch (InterruptedIOException iioe) {
            if (isNew) {
                return "0x10032307" + CErrorInfo.getCErrMsg("0x10032307");
            } else {
                return CErrorInfo.errorCode2GetTf("0x10032307") + CErrorInfo.getCErrMsg("0x10032307");
            }
        } catch (Exception ex) {
            String msg = ex.getMessage();
//			Log.e(tag, ex.getMessage());
            ex.printStackTrace();
            //ackMsg = "-1 接收数据失败IO错误";
            if (msg.startsWith("0x1003")) {
                if (isNew) {
                    return msg + CErrorInfo.getCErrMsg(msg);
                } else {
                    return CErrorInfo.errorCode2GetTf(msg) + CErrorInfo.getCErrMsg(msg);
                }
            } else {
                if (isNew) {
                    return "0x10032306" + CErrorInfo.getCErrMsg("0x10032306");
                } else {
                    return CErrorInfo.errorCode2GetTf("0x10032306") + CErrorInfo.getCErrMsg("0x10032306");
                }

            }
        }
    }

    /**
     * 断开连接
     */
    public void disConnect() {
        try {
            if (is != null) {
                is.close();
            }
        } catch (IOException ex) {
//			Log.e(tag, ex.getMessage());
            ex.printStackTrace();
        }
        try {
            if (os != null) {
                os.close();
            }
        } catch (IOException ex) {
//			Log.e(tag, ex.getMessage());
            ex.printStackTrace();
        }
        try {
            if (conn != null) {
                conn.close();
            }
        } catch (IOException ex) {
//			Log.e(tag, ex.getMessage());
            ex.printStackTrace();
        }
        setConnected(false);
    }

    /**
     * 执行网络通信
     *
     * @param msg
     * @return 服务器返回信息
     */
    public String execute(String msg) {
        String resMsg = "";
        try {
            int renum = 0;
            renum = connect();
            XdjaLog.e("==================", renum + "");
            if (renum != 0) {
                String errorcode = "0x" + Integer.toHexString(renum);
                if (isNew) {
                    resMsg = errorcode + CErrorInfo.getCErrMsg(errorcode);
                } else {
                    resMsg = CErrorInfo.errorCode2GetTf(errorcode) + CErrorInfo.getCErrMsg(errorcode);
                }
                return resMsg;
            }
            renum = sendMsg(msg);
            if (renum != 0) {
                String errorcode = "0x" + Integer.toHexString(renum);
                resMsg = errorcode + CErrorInfo.getCErrMsg(errorcode);
                if (isNew) {
                    resMsg = errorcode + CErrorInfo.getCErrMsg(errorcode);
                } else {
                    resMsg = CErrorInfo.errorCode2GetTf(errorcode) + CErrorInfo.getCErrMsg(errorcode);
                }
                return resMsg;
            }
            resMsg = receiveMsg();
        } finally {
            disConnect();
        }
        return resMsg;
    }

    /**
     * 设置是否已经连接网络
     *
     * @param state 连网状态
     */
    //modify by dut at 20140226这个方法应该私有
    private synchronized void setConnected(boolean state) {
        connected = state;
    }

    private static void readFully(InputStream in, byte[] buffer) throws IOException, InterruptedIOException {
        int bytesRead = 0;
        long currentTime = System.currentTimeMillis();
//		System.out.println("timeout,readStart---------s");
        while (bytesRead < buffer.length) {

            if (System.currentTimeMillis() - currentTime >= timeout) {
                System.out.println("timeout,0x10032307");
                throw new IOException("0x10032307");
                // break;
            }

            int count = in.read(buffer, bytesRead, buffer.length - bytesRead);
            if (count == -1) {
                System.out.println("timeout,0x10032309");
                throw new IOException("0x10032309");
            }
            bytesRead += count;
//			System.out.println("timeout,readStart+++");
        }
    }

}
