package com.xdja.publicclass;

import java.io.File;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import android.os.Environment;

public class XdjaLog {

	private static boolean debug = false;
	private static boolean WriteLogToSDCard = false;
	private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
	
	/**
	 * 设置是否将日志输出到SD卡
	 * @param writeLogToSDCard
	 */
	public static void setWriteLogToSDCard(boolean writeLogToSDCard) {
		WriteLogToSDCard = writeLogToSDCard;
	}

	/**
	 * 设置是否打印日志
	 * @param _debug
	 */
	public static void setDebugMode(boolean _debug) {
		debug = _debug;
	}

	/**
	 * Log.i
	 * @param s 日志标记
	 * @param s1 日志内容
	 */
	public static void i(String s, String s1) {
		if (debug){
			if(s1 == null){
				android.util.Log.i(s, "null");
			}else{
				android.util.Log.i(s, s1);
			}
		}
		if(WriteLogToSDCard){
			if(s1 == null){
				writeFileToSD(getCurTime()+"\t"+s+"\r\n");
			}else{
				writeFileToSD(getCurTime()+"\t"+s+"\t"+s1+"\r\n");
			}
		}
	}

	/**
	 * Log.w
	 * @param s 日志标记
	 * @param s1 日志内容
	 */
	public static void w(String s, String s1) {
		if (debug){
			if(s1 == null){
				android.util.Log.w(s, "null");
			}else{
				android.util.Log.w(s, s1);
			}
		}
		if(WriteLogToSDCard){
			if(s1 == null){
				writeFileToSD(getCurTime()+"\t"+s+"\r\n");
			}else{
				writeFileToSD(getCurTime()+"\t"+s+"\t"+s1+"\r\n");
			}
		}
	}

	/**
	 * Log.v
	 * @param s 日志标记
	 * @param s1 日志内容
	 */
	public static void v(String s, String s1) {
		if (debug){
			if(s1 == null){
				android.util.Log.v(s, "null");
			}else{
				android.util.Log.v(s, s1);
			}
		}
		if(WriteLogToSDCard){
			if(s1 == null){
				writeFileToSD(getCurTime()+"\t"+s+"\r\n");
			}else{
				writeFileToSD(getCurTime()+"\t"+s+"\t"+s1+"\r\n");
			}
		}
	}

	/**
	 * Log.e
	 * @param s 日志标记
	 * @param s1 日志内容
	 */
	public static void e(String s, String s1) {
		if (debug){
			if(s1 == null){
				android.util.Log.e(s, "null");
			}else{
				android.util.Log.e(s, s1);
				
			}
		}
		if(WriteLogToSDCard){
			if(s1 == null){
				writeFileToSD(getCurTime()+"\t"+s+"\r\n");
			}else{
				writeFileToSD(getCurTime()+"\t"+s+"\t"+s1+"\r\n");
			}
		}
	}
	
	/**
	 * Log.e
	 * @param s 日志标记
	 * @param s1 日志内容
	 * @param tr 
	 */
	public static void e(String s, String s1, Throwable tr) {
		if (debug){
			if(s1 == null){
				android.util.Log.e(s, "null",tr);
			}else{
				android.util.Log.e(s, s1, tr);
				
			}
		}
		if(WriteLogToSDCard){
			if(s1 == null){
				writeFileToSD(getCurTime()+"\t"+s+"\r\n");
			}else{
				writeFileToSD(getCurTime()+"\t"+s+"\t"+s1+"\r\n");
			}
		}
	}
	
	/**
	 * Log.d
	 * @param s 日志标记
	 * @param s1 日志内容
	 */
	public static void d(String s, String s1) {
		if (debug){
			if(s1 == null){
				android.util.Log.d(s, "null");
			}else{
				android.util.Log.d(s, s1);
			}
		}
		if(WriteLogToSDCard){
			if(s1 == null){
				writeFileToSD(getCurTime()+"\t"+s+"\r\n");
			}else{
				writeFileToSD(getCurTime()+"\t"+s+"\t"+s1+"\r\n");
			}
		}
	}

	private static String getCurTime(){
		String temp = long2String(System.currentTimeMillis());
		return temp;
	}
	
	private static String long2String(long time) {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return df.format(new Date(time));
	}
	
//	public static void exportFileToSD(){
//		String filePath = Environment.getExternalStorageDirectory().getAbsolutePath()+"//xdjalog//push//";
//		XdjaLog.exportLog("com.xdja.push", filePath);
//	}
	
	/**
	 * 把日志输出到SD卡
	 * 
	 * @param context
	 */
	private static void writeFileToSD(String context) {
//		XdjaLog.saveLog("com.xdja.push", "pushlog.txt", context);
		
		String sdStatus = Environment.getExternalStorageState();
		if (!sdStatus.equals(Environment.MEDIA_MOUNTED)) {
			return;
		}
		try {
			String time = formatter.format(new Date());
			String filePath = Environment.getExternalStorageDirectory().getAbsolutePath()+"//xdjalog//push//";
			String fileName = "log"+time+".txt";
			
			File dir = new File(filePath);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			
			File file = new File(filePath+fileName);
			if (!file.exists()) {
				file.createNewFile();
			}
			
			RandomAccessFile raf = new RandomAccessFile(file, "rw");
			raf.seek(file.length());
			raf.write(context.getBytes());
			raf.close();

		} catch (Exception e) {
		}
	}

}
