/*
 * Decompiled with CFR 0.152.
 */
package com.safetf;

import com.safetf.XDJA_FILE;
import com.safetf.XDJA_SM2_PARAM;
import com.safetf.XDJA_SM2_PRIKEY;
import com.safetf.XDJA_SM2_PUBKEY;
import de.enough.polish.util.base64.Base64;
import java.util.Arrays;

public class SafeTF {
    public static final int SM2_KEY_GENERATE_DICT_SEND = 0;
    public static final int SM2_KEY_GENERATE_DICT_RECV = 1;
    private static String safeDeviceType = "u";
    private static SafeTF mytf;
    private static int tfHandle;
    private static int lastErrorCode;
    private static int hMutex;

    static {
        System.loadLibrary("safetf");
        mytf = null;
        tfHandle = 0;
        lastErrorCode = 0;
        hMutex = 0;
    }

    private native int aes(byte[] var1, byte[] var2, byte[] var3, int var4);

    private native int CalculateEncKey(int var1, byte[] var2, byte[] var3);

    private native String GetVersion();

    private native int OpenSTFCardAuto();

    private native int OpenUaegis();

    private native int GetSafeDeviceType(int var1);

    private native void CloseUaegis();

    private native String GetTFRootPath(int var1);

    private native int BeginTransaction(int var1);

    private native int EndTransaction(int var1);

    private native int CardReset(int var1);

    private native void CloseSTFCard(int var1);

    private native int GetCardDirSize(int var1, int[] var2);

    private native int CreateTFFile(int var1, XDJA_FILE var2);

    private native int GetCardFileAttribute(int var1, byte[] var2, XDJA_FILE var3);

    private native int DeleteCardFile(int var1, byte[] var2);

    private native int SelectApp(int var1, byte[] var2);

    private native int GetRePINCount(int var1, int var2);

    private native int Pin(int var1, byte[] var2, int var3);

    private native int SafePin(int var1, byte[] var2, int var3);

    private native int IndustryCertification(int var1);

    private native int GenRandom(int var1, int var2, byte[] var3);

    private native int GetCardID(int var1, byte[] var2, int[] var3);

    private native int SafeChangePin(int var1, byte[] var2, byte[] var3, int var4);

    private native int GenerateRSAKey(int var1, byte[] var2, byte[] var3);

    private native int GenerateRSAKeyEx(int var1, int var2, byte[] var3, byte[] var4);

    private native int GenContextRSAKey(int var1, int var2, int var3);

    private native int ReadRSAPubKey(int var1, byte[] var2, byte[] var3, int[] var4);

    private native int WriteRSAPubKey(int var1, byte[] var2, byte[] var3, int var4);

    private native int PubKeyCalculate(int var1, byte[] var2, byte[] var3, byte[] var4);

    private native int PubKeyCalculateEx(int var1, byte[] var2, int var3, byte[] var4, int[] var5, byte[] var6);

    private native int PriKeyCalculate(int var1, byte[] var2, byte[] var3, byte[] var4);

    private native int PriKeyCalculateEx(int var1, byte[] var2, int var3, byte[] var4, int[] var5, byte[] var6);

    private native int Signature(int var1, byte[] var2, byte[] var3, byte[] var4);

    private native int SignatureEx(int var1, byte[] var2, byte[] var3, byte[] var4);

    private native int SHA1Calculate(int var1, byte[] var2, byte[] var3);

    private native int SM1KEY(int var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6);

    private native int SM1KEYEX(int var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, byte[] var7);

    public native int SM4KEY(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5);

    private native int SM6KEY(int var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6);

    private native int GetCert(int var1, byte[] var2, int[] var3, byte[] var4);

    private native int ImportKey(int var1, int var2, byte[] var3, byte var4);

    private native int SM1(int var1, byte[] var2, int var3, byte[] var4, byte var5, byte[] var6);

    private native int ReadCardBinFile(int var1, byte[] var2, int var3, int var4, byte[] var5);

    private native int WriteCardBinFile(int var1, byte[] var2, int var3, int var4, byte[] var5);

    private native int ReadIccid(int var1, byte[] var2, int[] var3);

    private native int CheckCertIsExist(int var1, int var2, int var3, int[] var4);

    private native int WriteCert(int var1, int var2, int var3, byte[] var4);

    private native int DelCertRelateInfo(int var1, int var2, int var3);

    private native int GetCertInfo(int var1, byte var2, int[] var3, byte[] var4);

    private native int GetCertOrgName(int var1, byte[] var2, byte[] var3, int[] var4);

    private native int GetCertCNAndIssuer(int var1, byte var2, byte[] var3, byte[] var4, int[] var5, byte[] var6, int[] var7);

    private native int GetCertId(int var1, byte var2, byte[] var3, byte[] var4);

    private native int GetRSAPubKeyId(int var1, byte var2, byte[] var3, byte[] var4);

    private native int GetRSAPriKeyId(int var1, byte var2, byte[] var3, byte[] var4);

    private native int SetSM2Identity(int var1, byte[] var2);

    private native int GetSM2Identity(int var1, byte[] var2, int[] var3);

    private native int SetSM2Param(int var1, XDJA_SM2_PARAM var2);

    private native int GetSM2Param(int var1, XDJA_SM2_PARAM var2);

    private native int GenerateSM2Key(int var1, byte[] var2, byte[] var3, XDJA_SM2_PUBKEY var4, XDJA_SM2_PRIKEY var5);

    private native int GenContextSM2Key(int var1, int var2, int var3);

    private native int SM2Signature(int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    private native int SM2SignatureVerify(int var1, byte[] var2, byte[] var3, XDJA_SM2_PARAM var4, XDJA_SM2_PUBKEY var5, byte[] var6, byte[] var7);

    private native int SM2SignatureEx(int var1, byte[] var2, byte[] var3, byte[] var4);

    private native int SM2SignatureVerifyEx(int var1, byte[] var2, XDJA_SM2_PUBKEY var3, byte[] var4, byte[] var5);

    private native int SM2Encrypt(int var1, byte[] var2, XDJA_SM2_PUBKEY var3, byte[] var4, byte[] var5, int[] var6);

    private native int SM2Decrypt(int var1, byte[] var2, byte[] var3, byte[] var4, int[] var5);

    private native int SM2KeyGenerateInit(int var1, byte[] var2, byte[] var3, int[] var4);

    private native int SM2KeyGenerateCompute(int var1, byte[] var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int[] var8, byte var9);

    private native int SM2KeyGenerateVerify(int var1, byte[] var2);

    private native int ReadSm2GenerateKey(int var1, int var2, byte[] var3);

    private native int ReadSM2PubKey(int var1, byte[] var2, XDJA_SM2_PUBKEY var3);

    private native int WriteSM2PubKey(int var1, byte[] var2, XDJA_SM2_PUBKEY var3);

    private native int SM3Hash(byte[] var1, byte[] var2);

    private native int GetIdleContextID(int var1, int var2, byte[] var3);

    private native int CreateCertContext(int var1, int var2, byte[] var3);

    private native int DeleteCertContext(int var1, int var2);

    private native int ImportPkcs12(int var1, int var2, int var3, byte[] var4, byte[] var5);

    private native int Pkcs7Sign(int var1, byte[] var2, byte[] var3, int[] var4, byte[] var5);

    private native int Pkcs7SignEx(int var1, byte[] var2, byte[] var3, int[] var4, byte[] var5, int var6);

    private native int MakeTFCosCmd(int var1, byte[] var2);

    private native int GetCertSN(int var1, byte[] var2, byte[] var3, int[] var4);

    private native int genKey(int var1, byte[] var2);

    private native int encryptBusinessData(int var1, byte[] var2, byte[] var3, int var4);

    private native int decryptBusinessData(int var1, byte[] var2, byte[] var3, int var4);

    private SafeTF() {
    }

    public static SafeTF getInstance() {
        if (mytf == null && (tfHandle = (mytf = new SafeTF()).OpenSTFCardAuto()) < 0) {
            mytf = null;
            lastErrorCode = tfHandle;
        }
        return mytf;
    }

    public boolean exist() {
        int hHandle = this.OpenSTFCardAuto();
        if (hHandle > 0) {
            this.CloseSTFCard(hHandle);
            return true;
        }
        return false;
    }

    public String getSafeCardPath() {
        return this.GetTFRootPath(tfHandle);
    }

    public boolean beginTransaction() {
        hMutex = this.BeginTransaction(tfHandle);
        if (hMutex > 0) {
            return true;
        }
        lastErrorCode = hMutex;
        return false;
    }

    public boolean endTransaction() {
        int nres = this.EndTransaction(hMutex);
        if (nres == 0) {
            return true;
        }
        lastErrorCode = nres;
        return false;
    }

    public String getCardId() {
        byte[] pDataOut = new byte[20];
        int[] outLen = new int[]{pDataOut.length};
        int nres = this.GetCardID(tfHandle, pDataOut, outLen);
        if (nres == 0) {
            String cardId = "";
            int i = 0;
            while (i < outLen[0]) {
                cardId = String.valueOf(cardId) + String.format("%02x", pDataOut[i]);
                ++i;
            }
            return cardId;
        }
        lastErrorCode = nres;
        return null;
    }

    public int getRePINCount(int pinId) {
        int nres = this.GetRePINCount(tfHandle, pinId);
        if (nres < 0) {
            lastErrorCode = nres;
        }
        return nres;
    }

    public boolean safePin(String pin, int role) {
        int nres = this.SafePin(tfHandle, pin.getBytes(), role);
        if (nres == 0) {
            return true;
        }
        lastErrorCode = nres;
        return false;
    }

    public boolean modifyPin(String oldPin, String newPin, int role) {
        int nres = this.SafeChangePin(tfHandle, oldPin.getBytes(), newPin.getBytes(), role);
        if (nres == 0) {
            return true;
        }
        lastErrorCode = nres;
        return false;
    }

    public boolean getCertInfo(byte certType, int[] certCount, byte[] ctnIdsBuf) {
        int nres = this.GetCertInfo(tfHandle, certType, certCount, ctnIdsBuf);
        if (nres == 0) {
            return true;
        }
        lastErrorCode = nres;
        return false;
    }

    public String getCertOrg(byte[] certId) {
        byte[] orgName = new byte[512];
        int[] orgNameLen = new int[1];
        int nres = this.GetCertOrgName(tfHandle, certId, orgName, orgNameLen);
        if (nres == 0) {
            return new String(orgName, 0, orgNameLen[0]);
        }
        lastErrorCode = nres;
        return null;
    }

    public String getCertSn(byte[] certId) {
        byte[] sn = new byte[512];
        int[] snLen = new int[1];
        int nres = this.GetCertSN(tfHandle, certId, sn, snLen);
        if (nres == 0) {
            String certSn = "";
            int i = 0;
            while (i < snLen[0]) {
                certSn = String.valueOf(certSn) + String.format("%02x", sn[i]);
                ++i;
            }
            return certSn;
        }
        lastErrorCode = nres;
        return null;
    }

    public String getCertContent(byte[] certId) {
        byte[] certContent = new byte[2048];
        int[] outLen = new int[]{certContent.length};
        int nres = this.GetCert(tfHandle, certContent, outLen, certId);
        if (nres == 0) {
            return Base64.encodeBytes((byte[])certContent, (int)0, (int)outLen[0]);
        }
        lastErrorCode = nres;
        return null;
    }

    public boolean priKeyCalculate(byte[] pDataIn, byte[] pDataOut, byte[] prikeyId) {
        int nres = this.PriKeyCalculate(tfHandle, pDataIn, pDataOut, prikeyId);
        if (nres == 0) {
            return true;
        }
        lastErrorCode = nres;
        return false;
    }

    public boolean pkcs7Sign(byte[] pDataIn, byte[] pDataOut, int[] outLen, byte[] prikeyId) {
        int nres = this.Pkcs7Sign(tfHandle, pDataIn, pDataOut, outLen, prikeyId);
        if (nres == 0) {
            return true;
        }
        lastErrorCode = nres;
        return false;
    }

    public boolean genBusinesskey(byte[] key) {
        int nres = this.genKey(tfHandle, key);
        if (nres != 0) {
            lastErrorCode = nres;
            return false;
        }
        return true;
    }

    public byte[] encryptData(byte[] plainText, byte[] encryptKey, int businessType) {
        int padLen = (plainText.length + 1) % 16;
        if (padLen > 0) {
            padLen = 16 - padLen;
        }
        int len = plainText.length + 1 + padLen;
        byte[] tempPlainText = new byte[len];
        byte[] encryptText = new byte[len];
        Arrays.fill(tempPlainText, (byte)padLen);
        System.arraycopy(plainText, 0, tempPlainText, 0, plainText.length);
        int nres = this.sm4(tempPlainText, encryptKey, 1, encryptText, null);
        if (nres != 0) {
            lastErrorCode = nres;
            return null;
        }
        return encryptText;
    }

    public byte[] decryptData(byte[] cipherText, byte[] decryptKey, int businessType) {
        byte[] plainText = new byte[cipherText.length];
        int nres = this.sm4(cipherText, decryptKey, 0, plainText, null);
        if (nres != 0) {
            lastErrorCode = nres;
            return null;
        }
        byte padValue = plainText[plainText.length - 1];
        if (padValue > 15 || padValue < 0) {
            return null;
        }
        int len = plainText.length - 1 - padValue;
        byte[] realPlainText = new byte[len];
        System.arraycopy(plainText, 0, realPlainText, 0, len);
        return realPlainText;
    }

    public int sm3Hash(byte[] pdatain, byte[] pdataout) {
        return this.SM3Hash(pdatain, pdataout);
    }

    public int sm1(byte[] pDataIn, int flag, byte[] pDataOut, byte kNo, byte[] pIV) {
        return this.SM1(tfHandle, pDataIn, flag, pDataOut, kNo, pIV);
    }

    public int sm4(byte[] pDataIn, byte[] tempKey, int flag, byte[] pDataOut, byte[] pIV) {
        return this.SM4KEY(tempKey, pDataIn, flag, pDataOut, pIV);
    }

    public int pubkeyCalculate(byte[] pDataIn, byte[] pDataOut, byte[] fid) {
        return this.PubKeyCalculate(tfHandle, pDataIn, pDataOut, fid);
    }

    public int prikeyCalculate(byte[] pDataIn, byte[] pDataOut, byte[] fid) {
        return this.PriKeyCalculate(tfHandle, pDataIn, pDataOut, fid);
    }

    public void finalize() {
        if (tfHandle > 0) {
            this.CloseSTFCard(tfHandle);
        }
        mytf = null;
    }

    public static int getErrorCode() {
        return lastErrorCode;
    }

    public static String getErrorInfo(int errorCode) {
        String msg = "";
        switch (errorCode) {
            case 0: {
                return "\u6210\u529f";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "\u8fd8\u6709" + errorCode + "\u6b21\u6570\u91cd\u8bd5\u673a\u4f1a";
            }
            case -1: {
                return "\u672a\u77e5\u9519\u8bef";
            }
            case -2: {
                return "\u53c2\u6570\u9519\u8bef";
            }
            case -10: {
                return "\u6570\u636e\u9519\u8bef";
            }
            case -11: {
                return "\u5e94\u7528\u9501\u5b9a";
            }
            case -12: {
                return "\u6587\u4ef6\u4e0d\u5b58\u5728";
            }
            case -13: {
                return "\u547d\u4ee4\u4e0d\u5b58\u5728";
            }
            case -14: {
                return "\u6587\u4ef6\u7a7a\u95f4\u4e0d\u8db3";
            }
            case -15: {
                return "\u672a\u53d6\u968f\u673a\u6570";
            }
            case -16: {
                return "\u6587\u4ef6\u5df2\u5b58\u5728";
            }
            case -17: {
                return "\u6587\u4ef6\u5185\u5bb9\u9519\u8bef";
            }
            case -18: {
                return "\u9519\u8bef\u72b6\u6001";
            }
            case -19: {
                return "\u5361\u9501\u5b9a";
            }
            case -21: {
                return "\u547d\u4ee4\u4e0e\u5185\u5bb9\u4e0d\u7b26";
            }
            case -22: {
                return "\u6743\u9650\u4e0d\u591f";
            }
            case -23: {
                return "\u5bc6\u94a5\u6b7b\u9501";
            }
            case -32: {
                return "MAC\u9519\u8bef";
            }
            case -33: {
                return "\u5bc6\u94a5\u4e0d\u5b58\u5728";
            }
            case -34: {
                return "\u5bc6\u94a5\u7c7b\u578b\u9519";
            }
            case -35: {
                return "\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728";
            }
            case -40: {
                return "\u7b49\u5f85\u7b7e\u540d";
            }
            case -41: {
                return "\u53d6\u6d88\u7b7e\u540d";
            }
            case -100: {
                return "\u672a\u627e\u5230\u5361";
            }
            case -101: {
                return "\u672a\u627e\u5230\u5b89\u5168TF\u5361";
            }
            case -102: {
                return "\u8bfb\u5361\u6807\u8bc6\u5931\u8d25";
            }
            case -103: {
                return "\u6307\u5b9a\u76d8\u4e0d\u5b58\u5728";
            }
            case -200: {
                return "\u53d1\u9001\u547d\u4ee4\u5931\u8d25";
            }
            case -201: {
                return "\u63a5\u6536\u547d\u4ee4\u5931\u8d25";
            }
            case -202: {
                return "\u5206\u914d\u5185\u5b58\u5931\u8d25";
            }
            case -203: {
                return "\u54cd\u5e94\u4fe1\u606f\u89e3\u7801\u5931\u8d25";
            }
            case -204: {
                return "\u8fd4\u56de\u9519\u8bef\u957f\u5ea6";
            }
            case -205: {
                return "\u7f13\u51b2\u533a\u957f\u5ea6\u4e0d\u591f";
            }
            case -206: {
                return "\u63a5\u6536\u547d\u4ee4\u8d85\u65f6";
            }
            case -300: {
                return "\u8c03\u7528\u8005\u4f20\u5165\u53c2\u6570\u9519\u8bef";
            }
            case -400: {
                return "\u5361\u590d\u4f4d\u9519\u8bef";
            }
            case -500: {
                return "\u5bfc\u5165\u5bfc\u51fa\u516c\u94a5\u9519\u8bef";
            }
            case -501: {
                return "\u5bfc\u5165\u79c1\u94a5\u9519\u8bef";
            }
            case -550: {
                return "\u5f53\u524d\u5bb9\u5668\u5df2\u7ecf\u88ab\u4f7f\u7528";
            }
            case -551: {
                return "\u5f53\u524d\u5bb9\u5668\u672a\u4f7f\u7528";
            }
            case -552: {
                return "\u8d85\u8fc7\u6700\u5927\u5bb9\u5668\u4e2a\u6570";
            }
            case -600: {
                return "\u8bfb\u5199\u5361\u5185\u6587\u4ef6\u9519\u8bef";
            }
            case -800: {
                return "\u4e8b\u52a1\u6807\u8bc6\u521b\u5efa\u5931\u8d25";
            }
            case -801: {
                return "\u4e8b\u52a1\u6807\u8bc6\u68c0\u6d4b\u8d85\u65f6";
            }
            case -900: {
                return "\u8f93\u5165\u7f13\u51b2\u533a\u9519\u8bef";
            }
            case -901: {
                return "\u53e3\u4ee4\u9519\u8bef\uff0c\u91cd\u8bd5\u6b21\u6570\u4e3a\u96f6";
            }
        }
        return msg;
    }
}

