/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safedevice;

import com.safetf.SafeTF;
import com.xdja.safedevice.XDJASafeTFErrorCode;

public class XDJASafeTF {
    private static XDJASafeTF mytf = null;
    private static SafeTF safetf = null;
    private static int lastErrorCode = 0;
    private String pin = "";
    private int role = 0;
    private byte[] certId = new byte[2];
    private byte[] prikeyId = new byte[2];
    private boolean tfverify = false;

    private XDJASafeTF() {
    }

    public static XDJASafeTF getInstance() {
        if (mytf == null) {
            mytf = new XDJASafeTF();
            if (!XDJASafeTF.getSafeTFInstance()) {
                mytf = null;
                return null;
            }
        }
        return mytf;
    }

    private static boolean getSafeTFInstance() {
        if (safetf == null && (safetf = SafeTF.getInstance()) == null) {
            lastErrorCode = SafeTF.getErrorCode();
            return false;
        }
        return true;
    }

    public boolean detectSafeCard() {
        return safetf.exist();
    }

    public String getSafeCardPath() {
        return safetf.getSafeCardPath();
    }

    public int getPinSurplusCount(int pinKeyRole) {
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        int nres = safetf.getRePINCount(17);
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        return nres;
    }

    public int safeCardVerify(String pin, int pinKeyRole) {
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        int nres = -1;
        if (safetf.safePin(pin, pinKeyRole)) {
            this.pin = pin;
            this.role = pinKeyRole;
            this.tfverify = true;
            nres = 0;
        } else {
            lastErrorCode = SafeTF.getErrorCode();
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        return nres;
    }

    public int changeSafeCardPin(String oldPin, String newPin, int pinKeyRole) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return -1;
        }
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        int nres = -1;
        if (safetf.modifyPin(oldPin, newPin, pinKeyRole)) {
            this.pin = newPin;
            this.role = pinKeyRole;
            nres = 0;
        } else {
            lastErrorCode = SafeTF.getErrorCode();
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        return nres;
    }

    public String getSafeCardID() {
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        String cardId = null;
        cardId = safetf.getCardId();
        if (cardId == null) {
            lastErrorCode = SafeTF.getErrorCode();
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return cardId;
    }

    public String getSafeCardCertification(int certType) {
        if (certType == 1) {
            this.certId[0] = 0;
            this.certId[1] = 69;
        } else {
            this.certId[0] = 0;
            this.certId[1] = 72;
        }
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        String certContent = null;
        certContent = safetf.getCertContent(this.certId);
        if (certContent == null) {
            lastErrorCode = SafeTF.getErrorCode();
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return certContent;
    }

    public String getSafeCardSn(int certType) {
        if (certType == 1) {
            this.certId[0] = 0;
            this.certId[1] = 69;
        } else {
            this.certId[0] = 0;
            this.certId[1] = 72;
        }
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        String certSn = null;
        certSn = safetf.getCertSn(this.certId);
        if (certSn == null) {
            lastErrorCode = SafeTF.getErrorCode();
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return certSn;
    }

    public byte[] signData(byte[] signText, int certType, int businessType) {
        if (certType == 1) {
            this.prikeyId[0] = 0;
            this.prikeyId[1] = 71;
        } else {
            this.prikeyId[0] = 0;
            this.prikeyId[1] = 74;
        }
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return null;
        }
        byte[] signResult = new byte[signText.length + 1024];
        int[] outLen = new int[1];
        byte[] result = null;
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        if (!safetf.safePin(this.pin, this.role)) {
            lastErrorCode = SafeTF.getErrorCode();
        } else if (!safetf.pkcs7Sign(signText, signResult, outLen, this.prikeyId)) {
            lastErrorCode = SafeTF.getErrorCode();
        } else {
            result = new byte[outLen[0]];
            System.arraycopy(signResult, 0, result, 0, result.length);
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return result;
    }

    public byte[] genBusinessKey() {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return null;
        }
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        byte[] result = null;
        byte[] key = new byte[16];
        if (!safetf.safePin(this.pin, this.role)) {
            lastErrorCode = SafeTF.getErrorCode();
        } else if (!safetf.genBusinesskey(key)) {
            lastErrorCode = SafeTF.getErrorCode();
        } else {
            result = new byte[16];
            System.arraycopy(key, 0, result, 0, result.length);
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return result;
    }

    public byte[] encryptData(byte[] plainText, byte[] encryptKey, int businessType) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return null;
        }
        byte[] encryptResult = null;
        encryptResult = safetf.encryptData(plainText, encryptKey, businessType);
        if (encryptResult == null) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return encryptResult;
    }

    public byte[] decryptData(byte[] cipherText, byte[] decryptKey, int businessType) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return null;
        }
        byte[] decryptResult = null;
        decryptResult = safetf.decryptData(cipherText, decryptKey, businessType);
        if (decryptResult == null) {
            lastErrorCode = SafeTF.getErrorCode();
            return null;
        }
        return decryptResult;
    }

    public int SM3Hash(byte[] pdatain, byte[] pdataout) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return -1;
        }
        return safetf.sm3Hash(pdatain, pdataout);
    }

    public int SM1(byte[] pDataIn, int flag, byte[] pDataOut, byte kNo, byte[] pIV) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return -1;
        }
        int nres = -1;
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        if (!safetf.safePin(this.pin, this.role)) {
            lastErrorCode = SafeTF.getErrorCode();
        } else {
            nres = safetf.sm1(pDataIn, flag, pDataOut, kNo, pIV);
            if (nres != 0) {
                lastErrorCode = SafeTF.getErrorCode();
            }
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        return nres;
    }

    public int SM4(byte[] pDataIn, byte[] tempKey, int flag, byte[] pDataOut, byte[] pIV) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return -1;
        }
        return safetf.sm4(pDataIn, tempKey, flag, pDataOut, pIV);
    }

    public int PubKeyCalculate(byte[] pDataIn, byte[] pDataOut, int certType) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return -1;
        }
        int nres = -1;
        byte[] pubkeyId = new byte[2];
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        if (certType == 1) {
            pubkeyId[0] = 0;
            pubkeyId[1] = 70;
        } else {
            pubkeyId[0] = 0;
            pubkeyId[1] = 73;
        }
        nres = safetf.pubkeyCalculate(pDataIn, pDataOut, pubkeyId);
        if (nres != 0) {
            lastErrorCode = SafeTF.getErrorCode();
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        return nres;
    }

    public int PriKeyCalculate(byte[] pDataIn, byte[] pDataOut, int certType) {
        if (!this.tfverify) {
            lastErrorCode = -1000;
            return -1;
        }
        int nres = -1;
        byte[] prikeyId = new byte[2];
        if (!safetf.beginTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        if (!safetf.safePin(this.pin, this.role)) {
            lastErrorCode = SafeTF.getErrorCode();
        } else {
            if (certType == 1) {
                prikeyId[0] = 0;
                prikeyId[1] = 71;
            } else {
                prikeyId[0] = 0;
                prikeyId[1] = 74;
            }
            nres = safetf.prikeyCalculate(pDataIn, pDataOut, prikeyId);
            if (nres != 0) {
                lastErrorCode = SafeTF.getErrorCode();
            }
        }
        if (!safetf.endTransaction()) {
            lastErrorCode = SafeTF.getErrorCode();
            return -1;
        }
        return nres;
    }

    public void finalize() {
        if (!XDJASafeTF.getSafeTFInstance()) {
            return;
        }
        safetf.finalize();
        safetf = null;
    }

    public static String getErrorInfo() {
        return "[" + lastErrorCode + "]" + ":" + XDJASafeTFErrorCode.getErrorInfo(lastErrorCode);
    }
}

