/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.annotation;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.view.ViewGroup;
import com.xdja.annotation.JWTInjectView;
import java.lang.reflect.Field;

public class JWTInjector {
    private static JWTInjector injector;

    private JWTInjector() {
    }

    public static JWTInjector getInstance() {
        if (injector == null) {
            injector = new JWTInjector();
        }
        return injector;
    }

    private void injectView(Activity activity, Field field) {
        if (field.isAnnotationPresent(JWTInjectView.class)) {
            JWTInjectView viewInject = field.getAnnotation(JWTInjectView.class);
            int viewId = viewInject.value();
            try {
                field.setAccessible(true);
                field.set(activity, activity.findViewById(viewId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void injectView(Activity activity) {
        Field[] localFields;
        Field[] fields = activity.getClass().getFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(JWTInjectView.class)) continue;
                this.injectView(activity, field);
            }
        }
        if ((localFields = activity.getClass().getDeclaredFields()) != null && localFields.length > 0) {
            for (Field field : localFields) {
                if (!field.isAnnotationPresent(JWTInjectView.class)) continue;
                this.injectView(activity, field);
            }
        }
    }

    private void injectView(Fragment fragment, Field field) {
        if (field.isAnnotationPresent(JWTInjectView.class)) {
            JWTInjectView viewInject = field.getAnnotation(JWTInjectView.class);
            int viewId = viewInject.value();
            try {
                field.setAccessible(true);
                field.set(fragment, fragment.getView().findViewById(viewId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void injectView(Fragment fragment) {
        Field[] localFields;
        Field[] fields = fragment.getClass().getFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(JWTInjectView.class)) continue;
                this.injectView(fragment, field);
            }
        }
        if ((localFields = fragment.getClass().getDeclaredFields()) != null && localFields.length > 0) {
            for (Field field : localFields) {
                if (!field.isAnnotationPresent(JWTInjectView.class)) continue;
                this.injectView(fragment, field);
            }
        }
    }

    private void injectView(ViewGroup viewGroup, Field field) {
        if (field.isAnnotationPresent(JWTInjectView.class)) {
            JWTInjectView viewInject = field.getAnnotation(JWTInjectView.class);
            int viewId = viewInject.value();
            try {
                field.setAccessible(true);
                field.set(viewGroup, viewGroup.findViewById(viewId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void injectView(ViewGroup viewGroup) {
        Field[] localFields;
        Field[] fields = viewGroup.getClass().getFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(JWTInjectView.class)) continue;
                this.injectView(viewGroup, field);
            }
        }
        if ((localFields = viewGroup.getClass().getDeclaredFields()) != null && localFields.length > 0) {
            for (Field field : localFields) {
                if (!field.isAnnotationPresent(JWTInjectView.class)) continue;
                this.injectView(viewGroup, field);
            }
        }
    }
}

