/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import android.content.Context;
import com.xdja.publicclass.Functions;
import com.xdja.publicclass.Gzip;
import com.xdja.publicclass.SocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ClientSocket
implements Runnable {
    private Context context;
    private String sip = null;
    private String sport = null;
    private static Socket conn = null;
    public InputStream sin = null;
    public OutputStream sou = null;
    private static String connstr = null;
    public String errmsg = "";
    public String sendstr = null;
    public String recstr = null;
    public boolean connected = false;
    public boolean sended = false;
    public static final int PACKAGE_SIZE = 1024;
    public long TIMEOUT = 60000L;
    public SocketListener sl = null;
    public String reqtag = "";
    public boolean isBigData = false;

    public ClientSocket(SocketListener sl, String reqtag) {
        this.sl = sl;
        this.reqtag = reqtag;
    }

    public ClientSocket(String sendstr) {
        this.sendstr = sendstr;
    }

    public ClientSocket(SocketListener sl, String reqtag, String sendstr) {
        this.sl = sl;
        this.sendstr = sendstr;
        this.reqtag = reqtag;
    }

    public ClientSocket(String ip, String port) {
        this.sip = ip;
        this.sport = port;
    }

    public ClientSocket(String ip, String port, boolean isBigData) {
        this.sip = ip;
        this.sport = port;
        this.isBigData = isBigData;
        this.TIMEOUT = 600000L;
    }

    public int connect() {
        this.setConnected(false);
        Thread connThread = new Thread(new Connecter());
        connThread.start();
        long ctime = System.currentTimeMillis();
        while (!this.connected) {
            if (System.currentTimeMillis() - ctime > this.TIMEOUT) {
                this.errmsg = "\u8fde\u63a5\u7f51\u7edc\u8d85\u65f6";
                connThread = null;
                this.notifyListener();
                break;
            }
            if (connThread.isAlive()) continue;
        }
        if (this.connected) {
            return 0;
        }
        return -1;
    }

    public void disConnect() {
        try {
            if (this.sin != null) {
                this.sin.close();
            }
            if (this.sou != null) {
                this.sou.close();
            }
            if (conn != null) {
                conn.close();
            }
            this.setConnected(false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener() {
        ClientSocket clientSocket = this;
        synchronized (clientSocket) {
            try {
                this.notify();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        }
    }

    public void receiveData() {
        if (this.sl == null) {
            return;
        }
        if (this.connect() != 0) {
            this.sl.passResult(this.reqtag, "-1 \u8fde\u63a5\u7f51\u7edc\u5931\u8d25");
            this.notifyListener();
            return;
        }
        if (this.sendstr == null || this.sendstr.equals("")) {
            this.sl.passResult(this.reqtag, "-1 \u53d1\u9001\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            this.notifyListener();
            return;
        }
        this.setSended(false);
        Sender sender = new Sender();
        Thread sendthread = new Thread(sender);
        sendthread.start();
        long ctime = System.currentTimeMillis();
        System.out.println("begin to seng\uff1a " + this.sip + this.sport);
        while (!this.sended) {
            if (System.currentTimeMillis() - ctime >= this.TIMEOUT) {
                sendthread = null;
                this.setSended(false);
                this.sl.passResult(this.reqtag, "-1 \u53d1\u9001\u6570\u636e\u8d85\u65f6");
                this.notifyListener();
                return;
            }
            if (sendthread.isAlive()) continue;
        }
        if (!this.sended) {
            this.sl.passResult(this.reqtag, "-1 \u53d1\u9001\u6570\u636e\u5931\u8d25\uff1a" + this.recstr);
            this.notifyListener();
            return;
        }
        this.setRecstr(null);
        Thread recthread = new Thread(new Receiver());
        recthread.start();
        ctime = System.currentTimeMillis();
        System.out.println("begin to receive\uff1a" + this.sip + this.sport);
        while (this.recstr == null) {
            if (System.currentTimeMillis() - ctime < this.TIMEOUT) continue;
            recthread = null;
            this.sl.passResult(this.reqtag, "-1 \u63a5\u6536\u6570\u636e\u8d85\u65f6");
            this.notifyListener();
            return;
        }
        this.sl.passResult(this.reqtag, this.recstr);
        this.disConnect();
        this.notifyListener();
    }

    public String receiveData(String senddata) {
        if (!this.connected) {
            return "-1 \u8fde\u63a5\u7f51\u7edc\u5931\u8d25";
        }
        this.setSended(false);
        this.sendstr = senddata;
        Thread sendthread = new Thread(new Sender());
        sendthread.start();
        long ctime = System.currentTimeMillis();
        while (!this.sended) {
            if (System.currentTimeMillis() - ctime >= this.TIMEOUT) {
                sendthread = null;
                this.setSended(false);
                this.setRecstr("-1 \u53d1\u9001\u6570\u636e\u8d85\u65f6");
                break;
            }
            if (sendthread.isAlive()) continue;
        }
        if (!this.sended) {
            this.disConnect();
            return "-1 \u53d1\u9001\u6570\u636e\u5931\u8d25";
        }
        Thread recthread = new Thread(new Receiver());
        recthread.start();
        this.setRecstr(null);
        ctime = System.currentTimeMillis();
        while (this.recstr == null) {
            if (System.currentTimeMillis() - ctime < this.TIMEOUT) continue;
            recthread = null;
            this.setRecstr("-1 \u63a5\u6536\u6570\u636e\u8d85\u65f6");
            break;
        }
        this.disConnect();
        return this.recstr;
    }

    public void setSip(String sip) {
        this.sip = sip;
    }

    public void setSport(String sport) {
        this.sport = sport;
    }

    public synchronized void setRecstr(String rec) {
        this.recstr = rec;
    }

    public synchronized void setSendStr(String sendstr) {
        this.sendstr = sendstr;
    }

    public synchronized void setListener(SocketListener sl) {
        this.sl = sl;
    }

    public synchronized void setReqtag(String reqtag) {
        this.reqtag = reqtag;
    }

    public synchronized void setSended(boolean state) {
        this.sended = state;
    }

    public synchronized void setConnected(boolean state) {
        this.connected = state;
    }

    private static void readFully(InputStream in, byte[] buffer) throws IOException {
        int count;
        for (int bytesRead = 0; bytesRead < buffer.length; bytesRead += count) {
            count = in.read(buffer, bytesRead, buffer.length - bytesRead);
            if (count != -1) continue;
            throw new IOException("Input stream closed");
        }
    }

    @Override
    public void run() {
        this.receiveData();
    }

    public void shutDownThread() {
        this.disConnect();
    }

    public String sendDataLong(String senddata) {
        if (!this.connected) {
            return "-1 \u8fde\u63a5\u7f51\u7edc\u5931\u8d25";
        }
        this.setSended(false);
        this.sendstr = senddata;
        Thread sendthread = new Thread(new Sender());
        sendthread.start();
        long ctime = System.currentTimeMillis();
        while (!this.sended) {
            if (System.currentTimeMillis() - ctime >= this.TIMEOUT) {
                sendthread = null;
                this.setSended(false);
                this.setRecstr("-1 \u53d1\u9001\u6570\u636e\u8d85\u65f6");
                break;
            }
            if (sendthread.isAlive()) continue;
        }
        if (!this.sended) {
            this.disConnect();
            return "-1 \u53d1\u9001\u6570\u636e\u5931\u8d25";
        }
        return "0";
    }

    class Receiver
    implements Runnable {
        Receiver() {
        }

        @Override
        public void run() {
            if (ClientSocket.this.isBigData) {
                this.receiveBigData();
            } else {
                this.receiveData();
            }
        }

        private void receiveData() {
            if (ClientSocket.this.sin == null) {
                ClientSocket.this.setRecstr("-1 \u7f51\u7edc\u8fde\u63a5\u65e0\u6548");
                return;
            }
            try {
                byte[] lengthBuf = new byte[4];
                ClientSocket.readFully(ClientSocket.this.sin, lengthBuf);
                int length = Functions.bytes4ToInt(lengthBuf);
                byte[] temp = new byte[length];
                ClientSocket.readFully(ClientSocket.this.sin, temp);
                byte[] unzipdata = Gzip.unzip(temp);
                String result = new String(unzipdata, "UTF-8");
                ClientSocket.this.setRecstr(result);
            }
            catch (IOException ex) {
                System.out.println("************" + ex.getMessage());
                ClientSocket.this.setRecstr("-1 \u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38, \u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            ClientSocket.this.disConnect();
        }

        private void receiveBigData() {
            if (ClientSocket.this.sin == null) {
                ClientSocket.this.setRecstr("-1 \u7f51\u7edc\u8fde\u63a5\u65e0\u6548");
                return;
            }
            try {
                byte[] lengthBuf = new byte[4];
                ClientSocket.readFully(ClientSocket.this.sin, lengthBuf);
                int length = Functions.bytes4ToInt(lengthBuf);
                byte[] temp = new byte[length];
                ClientSocket.readFully(ClientSocket.this.sin, temp);
                ClientSocket.this.setRecstr(new String(temp));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                ClientSocket.this.setRecstr("-1 \u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38, \u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            ClientSocket.this.disConnect();
        }
    }

    class Sender
    implements Runnable {
        Sender() {
        }

        @Override
        public void run() {
            if (ClientSocket.this.isBigData) {
                this.sendBigData();
            } else {
                this.sendData();
            }
        }

        private void sendData() {
            if (!ClientSocket.this.connected) {
                ClientSocket.this.setRecstr("-1 \u7f51\u7edc\u672a\u8fde\u63a5");
                ClientSocket.this.setSended(false);
                return;
            }
            if (ClientSocket.this.sou == null) {
                ClientSocket.this.setRecstr("-1 \u7f51\u7edc\u521d\u59cb\u5316\u5931\u8d25");
                ClientSocket.this.setSended(false);
                return;
            }
            byte[] sendbyte = Functions.formatSocketSendData(ClientSocket.this.sendstr);
            try {
                ClientSocket.this.sou.write(sendbyte);
                ClientSocket.this.sou.flush();
                ClientSocket.this.setSended(true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                ClientSocket.this.setSended(true);
            }
        }

        private void sendBigData() {
            if (!ClientSocket.this.connected) {
                ClientSocket.this.setRecstr("-1 \u7f51\u7edc\u672a\u8fde\u63a5");
                ClientSocket.this.setSended(false);
                return;
            }
            if (ClientSocket.this.sou == null) {
                ClientSocket.this.setRecstr("-1 \u7f51\u7edc\u521d\u59cb\u5316\u5931\u8d25");
                ClientSocket.this.setSended(false);
                return;
            }
            byte[] sendbyte = ClientSocket.this.sendstr.getBytes();
            byte[] lenbyte = Functions.intToBytes4(sendbyte.length);
            try {
                ClientSocket.this.sou.write(lenbyte);
                ClientSocket.this.sou.write(sendbyte);
                ClientSocket.this.sou.flush();
                ClientSocket.this.setSended(true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                ClientSocket.this.setSended(true);
            }
        }
    }

    class Connecter
    implements Runnable {
        Connecter() {
        }

        @Override
        public void run() {
            this.connectNetwork();
        }

        private void connectNetwork() {
            try {
                if (ClientSocket.this.sip == null || ClientSocket.this.sport == null || ClientSocket.this.sip.equals("") || ClientSocket.this.sport.equals("")) {
                    if (ClientSocket.this.sl != null) {
                        ClientSocket.this.sl.passResult(ClientSocket.this.reqtag, "-1 \u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff0cIP\u6216\u7aef\u53e3\u8bbe\u7f6e\u4e0d\u6b63\u786e");
                        ClientSocket.this.notifyListener();
                    }
                    ClientSocket.this.setConnected(false);
                    return;
                }
                conn = new Socket(ClientSocket.this.sip, Integer.parseInt(ClientSocket.this.sport));
                ClientSocket.this.sin = conn.getInputStream();
                ClientSocket.this.sou = conn.getOutputStream();
                ClientSocket.this.setConnected(true);
                System.out.println("connect ok\uff1a" + ClientSocket.this.sip + ClientSocket.this.sport);
            }
            catch (Exception e) {
                ClientSocket.this.errmsg = e.getMessage();
                ClientSocket.this.setConnected(false);
                System.out.println("connect error\uff1a" + ClientSocket.this.sip + ClientSocket.this.sport);
                System.out.println(ClientSocket.this.errmsg);
            }
        }
    }
}

