/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.xdja.publicclass.Gzip;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DBHelper {
    public static final String TAG = "DBHelper";
    public SQLiteDatabase db;
    private SQLiteDatabase sqliteDB = null;
    private String DBFile;
    private String DBName;
    private Context context;

    public DBHelper(Context _context, String dbFile, String dbName) {
        this.context = _context;
        this.DBFile = dbFile;
        this.DBName = dbName;
        this.openDatabase();
    }

    public DBHelper(String dbFile, String dbName) {
        this.DBFile = dbFile;
        this.DBName = dbName;
        if (this.sqliteDB == null) {
            this.sqliteDB = SQLiteDatabase.openDatabase((String)this.DBFile, null, (int)0);
        } else if (!this.sqliteDB.isOpen()) {
            this.sqliteDB = SQLiteDatabase.openDatabase((String)this.DBFile, null, (int)0);
        }
        this.db = this.sqliteDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToPrivateDir() {
        if (this.context == null || this.DBFile == null || this.DBName == null) {
            throw new NullPointerException();
        }
        if (!new File(this.DBFile).exists()) {
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = this.context.getResources().getAssets().open(this.DBName);
                out = this.context.openFileOutput(this.DBName, 0);
                byte[] buffer = new byte[8192];
                int count = 0;
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                return;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void openDatabase() {
        if (this.sqliteDB == null) {
            this.copyToPrivateDir();
            this.sqliteDB = SQLiteDatabase.openDatabase((String)this.DBFile, null, (int)0);
        } else if (!this.sqliteDB.isOpen()) {
            this.sqliteDB = SQLiteDatabase.openDatabase((String)this.DBFile, null, (int)0);
        }
    }

    public void closeDatabase() {
        this.sqliteDB.close();
    }

    public void close() {
        this.sqliteDB.close();
    }

    public void beginTransaction() {
        if (this.isClosed()) {
            this.openDatabase();
        }
        this.sqliteDB.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalConfig(String tablename, String configName) {
        this.openDatabase();
        Cursor c = null;
        try {
            String var7;
            String e = "select c_configvalue from " + tablename + " where c_configname = '" + configName + "'";
            c = this.sqliteDB.rawQuery(e, (String[])null);
            if (c == null) {
                String string = "";
                return string;
            }
            c.moveToFirst();
            String configValue = c.getString(c.getColumnIndex("c_configvalue"));
            Log.v((String)TAG, (String)("select configName " + configValue));
            c.close();
            String string = var7 = configValue;
            return string;
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
        finally {
            if (c != null) {
                c.close();
            }
            this.closeDatabase();
        }
        return "";
    }

    public SQLiteDatabase getDB() {
        return this.sqliteDB;
    }

    public void commitTransaction() {
        this.sqliteDB.setTransactionSuccessful();
        this.sqliteDB.endTransaction();
    }

    public void rollback() {
        this.sqliteDB.endTransaction();
    }

    public boolean isLocked() {
        if (this.isClosed()) {
            this.openDatabase();
        }
        return this.sqliteDB.isDbLockedByOtherThreads();
    }

    public boolean isClosed() {
        return !this.sqliteDB.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSingle(String SQLString) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        Cursor c = null;
        try {
            c = this.sqliteDB.rawQuery(SQLString, null);
            if (c != null && c.getCount() > 0) {
                String name;
                c.moveToFirst();
                String string = name = c.getString(0);
                return string;
            }
            String name = "";
            return name;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (c != null && !c.isClosed()) {
                c.close();
                c = null;
            }
        }
    }

    public Cursor query(String sql) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        Cursor c = null;
        try {
            c = this.sqliteDB.rawQuery(sql, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public Cursor query(String sql, String[] selectionArgs) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        Cursor c = null;
        try {
            c = this.sqliteDB.rawQuery(sql, selectionArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        Cursor c = null;
        try {
            c = this.sqliteDB.query(table, columns, selection, selectionArgs, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        Cursor c = null;
        try {
            c = this.sqliteDB.query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public void execSQL(String sql) throws SQLException {
        if (this.isClosed()) {
            this.openDatabase();
        }
        this.sqliteDB.execSQL(sql);
    }

    public void execSql(String sql) throws SQLException {
        this.execSQL(sql);
    }

    public static byte[] FormatSocketSendData(String str) {
        if (str == null) {
            return null;
        }
        byte[] tbyte = Gzip.zip(DBHelper.getUTF8Bytes(str));
        byte[] lenbyte = DBHelper.IntToBytes4(tbyte.length);
        byte[] allbyte = new byte[tbyte.length + 4];
        System.arraycopy(lenbyte, 0, allbyte, 0, 4);
        System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
        Object tbyte1 = null;
        Object lenbyte1 = null;
        return allbyte;
    }

    public static byte[] getUTF8Bytes(String s) {
        char[] c = s.toCharArray();
        int len = c.length;
        int count = 0;
        for (int b = 0; b < len; ++b) {
            char off = c[b];
            if (off <= '\u007f') {
                ++count;
                continue;
            }
            if (off <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        byte[] var8 = new byte[count];
        int var9 = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                var8[var9++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                var8[var9++] = (byte)(ch >> 6 | 0xC0);
                var8[var9++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            var8[var9++] = (byte)(ch >> 12 | 0xE0);
            var8[var9++] = (byte)(ch >> 6 & 0x3F | 0x80);
            var8[var9++] = (byte)(ch & 0x3F | 0x80);
        }
        return var8;
    }

    public static int Bytes4ToInt(byte[] b) {
        int mask = 255;
        boolean temp = false;
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            int var5 = b[i] & mask;
            res |= var5;
        }
        return res;
    }

    public static byte[] IntToBytes4(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(num >> 24 - i * 8);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updataLocalConfig(String tablename, String name, String value) {
        this.openDatabase();
        try {
            ContentValues e = new ContentValues();
            e.put("c_configvalue", value);
            String[] selectionArgs = new String[]{name};
            this.db.update(tablename, e, "c_configname==?", selectionArgs);
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
        finally {
            this.closeDatabase();
        }
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (this.isClosed()) {
            this.openDatabase();
        }
        this.sqliteDB.execSQL(sql, bindArgs);
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        return this.sqliteDB.delete(table, whereClause, whereArgs);
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        return this.sqliteDB.insert(table, nullColumnHack, values);
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        if (this.isClosed()) {
            this.openDatabase();
        }
        return this.sqliteDB.update(table, values, whereClause, whereArgs);
    }
}

