/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import android.os.Handler;
import android.os.Message;
import com.xdja.publicclass.FileInfoBean;
import com.xdja.publicclass.FileUploadInterface;
import com.xdja.publicclass.Functions;
import com.xdja.publicclass.XMLParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.Socket;
import java.security.MessageDigest;
import org.w3c.dom.NodeList;

public class FileUpLoadOperation {
    private static final int UPLOAD_ING = 666;
    private static final int UPLOAD_SUCCESS = 999;
    private static final int UPLOAD_FAILURE = -110;
    private static final int UPLOAD_FILENOTFOUND = 0;
    private static final int UPLOAD_SERVER_NO_RESPONSE = 121;
    private String filepath;
    private String filename;
    private String fileid;
    private String req_type;
    private String serverIP;
    private int serverPort;
    private FileUploadInterface fileUploadInterface;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            FileUpLoadOperation.this.fileUploadInterface.sendMsg((FileInfoBean)msg.obj);
        }
    };
    private File file;
    private File fileinfo;
    private String fileinfopath;
    private long Num = 0L;
    private FileInfoBean fib;

    public FileUpLoadOperation(String filepath, String req_type, String serverIP, int serverPort, FileUploadInterface fileUploadInterface) {
        this.filepath = filepath;
        this.req_type = req_type;
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.fileUploadInterface = fileUploadInterface;
    }

    public void startUpLoad() {
        new FileUploadThread().start();
    }

    private Long queryData(String fileid) {
        String retXml = "";
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        sb.append("<ReqType>binary_file_query</ReqType>");
        sb.append("<SessionID>xdja_bs_test</SessionID>");
        sb.append("<Condition><c_id>" + fileid + "</c_id></Condition>");
        sb.append("</Root>");
        String queryStr = sb.toString();
        retXml = this.inquire(queryStr);
        if (retXml.substring(0, 2).equals("00") || retXml.substring(0, 10).equals("0x00000000")) {
            return 0L;
        }
        if (retXml.substring(0, 2).equals("-1") || retXml.substring(0, 10).equals("0x13014090")) {
            return 0L;
        }
        Long length = this.QueryAnalyseXML(retXml);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inquire(String reqXml) {
        String retXml = null;
        Socket socket = null;
        try {
            byte[] req = reqXml.getBytes("UTF-8");
            byte[] data = new byte[4 + req.length];
            byte[] dataLenth = Functions.intToBytes4(data.length - 4);
            System.arraycopy(dataLenth, 0, data, 0, 4);
            System.arraycopy(req, 0, data, 4, req.length);
            socket = new Socket(this.serverIP, this.serverPort);
            socket.setSoLinger(true, 10);
            socket.setSoTimeout(20000);
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream bis = new BufferedInputStream(socket.getInputStream());
            bos.write(data);
            bos.flush();
            retXml = this.getResultData(bis);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "00";
            return string;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return "00";
            }
        }
        return retXml;
    }

    private String getResultData(BufferedInputStream input) {
        try {
            byte[] lengthBuf = new byte[4];
            this.readyInput(input, lengthBuf);
            int length = Functions.bytes4ToInt(lengthBuf);
            byte[] savedata = new byte[length];
            this.readyInput(input, savedata);
            return new String(savedata, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void readyInput(BufferedInputStream input, byte[] buff) {
        try {
            int count;
            for (int bytesRead = 0; bytesRead < buff.length; bytesRead += count) {
                count = input.read(buff, bytesRead, buff.length - bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Long QueryAnalyseXML(String xmldata) {
        XMLParser xp = new XMLParser(xmldata);
        NodeList values = xp.getDoc().getElementsByTagName("Row");
        NodeList data = values.item(2).getChildNodes();
        String length = data.item(0).getTextContent();
        return Long.parseLong(length);
    }

    private void upLoadData() {
        try {
            FileInputStream fin;
            block12: {
                String datalength = String.valueOf(this.file.length());
                String c_md5 = this.getFileMd5(this.file);
                byte[] fileData = new byte[20480];
                String retXml = "";
                int count = 0;
                fin = new FileInputStream(this.file);
                while (true) {
                    if (this.Num != 0L) {
                        fin.skip(this.Num);
                    }
                    if ((count = fin.read(fileData)) == -1) break block12;
                    StringBuffer reqstr = new StringBuffer();
                    reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    reqstr.append("<root>");
                    reqstr.append("<sid>xdja_bs_test</sid>");
                    reqstr.append("<req_type>" + this.req_type + "</req_type>");
                    reqstr.append("<file_id>" + this.fileid + "</file_id>");
                    reqstr.append("<file_name>" + this.filename + "</file_name>");
                    reqstr.append("<file_length>" + datalength + "</file_length>");
                    reqstr.append("<md5>" + c_md5 + "</md5>");
                    reqstr.append("<data_length>" + String.valueOf(count) + "</data_length>");
                    reqstr.append("</root>");
                    String xmlStr = reqstr.toString();
                    retXml = this.send(xmlStr, fileData, count);
                    if (this.fileid.equals("") && retXml != "") {
                        this.fileid = retXml.substring(2, retXml.length());
                        this.fib.setMessageid(666);
                    }
                    this.fib.setFileid(this.fileid);
                    if (retXml == "") {
                        this.fib.setMessageid(121);
                    } else if (retXml.substring(0, 2).equals("-1")) {
                        this.fib.setMessageid(-110);
                    } else if (retXml.equals("0#\u672c\u6bb5\u6570\u636e\u4f20\u8f93\u5b8c\u6bd5")) {
                        this.fib.setMessageid(666);
                    } else if (retXml.equals("0#\u6587\u4ef6\u4fdd\u5b58\u6210\u529f")) {
                        this.fib.setMessageid(999);
                    }
                    Message message = new Message();
                    message.obj = this.fib;
                    this.mHandler.sendMessage(message);
                    if (this.fib.getMessageid() != 999 && this.fib.getMessageid() != 666) break;
                    this.deletelog(this.fileid);
                }
                this.makelog(this.fileid);
            }
            fin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fib.setMessageid(121);
            Message message = new Message();
            message.obj = this.fib;
            this.mHandler.sendMessage(message);
            this.makelog(this.fileid);
        }
    }

    private String getFileMd5(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        if (bigInt.toString(16).length() < 32) {
            String s = "";
            for (int i = 0; i < 32 - bigInt.toString(16).length(); ++i) {
                s = s + "0";
            }
            return s + bigInt.toString(16);
        }
        return bigInt.toString(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String send(String reqXml, byte[] fileData, int count) {
        String retXml = "";
        Socket socket = null;
        try {
            byte[] data = new byte[532 + count];
            byte[] dataLenth = Functions.intToBytes4(data.length - 4);
            byte[] bfp = "binaryFileUpload".getBytes();
            byte[] req = reqXml.getBytes("UTF-8");
            System.arraycopy(dataLenth, 0, data, 0, 4);
            System.arraycopy(bfp, 0, data, 4, 16);
            System.arraycopy(req, 0, data, 20, req.length);
            System.arraycopy(fileData, 0, data, 532, count);
            socket = new Socket(this.serverIP, this.serverPort);
            socket.setSoLinger(true, 10);
            socket.setSoTimeout(10000);
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream bis = new BufferedInputStream(socket.getInputStream());
            bos.write(data);
            bos.flush();
            retXml = this.getResultData(bis);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return retXml;
    }

    private void makelog(String fileid) {
        this.fileinfo = new File(this.fileinfopath);
        this.fileinfo.delete();
        this.fileinfo = new File("/sdcard/fileinfo/");
        if (!this.fileinfo.exists()) {
            this.fileinfo.mkdirs();
        }
        String content = fileid;
        try {
            FileOutputStream outstream = new FileOutputStream(this.fileinfopath);
            OutputStreamWriter out = new OutputStreamWriter(outstream);
            out.write(content);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deletelog(String fileid) {
        this.fileinfo = new File(this.fileinfopath);
        this.fileinfo.delete();
    }

    class FileUploadThread
    extends Thread {
        FileUploadThread() {
        }

        @Override
        public void run() {
            FileUpLoadOperation.this.fib = new FileInfoBean();
            FileUpLoadOperation.this.fib.setFilepath(FileUpLoadOperation.this.filepath);
            FileUpLoadOperation.this.filename = FileUpLoadOperation.this.filepath.substring(FileUpLoadOperation.this.filepath.lastIndexOf("/") + 1);
            FileUpLoadOperation.this.fib.setFilename(FileUpLoadOperation.this.filename);
            FileUpLoadOperation.this.file = new File(FileUpLoadOperation.this.filepath);
            if (!FileUpLoadOperation.this.file.exists()) {
                FileUpLoadOperation.this.fib.setMessageid(0);
                Message message = new Message();
                message.obj = FileUpLoadOperation.this.fib;
                FileUpLoadOperation.this.mHandler.sendMessage(message);
                return;
            }
            FileUpLoadOperation.this.fileinfopath = "/mnt/sdcard/fileinfo/" + FileUpLoadOperation.this.filename.substring(0, FileUpLoadOperation.this.filename.lastIndexOf(".")) + ".txt";
            FileUpLoadOperation.this.fileinfo = new File(FileUpLoadOperation.this.fileinfopath);
            if (!FileUpLoadOperation.this.fileinfo.exists()) {
                FileUpLoadOperation.this.fileid = "";
            } else {
                try {
                    String content = "";
                    FileInputStream instream = new FileInputStream(FileUpLoadOperation.this.fileinfo);
                    if (instream != null) {
                        String line;
                        InputStreamReader inputreader = new InputStreamReader(instream);
                        BufferedReader buffreader = new BufferedReader(inputreader);
                        while ((line = buffreader.readLine()) != null) {
                            content = content + line;
                        }
                        ((InputStream)instream).close();
                        FileUpLoadOperation.this.fileid = content;
                        if (!FileUpLoadOperation.this.fileid.equals("")) {
                            FileUpLoadOperation.this.Num = FileUpLoadOperation.this.queryData(FileUpLoadOperation.this.fileid);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileUpLoadOperation.this.fileid = "";
                    FileUpLoadOperation.this.upLoadData();
                }
            }
            FileUpLoadOperation.this.upLoadData();
        }
    }
}

