/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import com.xdja.publicclass.Gzip;
import com.xdja.publicclass.IdcardUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class Functions {
    public static String nodeToString(Node node) {
        Transformer transformer = null;
        String result = null;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (transformer != null) {
            try {
                StringWriter sw = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(sw));
                return sw.toString();
            }
            catch (TransformerException te) {
                throw new RuntimeException(te.getMessage());
            }
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        int i = 0;
        char ch = '\u0000';
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len <= 0) {
            return false;
        }
        for (i = 0; i < len; ++i) {
            ch = str.charAt(i);
            if (ch >= '0' && ch <= '9' || ch == '.' || ch == '-' || ch == '+') continue;
            return false;
        }
        return true;
    }

    public static boolean validatePower(String userpower, String typepower) {
        return userpower != null && typepower != null && userpower.length() > typepower.length() && userpower.indexOf(typepower) != -1;
    }

    public static String SFZ15TO18(String idCardNo15) {
        return Functions.sfz15TO18(idCardNo15);
    }

    public static String sfz15TO18(String idCardNo15) {
        int century = 19;
        String centuryStr = "" + century;
        if (century < 0 || centuryStr.length() != 2) {
            throw new IllegalArgumentException("\u4e16\u7eaa\u6570\u65e0\u6548\uff01\u5e94\u8be5\u662f\u4e24\u4f4d\u7684\u6b63\u6574\u6570\u3002");
        }
        if (!Functions.isIdCardNo(idCardNo15) || idCardNo15.length() != 15) {
            throw new IllegalArgumentException("\u65e7\u7684\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        int[] weight = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        String newNoBody = idCardNo15.substring(0, 6) + centuryStr + idCardNo15.substring(6);
        int checkSum = 0;
        for (int i = 0; i < 17; ++i) {
            int ai = Integer.parseInt("" + newNoBody.charAt(i));
            checkSum += ai * weight[i];
        }
        int checkNum = checkSum % 11;
        String checkChar = null;
        switch (checkNum) {
            case 0: {
                checkChar = "1";
                break;
            }
            case 1: {
                checkChar = "0";
                break;
            }
            case 2: {
                checkChar = "X";
                break;
            }
            default: {
                checkChar = "" + (12 - checkNum);
            }
        }
        return newNoBody + checkChar;
    }

    public static String sfz18TO15(String idCardNo18) {
        String result = "";
        if (!Functions.isIdCardNo(idCardNo18) || idCardNo18.length() != 18) {
            return result;
        }
        try {
            result = idCardNo18.substring(0, 6) + idCardNo18.substring(8, 17);
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static boolean isIdCardNo(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len != 15 && len != 18) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            try {
                Integer.parseInt("" + str.charAt(i));
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static byte[] getUTF8Bytes(String s) {
        char[] c = s.toCharArray();
        int len = c.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        byte[] b = new byte[count];
        int off = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                b[off++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                b[off++] = (byte)(ch >> 6 | 0xC0);
                b[off++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            b[off++] = (byte)(ch >> 12 | 0xE0);
            b[off++] = (byte)(ch >> 6 & 0x3F | 0x80);
            b[off++] = (byte)(ch & 0x3F | 0x80);
        }
        return b;
    }

    public static int Bytes4ToInt(byte[] b) {
        return Functions.bytes4ToInt(b);
    }

    public static int bytes4ToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static byte[] intToBytes4(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(num >> 24 - i * 8);
        }
        return b;
    }

    public static byte[] FormatSocketSendData(String str) {
        return Functions.formatSocketSendData(str);
    }

    public static byte[] formatSocketSendData(String str) {
        if (str == null) {
            return null;
        }
        byte[] tbyte = Gzip.zip(Functions.getUTF8Bytes(str));
        byte[] lenbyte = Functions.intToBytes4(tbyte.length);
        byte[] allbyte = new byte[tbyte.length + 4];
        System.arraycopy(lenbyte, 0, allbyte, 0, 4);
        System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
        tbyte = null;
        lenbyte = null;
        return allbyte;
    }

    public static byte[] formatSocketSendDataNoZip(String str) {
        if (str == null) {
            return null;
        }
        byte[] tbyte = Functions.getUTF8Bytes(str);
        byte[] lenbyte = Functions.intToBytes4(tbyte.length);
        byte[] allbyte = new byte[tbyte.length + 4];
        System.arraycopy(lenbyte, 0, allbyte, 0, 4);
        System.arraycopy(tbyte, 0, allbyte, 4, tbyte.length);
        tbyte = null;
        lenbyte = null;
        return allbyte;
    }

    public static String formatXmlStr(String reqtype, String relation) {
        StringBuffer respstr = new StringBuffer();
        respstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        respstr.append("<RequestAgent>");
        respstr.append("<Type>" + reqtype + "</Type>");
        respstr.append("<Items>");
        respstr.append("<Values>");
        respstr.append("<Row>");
        respstr.append("<Data>result</Data>");
        respstr.append("</Row>");
        respstr.append("<Row>");
        respstr.append("<Data>\u67e5\u8be2\u7ed3\u679c</Data>");
        respstr.append("</Row>");
        respstr.append("<Row>");
        respstr.append("<Data>\u672a\u627e\u5230\u8bb0\u5f55!</Data>");
        respstr.append("</Row>");
        respstr.append("</Values>");
        respstr.append(relation);
        respstr.append("</Items>");
        respstr.append("</RequestAgent>");
        return respstr.toString();
    }

    public static String[] distinctArray(String[] array) {
        if (array != null && array.length > 1) {
            int m = array.length;
            for (int i = 0; i < array.length; ++i) {
                if (i >= array.length - 1 || !array[i].equals(array[i + 1])) continue;
                array[i] = null;
                --m;
            }
            if (m == array.length) {
                return array;
            }
            String[] tmp = new String[m];
            m = 0;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                tmp[m++] = array[i];
            }
            array = null;
            return tmp;
        }
        return null;
    }

    public static String byte2String(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            String s = dis.readUTF();
            dis.close();
            bais.close();
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] string2Byte(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream bos = new DataOutputStream(baos);
            bos.writeUTF(s);
            byte[] bytes = baos.toByteArray();
            bos.close();
            baos.close();
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] split(String original, String regex) {
        int startIndex = 0;
        Vector<String> v = new Vector<String>();
        String[] str = null;
        int index = 0;
        startIndex = original.indexOf(regex);
        while (startIndex < original.length() && startIndex != -1) {
            String temp = original.substring(index, startIndex);
            System.out.println(" " + startIndex);
            v.addElement(temp);
            index = startIndex + regex.length();
            startIndex = original.indexOf(regex, startIndex + regex.length());
        }
        v.addElement(original.substring(index + 1 - regex.length()));
        str = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            str[i] = (String)v.elementAt(i);
        }
        return str;
    }

    public static String getCurrentDate() {
        String t = "";
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int temp = calendar.get(1);
        t = t + String.valueOf(temp);
        temp = calendar.get(2);
        t = temp < 10 ? t + "0" + String.valueOf(temp) : t + String.valueOf(temp);
        temp = calendar.get(5);
        t = temp < 10 ? t + "0" + String.valueOf(temp) : t + String.valueOf(temp);
        temp = calendar.get(10);
        t = temp < 10 ? t + "0" + String.valueOf(temp) : t + String.valueOf(temp);
        temp = calendar.get(12);
        t = temp < 10 ? t + "0" + String.valueOf(temp) : t + String.valueOf(temp);
        temp = calendar.get(13);
        t = temp < 10 ? t + "0" + String.valueOf(temp) : t + String.valueOf(temp);
        return t;
    }

    public static String[] mySplit(String split_str, String source_str) {
        if (split_str == "" || source_str == "") {
            return null;
        }
        Pattern p = Pattern.compile(split_str);
        Matcher m = p.matcher(source_str);
        Vector<String> vStr = new Vector<String>();
        while (m.find()) {
            System.out.println(m.group());
            vStr.add(m.group());
        }
        return (String[])vStr.toArray();
    }

    public static String FormatReqStr(String sessionID, String reqtype, String dbsource, String isrepeat, String beginno, String condition) {
        return Functions.formatReqStr(sessionID, reqtype, dbsource, isrepeat, beginno, condition);
    }

    public static String formatReqStr(String sessionID, String reqtype, String dbsource, String isrepeat, String beginno, String condition) {
        StringBuffer reqstr = new StringBuffer();
        reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<ReqType>" + reqtype + "</ReqType>");
        reqstr.append("<SessionID>" + sessionID + "</SessionID>");
        reqstr.append("<BeginNo>" + beginno + "</BeginNo>");
        reqstr.append("<DataSource>" + dbsource + "</DataSource>");
        reqstr.append("<Condition IsRepeat=\"" + isrepeat + "\" Value=\"\">");
        if (isrepeat == "1") {
            reqstr.append("<![CDATA[" + condition + "]]>");
        } else {
            reqstr.append(condition);
        }
        reqstr.append("</Condition>");
        reqstr.append("</Root>");
        if (reqstr.length() > 0) {
            return reqstr.toString();
        }
        return "-1 \u751f\u6210\u8bf7\u6c42\u5b57\u7b26\u5931\u6548\uff01";
    }

    public static String getVehicleInfor(String sessionID, String condition, String DataSource) {
        StringBuilder reqstr = new StringBuilder();
        reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<ReqType>jdcxxtq</ReqType>");
        reqstr.append("<SessionID>" + sessionID + "</SessionID>");
        reqstr.append("<BeginNo>1</BeginNo>");
        reqstr.append("<DataSource>" + DataSource + "</DataSource>");
        reqstr.append("<Condition IsRepeat=\"1\" Value=\"\">");
        reqstr.append("<![CDATA[" + condition + "]]>");
        reqstr.append("</Condition>");
        reqstr.append("</Root>");
        return reqstr.toString();
    }

    public static boolean isIdentityId(String identityId) {
        if (Functions.isEmpty(identityId)) {
            return false;
        }
        return IdcardUtil.isIdentityCode(identityId);
    }

    public static boolean isEmpty(String sValue) {
        return TextUtils.isEmpty((CharSequence)sValue);
    }

    public static final String getNewId(String id) {
        if (id != null) {
            if (id.length() == 18 && id.substring(17).equalsIgnoreCase("*")) {
                id = id.substring(0, 17) + "X";
            }
            if (Functions.isIdentityId(id) && id.length() == 15) {
                int[] W = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
                String[] A = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
                int s = 0;
                String newid = id;
                newid = newid.substring(0, 6) + "19" + newid.substring(6, id.length());
                for (int i = 0; i < newid.length(); ++i) {
                    int j = Integer.parseInt(newid.substring(i, i + 1)) * W[i];
                    s += j;
                }
                newid = newid + A[s %= 11];
                return newid.toUpperCase();
            }
        }
        return id.toUpperCase();
    }

    public static void popAlert(Context context, String title, String msg) {
        try {
            new AlertDialog.Builder(context).setTitle((CharSequence)title).setMessage((CharSequence)msg).setNeutralButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dlg, int which) {
                }
            }).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

