/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdcardUtil {
    public static final int IDENTITYCODE_OLD = 15;
    public static final int IDENTITYCODE_NEW = 18;
    public static int[] Wi = new int[17];

    public static boolean isIdentityCode(String code) {
        if (IdcardUtil.empty(code)) {
            return false;
        }
        String birthDay = "";
        if ((code = code.trim()).length() != 15 && code.length() != 18) {
            return false;
        }
        Pattern pt = Pattern.compile("\\d{15,17}([\\dxX]{1})?");
        Matcher mt = pt.matcher(code);
        if (!mt.find()) {
            return false;
        }
        birthDay = code.length() == 15 ? "19" + code.substring(6, 12) : code.substring(6, 14);
        if (!IdcardUtil.isDate(birthDay)) {
            return false;
        }
        if (code.length() == 18) {
            String lastNum = IdcardUtil.getCheckFlag(code.substring(0, 17));
            if (!("" + code.charAt(17)).toUpperCase().equals(lastNum)) {
                return false;
            }
        }
        return true;
    }

    private static String getCheckFlag(String code) {
        int[] varArray = new int[code.length()];
        String lastNum = "";
        int numSum = 0;
        IdcardUtil.setWiBuffer();
        for (int i = 0; i < code.length(); ++i) {
            varArray[i] = Integer.parseInt("" + code.charAt(i));
            varArray[i] = varArray[i] * Wi[i];
            numSum += varArray[i];
        }
        int checkDigit = 12 - numSum % 11;
        switch (checkDigit) {
            case 10: {
                lastNum = "X";
                break;
            }
            case 11: {
                lastNum = "0";
                break;
            }
            case 12: {
                lastNum = "1";
                break;
            }
            default: {
                lastNum = String.valueOf(checkDigit);
            }
        }
        return lastNum;
    }

    private static void setWiBuffer() {
        for (int i = 0; i < Wi.length; ++i) {
            int k = (int)Math.pow(2.0, Wi.length - i);
            IdcardUtil.Wi[i] = k % 11;
        }
    }

    public static boolean empty(String o) {
        return null == o || o.length() <= 0 || o.trim().equals("");
    }

    public static String update2eighteen(String code) {
        if (IdcardUtil.empty(code)) {
            return "";
        }
        if ((code = code.trim()).length() != 15 || !IdcardUtil.isIdentityCode(code)) {
            return "";
        }
        code = code.substring(0, 6) + "19" + code.substring(6);
        code = code + IdcardUtil.getCheckFlag(code);
        return code;
    }

    public static boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }
}

