/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.widget.Toast;
import com.xdja.Exception.CErrorInfo;
import com.xdja.publicclass.DBHelper;
import com.xdja.publicclass.SocketManager;
import com.xdja.publicclass.XMLParser;
import com.xdja.publicclass.XdjaLog;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NodeList;

public class MenuManger {
    private IMenuListener listener = null;
    private Context context = null;
    private String sessionID;
    private String ip;
    private String port;
    private DBHelper dbHelper;
    private final String fieldName = "menuMD5";

    public void setListener(IMenuListener _listener) {
        this.listener = _listener;
    }

    public MenuManger(Context context, String dbFile, String dbName, String sessionId, String ip, String port) {
        this.context = context;
        this.sessionID = sessionId;
        this.ip = ip;
        this.port = port;
        this.dbHelper = new DBHelper(context, dbFile, dbName);
    }

    public void updateMenu(String menuID) {
        if (!this.isExistMenu()) {
            this.downMenu(menuID);
        } else {
            String menuMD5 = this.getMenuMD5();
            if (!TextUtils.isEmpty((CharSequence)menuMD5)) {
                this.checkMenu(menuID, menuMD5);
            } else {
                this.downMenu(menuID);
            }
        }
    }

    private void downMenu(String menuID) {
        StringBuffer reqstr = new StringBuffer();
        reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<ReqType>check_menu</ReqType>");
        reqstr.append("<SessionID>" + this.sessionID + "</SessionID>");
        reqstr.append("<Condition>");
        reqstr.append("<c_fjcd>" + menuID + "</c_fjcd>");
        reqstr.append("</Condition>");
        reqstr.append("</Root>");
        GetMenuTask getMenuTask = new GetMenuTask(reqstr.toString());
        getMenuTask.execute(new String[0]);
    }

    private void checkMenu(String menuID, String menuMD5) {
        StringBuffer reqstr = new StringBuffer();
        reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<ReqType>check_menu</ReqType>");
        reqstr.append("<SessionID>" + this.sessionID + "</SessionID>");
        reqstr.append("<Condition>");
        reqstr.append("<md5>" + menuMD5 + "</md5>");
        reqstr.append("<c_fjcd>" + menuID + "</c_fjcd>");
        reqstr.append("</Condition>");
        reqstr.append("</Root>");
        GetMenuTask getMenuTask = new GetMenuTask(reqstr.toString());
        getMenuTask.execute(new String[0]);
    }

    private String getMenuMD5() {
        String countString;
        try {
            countString = this.dbHelper.getSingle("select c_configvalue from t_localconfig where c_configname = 'menuMD5'");
        }
        catch (Exception e) {
            countString = "";
        }
        return countString;
    }

    private boolean isExistMenu() {
        boolean result = false;
        String countString = this.dbHelper.getSingle("select count(*) as count from t_menu");
        if (!countString.equals("0")) {
            result = true;
        }
        return result;
    }

    private void updateMenuMD5(String value) {
        String sqlString = "update t_localconfig set c_configvalue='" + value + "' where c_configname = '" + "menuMD5" + "'";
        try {
            this.dbHelper.execSQL(sqlString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getMD5(String string) {
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    private class GetMenuTask
    extends AsyncTask<String, Integer, Integer> {
        private String reqStr;
        private ProgressDialog progressDialog = null;

        public GetMenuTask(String reqString) {
            this.reqStr = reqString;
        }

        protected void onPreExecute() {
            this.progressDialog = new ProgressDialog(MenuManger.this.context);
            this.progressDialog.setTitle((CharSequence)"\u63d0\u793a");
            this.progressDialog.setMessage((CharSequence)"\u6b63\u5728\u66f4\u65b0\u83dc\u5355...");
            this.progressDialog.setCancelable(false);
            this.progressDialog.show();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(String ... params) {
            SocketManager cs = new SocketManager(0, MenuManger.this.ip, MenuManger.this.port);
            String resultData = cs.execute(this.reqStr);
            XdjaLog.v("resultData", resultData);
            if (resultData.startsWith("0x00")) {
                return 0;
            }
            CErrorInfo.paserErrorMsg(resultData);
            if (CErrorInfo.isError) {
                return -1;
            }
            int updateCount = 0;
            try {
                List<String> list = this.parseSql(resultData);
                MenuManger.this.dbHelper.beginTransaction();
                MenuManger.this.dbHelper.execSQL("delete from t_menu");
                String sql = "";
                for (int i = 0; i < list.size(); ++i) {
                    sql = list.get(i);
                    MenuManger.this.dbHelper.execSQL(sql);
                    this.publishProgress(new Integer[]{i / list.size() * 100});
                }
                MenuManger.this.dbHelper.commitTransaction();
                updateCount = list.size();
                String menuMD5 = MenuManger.this.getMD5(resultData);
                XdjaLog.v("menuMD5", menuMD5);
                MenuManger.this.updateMenuMD5(menuMD5);
            }
            catch (Exception e) {
                e.printStackTrace();
                MenuManger.this.dbHelper.rollback();
                Integer n = -2;
                return n;
            }
            finally {
                MenuManger.this.dbHelper.closeDatabase();
            }
            return updateCount;
        }

        protected void onProgressUpdate(Integer ... values) {
            this.progressDialog.show();
            this.progressDialog.setProgress(values[0].intValue());
        }

        protected void onPostExecute(Integer result) {
            if (this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (result == -1) {
                Toast.makeText((Context)MenuManger.this.context, (CharSequence)"\u83b7\u53d6\u83dc\u5355\u4fe1\u606f\u5931\u8d25\uff01", (int)1).show();
                MenuManger.this.listener.getMenuListener(false);
                return;
            }
            if (result == -2) {
                Toast.makeText((Context)MenuManger.this.context, (CharSequence)"\u66f4\u65b0\u672c\u5730\u83dc\u5355\u5931\u8d25\uff01", (int)1).show();
                MenuManger.this.listener.getMenuListener(false);
                return;
            }
            if (result == 0) {
                MenuManger.this.listener.getMenuListener(true);
                return;
            }
            Toast.makeText((Context)MenuManger.this.context, (CharSequence)("\u66f4\u65b0\u6210\u529f\uff0c\u66f4\u65b0\u83dc\u5355\u6570\u91cf\uff1a" + result), (int)1).show();
            MenuManger.this.listener.getMenuListener(true);
        }

        private List<String> parseSql(String menuStr) {
            ArrayList<String> list = new ArrayList<String>();
            XMLParser xmlParser = new XMLParser(menuStr);
            NodeList nodeList = xmlParser.getNodeList("Row");
            String insertSql = "";
            for (int i = 2; i < nodeList.getLength(); ++i) {
                String n_id = xmlParser.getFieldPointValue("n_id", i);
                String c_name = xmlParser.getFieldPointValue("c_mc", i);
                String c_parentid = xmlParser.getFieldPointValue("c_fjcd", i);
                String c_status = xmlParser.getFieldPointValue("c_zt", i);
                String c_power = xmlParser.getFieldPointValue("c_qx", i);
                String c_icon = xmlParser.getFieldPointValue("c_tbbh", i);
                String c_from = xmlParser.getFieldPointValue("c_clct", i);
                String c_reqtype = xmlParser.getFieldPointValue("c_qqlb", i);
                String c_order = xmlParser.getFieldPointValue("n_xh", i);
                insertSql = "insert into t_menu (n_fav_order,n_favorites,n_id,c_name,c_parentid,c_status,c_power,c_icon,c_form,c_order,c_reqtype)  values('0', '0', '" + n_id + "','" + c_name + "','" + c_parentid + "','" + c_status + "','" + c_power + "','" + c_icon + "','" + c_from + "'," + c_order + ",'" + c_reqtype + "');";
                list.add(insertSql);
            }
            return list;
        }
    }

    public static interface IMenuListener {
        public void getMenuListener(Boolean var1);
    }
}

