/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.publicclass;

import com.xdja.Exception.CErrorInfo;
import com.xdja.publicclass.Functions;
import com.xdja.publicclass.Gzip;
import com.xdja.publicclass.VPNSocket;
import com.xdja.publicclass.XdjaLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketManager {
    public static final String tag = "SocketManager";
    private String ip = null;
    private String port = null;
    private Socket conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean connected = false;
    private static long timeout = 40000L;
    private static int getDateTimeout = 60000;
    private int isSafe = 0;
    private boolean isNew = true;
    private boolean isZip = false;
    private int errorCode;

    public SocketManager() {
    }

    public static void setTimeout(long time) {
        timeout = time;
    }

    public static void resetTimeout() {
        timeout = 40000L;
    }

    public void setIsZip(boolean _isZip) {
        this.isZip = _isZip;
    }

    public SocketManager(int Safe, String ip, String port) {
        this.isSafe = Safe;
        this.ip = ip;
        this.port = port;
    }

    public SocketManager(int Safe, String ip, String port, boolean isNew) {
        this.isSafe = Safe;
        this.ip = ip;
        this.port = port;
        this.isNew = isNew;
    }

    private int connect() {
        if (this.isSafe == 1) {
            byte[] vpnstate = new byte[100];
            int vpnstatelen = 0;
            String state = "";
            VPNSocket vpnCS = new VPNSocket("127.0.0.1", 3001);
            if (vpnCS.connect() == -1) {
                return 268640264;
            }
            vpnCS.sendData("GETSTATUS");
            vpnstatelen = vpnCS.recvData(vpnstate);
            state = new String(vpnstate, 0, vpnstatelen);
            if (!state.startsWith("OK 100")) {
                return 268640264;
            }
            vpnCS.close();
        }
        this.setConnected(false);
        if (this.ip == null || this.port == null || this.ip.equals("") || this.port.equals("")) {
            return 268641024;
        }
        try {
            this.conn = new Socket();
            this.conn.setSoTimeout(getDateTimeout);
            InetSocketAddress address = new InetSocketAddress(this.ip, Integer.parseInt(this.port));
            this.conn.connect(address, Integer.parseInt(timeout + ""));
            this.is = this.conn.getInputStream();
            this.os = this.conn.getOutputStream();
            this.setConnected(true);
            System.out.println("connect ok\uff1a" + this.ip + " " + this.port);
            return 0;
        }
        catch (Exception ex) {
            this.setConnected(false);
            System.out.println("connect error\uff1a" + this.ip + " " + this.port);
            ex.printStackTrace();
            return 268641024;
        }
    }

    private int sendMsg(String msg) {
        if (!this.connected) {
            return 268641024;
        }
        if (this.os == null) {
            return 268641032;
        }
        byte[] sendbyte = null;
        sendbyte = this.isZip ? Functions.formatSocketSendData(msg) : Functions.formatSocketSendDataNoZip(msg);
        try {
            this.os.write(sendbyte);
            this.os.flush();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 268641027;
        }
    }

    private String receiveMsg() {
        if (this.is == null) {
            if (this.isNew) {
                return "0x10032309" + CErrorInfo.getCErrMsg("0x10032309");
            }
            return CErrorInfo.errorCode2GetTf("0x10032309") + CErrorInfo.getCErrMsg("0x10032309");
        }
        try {
            byte[] lengthBuf = new byte[4];
            SocketManager.readFully(this.is, lengthBuf);
            int length = Functions.bytes4ToInt(lengthBuf);
            byte[] temp = new byte[length];
            SocketManager.readFully(this.is, temp);
            byte[] unzipdata = this.isZip ? Gzip.unzip(temp) : temp;
            String result = new String(unzipdata, "UTF-8");
            return result;
        }
        catch (InterruptedIOException iioe) {
            if (this.isNew) {
                return "0x10032307" + CErrorInfo.getCErrMsg("0x10032307");
            }
            return CErrorInfo.errorCode2GetTf("0x10032307") + CErrorInfo.getCErrMsg("0x10032307");
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            ex.printStackTrace();
            if (msg.startsWith("0x1003")) {
                if (this.isNew) {
                    return msg + CErrorInfo.getCErrMsg(msg);
                }
                return CErrorInfo.errorCode2GetTf(msg) + CErrorInfo.getCErrMsg(msg);
            }
            if (this.isNew) {
                return "0x10032306" + CErrorInfo.getCErrMsg("0x10032306");
            }
            return CErrorInfo.errorCode2GetTf("0x10032306") + CErrorInfo.getCErrMsg("0x10032306");
        }
    }

    public void disConnect() {
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setConnected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String msg) {
        String resMsg = "";
        try {
            int renum = 0;
            renum = this.connect();
            XdjaLog.e("==================", renum + "");
            if (renum != 0) {
                String errorcode = "0x" + Integer.toHexString(renum);
                resMsg = this.isNew ? errorcode + CErrorInfo.getCErrMsg(errorcode) : CErrorInfo.errorCode2GetTf(errorcode) + CErrorInfo.getCErrMsg(errorcode);
                String string = resMsg;
                return string;
            }
            renum = this.sendMsg(msg);
            if (renum != 0) {
                String errorcode = "0x" + Integer.toHexString(renum);
                resMsg = errorcode + CErrorInfo.getCErrMsg(errorcode);
                resMsg = this.isNew ? errorcode + CErrorInfo.getCErrMsg(errorcode) : CErrorInfo.errorCode2GetTf(errorcode) + CErrorInfo.getCErrMsg(errorcode);
                String string = resMsg;
                return string;
            }
            resMsg = this.receiveMsg();
        }
        finally {
            this.disConnect();
        }
        return resMsg;
    }

    private synchronized void setConnected(boolean state) {
        this.connected = state;
    }

    private static void readFully(InputStream in, byte[] buffer) throws IOException, InterruptedIOException {
        int count;
        long currentTime = System.currentTimeMillis();
        for (int bytesRead = 0; bytesRead < buffer.length; bytesRead += count) {
            if (System.currentTimeMillis() - currentTime >= timeout) {
                System.out.println("timeout,0x10032307");
                throw new IOException("0x10032307");
            }
            count = in.read(buffer, bytesRead, buffer.length - bytesRead);
            if (count != -1) continue;
            System.out.println("timeout,0x10032309");
            throw new IOException("0x10032309");
        }
    }
}

