/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.queryparser;

import android.text.TextUtils;
import com.xdja.publicclass.XMLParser;
import com.xdja.queryparser.GetPhotoBean;
import com.xdja.queryparser.PageBean;
import com.xdja.queryparser.RelNodeBean;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryParser {
    private XMLParser xmlParser = null;

    public QueryParser(XMLParser _xmlParser) {
        this.xmlParser = _xmlParser;
    }

    public QueryParser(String xmlString) {
        this.xmlParser = new XMLParser(xmlString);
    }

    public String getElementValue(String name) {
        return this.xmlParser.getElementValue(name);
    }

    public String getFieldPointValue(String fieldname) {
        return this.xmlParser.getFieldPointValue(fieldname);
    }

    public String getFieldPointValue(String fieldname, int rowno) {
        return this.xmlParser.getFieldPointValue(fieldname, rowno);
    }

    public String getFieldPointAttribute(String fieldname) {
        return this.xmlParser.getFieldPointAttribute(fieldname);
    }

    public String getFieldPointAttribute(String fieldname, int rowno) {
        return this.xmlParser.getFieldPointAttribute(fieldname, rowno);
    }

    public NodeList getNodeList(String fieldName) {
        return this.xmlParser.getNodeList(fieldName);
    }

    public String[][] getCHTitleWithData() {
        NodeList nl = this.xmlParser.getNodeList("Row");
        if (nl == null || nl.getLength() < 3) {
            return null;
        }
        NodeList chElement = nl.item(1).getChildNodes();
        int iCol = chElement.getLength();
        NodeList dataElement = null;
        String[][] items = new String[nl.getLength() - 1][chElement.getLength()];
        for (int i = 2; i < nl.getLength(); ++i) {
            dataElement = nl.item(i).getChildNodes();
            for (int j = 0; j < iCol; ++j) {
                items[0][j] = chElement.item(j).getFirstChild().getNodeValue();
                items[i - 1][j] = dataElement.item(j).getFirstChild() != null ? dataElement.item(j).getFirstChild().getNodeValue() : "";
            }
        }
        return items;
    }

    public List<RelNodeBean> getRelNodes() {
        ArrayList<RelNodeBean> relNodes = null;
        NodeList nl = this.xmlParser.getNodeList("RelNode");
        if (nl == null || nl.getLength() == 0) {
            return relNodes;
        }
        relNodes = new ArrayList<RelNodeBean>();
        for (int i = 0; i < nl.getLength(); ++i) {
            NodeList relNode = nl.item(i).getChildNodes();
            RelNodeBean relBean = new RelNodeBean();
            if (relNode != null) {
                for (int j = 0; j < relNode.getLength(); ++j) {
                    Node tempNode;
                    Node parentNode = relNode.item(j);
                    if (parentNode == null || (tempNode = parentNode.getFirstChild()) == null) continue;
                    if (parentNode.getNodeName().equals("Sort")) {
                        relBean.setSort(tempNode.getNodeValue());
                        continue;
                    }
                    if (parentNode.getNodeName().equals("Name")) {
                        relBean.setName(tempNode.getNodeValue());
                        continue;
                    }
                    if (parentNode.getNodeName().equals("Condition")) {
                        relBean.setCondition(tempNode.getNodeValue());
                        continue;
                    }
                    if (parentNode.getNodeName().equals("DbSource")) {
                        relBean.setDbSource(tempNode.getNodeValue());
                        continue;
                    }
                    if (!parentNode.getNodeName().equals("Alert")) continue;
                    relBean.setAlert(tempNode.getNodeValue());
                }
            }
            relNodes.add(relBean);
        }
        return relNodes;
    }

    public GetPhotoBean getPhoto() {
        GetPhotoBean photoBean = null;
        NodeList nl = this.xmlParser.getNodeList("GetPhoto");
        NodeList photoNode = null;
        if (nl == null || nl.getLength() == 0) {
            return photoBean;
        }
        if (nl.item(0) == null) {
            return photoBean;
        }
        photoNode = nl.item(0).getChildNodes();
        if (photoNode != null) {
            photoBean = new GetPhotoBean();
            for (int i = 0; i < photoNode.getLength(); ++i) {
                Node tempNode;
                Node parentNode = photoNode.item(i);
                if (parentNode == null || (tempNode = parentNode.getFirstChild()) == null) continue;
                if (parentNode.getNodeName().equals("ReqType")) {
                    photoBean.setReqType(tempNode.getNodeValue());
                    continue;
                }
                if (parentNode.getNodeName().equals("ReqTable")) {
                    photoBean.setReqTable(tempNode.getNodeValue());
                    continue;
                }
                if (parentNode.getNodeName().equals("Condition")) {
                    photoBean.setCondition(tempNode.getNodeValue());
                    continue;
                }
                if (!parentNode.getNodeName().equals("DbSource")) continue;
                photoBean.setDbSource(tempNode.getNodeValue());
            }
        }
        return photoBean;
    }

    public PageBean getPage() {
        PageBean pageBean = null;
        NodeList nl = this.xmlParser.getNodeList("Page");
        NodeList pageNode = null;
        if (nl == null || nl.getLength() == 0) {
            return pageBean;
        }
        if (nl.item(0) == null) {
            return pageBean;
        }
        pageNode = nl.item(0).getChildNodes();
        if (pageNode != null) {
            pageBean = new PageBean();
            for (int i = 0; i < pageNode.getLength(); ++i) {
                String temp;
                Node tempNode;
                Node parentNode = pageNode.item(i);
                if (parentNode == null || (tempNode = parentNode.getFirstChild()) == null) continue;
                if (parentNode.getNodeName().equals("Size")) {
                    temp = tempNode.getNodeValue();
                    if (TextUtils.isEmpty((CharSequence)temp)) continue;
                    pageBean.setSize(Integer.parseInt(temp));
                    continue;
                }
                if (parentNode.getNodeName().equals("TotalLen")) {
                    temp = tempNode.getNodeValue();
                    if (TextUtils.isEmpty((CharSequence)temp)) continue;
                    pageBean.setTotalLen(Integer.parseInt(temp));
                    continue;
                }
                if (parentNode.getNodeName().equals("CurrentLen")) {
                    temp = tempNode.getNodeValue();
                    if (TextUtils.isEmpty((CharSequence)temp)) continue;
                    pageBean.setCurrentLen(Integer.parseInt(temp));
                    continue;
                }
                if (parentNode.getNodeName().equals("TotalPage")) {
                    temp = tempNode.getNodeValue();
                    if (TextUtils.isEmpty((CharSequence)temp)) continue;
                    pageBean.setTotalPage(Integer.parseInt(temp));
                    continue;
                }
                if (parentNode.getNodeName().equals("BeginNo")) {
                    temp = tempNode.getNodeValue();
                    if (TextUtils.isEmpty((CharSequence)temp)) continue;
                    pageBean.setBeginNo(Integer.parseInt(temp));
                    continue;
                }
                if (parentNode.getNodeName().equals("SourceCondition")) {
                    pageBean.setSourceCondition(tempNode.getNodeValue());
                    continue;
                }
                if (!parentNode.getNodeName().equals("SourceDbSource")) continue;
                pageBean.setSourceDbSource(tempNode.getNodeValue());
            }
        }
        return pageBean;
    }
}

