/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.verify;

import android.util.Log;
import android.view.View;
import com.xdja.verify.BaseVerify;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class VerifyCenter {
    List<BaseVerify> verifyList = new ArrayList<BaseVerify>();
    private String errorMsg = "";
    private View controlView;

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public View getControlView() {
        return this.controlView;
    }

    public void registVerify(String verifyType, View _view, String _msg) {
        String classString = verifyType;
        Log.v((String)"\u53cd\u5c04\u7c7b\u540d\uff1a", (String)classString);
        try {
            Class<?> baseVerifyClass = Class.forName(classString);
            Constructor<?> constructor = baseVerifyClass.getDeclaredConstructor(View.class, String.class);
            BaseVerify baseVerify = (BaseVerify)constructor.newInstance(_view, _msg);
            this.verifyList.add(baseVerify);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Boolean check() {
        Boolean result = true;
        for (BaseVerify baseVerify : this.verifyList) {
            try {
                if (baseVerify.check().booleanValue()) continue;
                result = false;
                this.errorMsg = baseVerify.getMsg();
                this.controlView = baseVerify.getControl();
            }
            catch (Exception e) {
                result = false;
                this.errorMsg = e.getMessage();
                this.controlView = baseVerify.getControl();
            }
            break;
        }
        return result;
    }

    public void clearVerifyList() {
        this.verifyList.clear();
    }
}

