/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.zip.GZipInputStream;
import de.enough.polish.util.zip.GZipOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class ZipUtil {
    public static byte[] decompress(byte[] data) throws IOException {
        return ZipUtil.decompress(data, 0);
    }

    public static byte[] decompress(byte[] data, int compressionType) throws IOException {
        int read;
        byte[] tmp = new byte[1024];
        GZipInputStream zipInputStream = new GZipInputStream(new ByteArrayInputStream(data), 1024, compressionType, true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        while ((read = zipInputStream.read(tmp, 0, 1024)) > 0) {
            bout.write(tmp, 0, read);
        }
        return bout.toByteArray();
    }

    public static byte[] compress(byte[] data) throws IOException {
        return ZipUtil.compress(data, 0);
    }

    public static byte[] compress(byte[] data, int compressionType) throws IOException {
        if (data.length > 32768) {
            return ZipUtil.compress(data, compressionType, 32768, 32768);
        }
        return ZipUtil.compress(data, compressionType, data.length, data.length);
    }

    public static byte[] compress(byte[] data, int compressionType, int plainWindowSize, int huffmanWindowSize) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        GZipOutputStream zipOutputStream = new GZipOutputStream(bout, 1024, compressionType, plainWindowSize, huffmanWindowSize);
        zipOutputStream.write(data);
        zipOutputStream.close();
        return bout.toByteArray();
    }

    private ZipUtil() {
    }
}

