/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.base64;

import de.enough.polish.util.base64.Base64;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final int BUFFER_LENGTH = 3;
    private int position;
    private byte[] buffer;
    private int numSigBytes;
    private int lineLength;
    private int options;
    private byte[] decodabet;
    private final InputStream in;

    public Base64InputStream(InputStream in) {
        this(in, 0);
    }

    public Base64InputStream(InputStream in, int options) {
        this.in = in;
        this.buffer = new byte[3];
        this.position = -1;
        this.lineLength = 0;
        this.options = options;
        this.decodabet = Base64.getDecodabet(options);
    }

    @Override
    public int read() throws IOException {
        if (this.position < 0) {
            byte[] b4 = new byte[4];
            int i = 0;
            for (i = 0; i < 4; ++i) {
                int b = 0;
                while ((b = this.in.read()) >= 0 && this.decodabet[b & 0x7F] <= -5) {
                }
                if (b < 0) break;
                b4[i] = (byte)b;
            }
            if (i == 4) {
                this.numSigBytes = Base64.decode4to3(b4, 0, this.buffer, 0, this.options);
                this.position = 0;
            } else {
                if (i == 0) {
                    return -1;
                }
                throw new IOException("Improperly padded Base64 input.");
            }
        }
        if (this.position >= 0) {
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            ++this.lineLength;
            byte b = this.buffer[this.position++];
            if (this.position >= 3) {
                this.position = -1;
            }
            return b & 0xFF;
        }
        throw new IOException("Error in Base64 code reading stream.");
    }

    @Override
    public int read(byte[] dest, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            int b = this.read();
            if (b < 0) {
                if (i != 0) break;
                return -1;
            }
            dest[off + i] = (byte)b;
        }
        return i;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

