/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.zip;

import de.enough.polish.util.zip.ZipHelper;
import java.io.IOException;
import java.io.InputStream;

public class GZipInputStream
extends InputStream {
    public static final int TYPE_DEFLATE = 0;
    public static final int TYPE_GZIP = 1;
    private InputStream inStream;
    private boolean inStreamEnded;
    private byte status;
    private static final byte EXPECTING_HEADER = 0;
    private static final byte EXPECTING_DATA = 1;
    private static final byte EXPECTING_CHECK = 2;
    private static final byte FINISHED = 3;
    private boolean hash;
    private boolean vaildData;
    private int crc32;
    private int[] crc32Table = new int[256];
    private int type;
    private boolean BFINAL;
    private int BTYPE;
    private byte[] window = new byte[32768];
    private int pProcessed = 0;
    private long allPocessed = 0L;
    byte[] outBuff;
    private int buffsize;
    int outEnd = 0;
    int lastEnd = 0;
    int outStart = 0;
    private int B0len;
    long[] smallCodeBuffer = new long[2];
    static final byte BL = 8;
    short[] huffmanTree;
    short[] distHuffTree;
    byte[] tmpRef = new byte[8];

    public GZipInputStream(InputStream inputStream, int compressionType, boolean hash) throws IOException {
        this(inputStream, 1024, compressionType, hash);
    }

    public GZipInputStream(InputStream inputStream, int size, int compressionType, boolean hash) throws IOException {
        this.inStream = inputStream;
        this.inStreamEnded = false;
        this.status = 0;
        this.hash = hash;
        this.type = compressionType;
        this.smallCodeBuffer = new long[2];
        this.huffmanTree = new short[1152];
        this.distHuffTree = new short[128];
        this.buffsize = size;
        this.outBuff = new byte[size + 300];
        if (this.type == 1) {
            ZipHelper.skipheader(inputStream);
        }
        this.crc32 = 0;
    }

    @Override
    public void close() throws IOException {
        this.inStream.close();
        this.smallCodeBuffer = null;
        this.huffmanTree = null;
        this.distHuffTree = null;
    }

    private void copyFromWindow(int start, int len, byte[] dest, int destoff) {
        if (start + len < this.window.length) {
            System.arraycopy(this.window, start, dest, 0 + destoff, len);
        } else {
            System.arraycopy(this.window, start, dest, 0 + destoff, this.window.length - start);
            System.arraycopy(this.window, 0, dest, this.window.length - start + destoff, len - (this.window.length - start));
        }
    }

    private void copyIntoWindow(int start, int len, byte[] src, int srcOff) {
        if (len + start < this.window.length) {
            System.arraycopy(src, srcOff, this.window, start, len);
        } else {
            System.arraycopy(src, srcOff, this.window, start, this.window.length - start);
            System.arraycopy(src, srcOff + (this.window.length - start), this.window, 0, len - (this.window.length - start));
        }
    }

    private void inflate() throws IOException {
        int val = 0;
        byte[] myWindow = this.window;
        byte[] myOutBuff = this.outBuff;
        System.arraycopy(myOutBuff, this.outStart, myOutBuff, 0, this.outEnd - this.outStart);
        this.outEnd -= this.outStart;
        this.outStart = 0;
        this.lastEnd = this.outEnd;
        if (this.B0len == 0 && this.smallCodeBuffer[1] < 15L) {
            this.refillSmallCodeBuffer();
        }
        while (myOutBuff.length - this.outEnd > 300 && (this.smallCodeBuffer[1] > 0L || this.B0len > 0) && this.status != 3) {
            if (this.status == 0) {
                this.processHeader();
            }
            if (this.status == 1) {
                if (this.BTYPE == 0) {
                    if (this.B0len > 0) {
                        int copyBytes = myOutBuff.length - this.outEnd > this.B0len ? this.B0len : myOutBuff.length - this.outEnd;
                        copyBytes = this.inStream.read(myOutBuff, this.outEnd, copyBytes);
                        this.copyIntoWindow(this.pProcessed, copyBytes, myOutBuff, this.outEnd);
                        this.outEnd += copyBytes;
                        this.pProcessed = this.pProcessed + copyBytes & Short.MAX_VALUE;
                        this.B0len -= copyBytes;
                    } else {
                        this.status = this.BFINAL ? (byte)2 : (byte)0;
                        if (this.smallCodeBuffer[1] < 15L) {
                            this.refillSmallCodeBuffer();
                        }
                    }
                } else {
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                    if ((val = ZipHelper.deHuffNext(this.smallCodeBuffer, this.huffmanTree)) < 256) {
                        myWindow[this.pProcessed] = (byte)val;
                        this.pProcessed = this.pProcessed + 1 & Short.MAX_VALUE;
                        myOutBuff[this.outEnd] = (byte)val;
                        ++this.outEnd;
                    } else if (val != 256) {
                        int aPos;
                        if (val > 285) {
                            throw new IOException("1");
                        }
                        int cLen = this.popSmallBuffer(ZipHelper.LENGTH_CODE[val - 257 << 1]);
                        cLen += ZipHelper.LENGTH_CODE[(val - 257 << 1) + 1];
                        if (this.smallCodeBuffer[1] < 15L) {
                            this.refillSmallCodeBuffer();
                        }
                        val = ZipHelper.deHuffNext(this.smallCodeBuffer, this.distHuffTree);
                        int cPos = this.popSmallBuffer(ZipHelper.DISTANCE_CODE[val << 1]);
                        aPos += (aPos = this.pProcessed - (cPos += ZipHelper.DISTANCE_CODE[(val << 1) + 1])) < 0 ? myWindow.length : 0;
                        int rep = cLen / cPos;
                        int rem = cLen - cPos * rep;
                        for (int j = 0; j < rep; ++j) {
                            this.copyFromWindow(aPos, cPos, myOutBuff, this.outEnd);
                            this.copyIntoWindow(this.pProcessed, cPos, myOutBuff, this.outEnd);
                            this.outEnd += cPos;
                            this.pProcessed = this.pProcessed + cPos & Short.MAX_VALUE;
                        }
                        this.copyFromWindow(aPos, rem, myOutBuff, this.outEnd);
                        this.copyIntoWindow(this.pProcessed, rem, myOutBuff, this.outEnd);
                        this.outEnd += rem;
                        this.pProcessed = this.pProcessed + rem & Short.MAX_VALUE;
                    } else {
                        this.status = this.BFINAL ? (byte)2 : (byte)0;
                    }
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                }
            }
            if (this.status != 2) continue;
            this.status = (byte)3;
            this.allPocessed = this.allPocessed + (long)this.outEnd - (long)this.lastEnd & 0xFFFFFFFFL;
            if (this.hash) {
                this.crc32 = ZipHelper.crc32(this.crc32Table, this.crc32, myOutBuff, this.lastEnd, this.outEnd - this.lastEnd);
            }
            this.popSmallBuffer(this.smallCodeBuffer[1] & 7L);
            int cCrc = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8 | this.popSmallBuffer(8L) << 16 | this.popSmallBuffer(8L) << 24;
            int iSize = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8 | this.popSmallBuffer(8L) << 16 | this.popSmallBuffer(8L) << 24;
            boolean bl = this.vaildData = (long)iSize == this.allPocessed;
            if (this.hash) {
                this.vaildData &= this.crc32 == cCrc;
            }
            if (this.vaildData) continue;
            throw new IOException("2");
        }
        if (this.status != 3) {
            this.allPocessed = this.allPocessed + (long)this.outEnd - (long)this.lastEnd & 0xFFFFFFFFL;
            if (this.hash) {
                this.crc32 = ZipHelper.crc32(this.crc32Table, this.crc32, myOutBuff, this.lastEnd, this.outEnd - this.lastEnd);
            }
        }
    }

    private void processHeader() throws IOException {
        int[] distHuffCode = new int[30];
        int[] distHuffData = new int[30];
        byte[] distHuffCodeLength = new byte[30];
        int[] huffmanCode = new int[286];
        int[] huffmanData = new int[286];
        byte[] huffmanCodeLength = new byte[286];
        this.BFINAL = this.popSmallBuffer(1L) == 1;
        this.BTYPE = this.popSmallBuffer(2L);
        if (this.BTYPE == 3) {
            throw new IllegalArgumentException();
        }
        if (this.BTYPE == 1) {
            int i;
            ZipHelper.genFixedTree(huffmanCode, huffmanCodeLength, distHuffCode, distHuffCodeLength);
            for (i = 0; i < 286; ++i) {
                huffmanData[i] = i;
            }
            for (i = 0; i < 30; ++i) {
                distHuffData[i] = i;
            }
            ZipHelper.convertTable2Tree(huffmanCode, huffmanCodeLength, huffmanData, this.huffmanTree);
            ZipHelper.convertTable2Tree(distHuffCode, distHuffCodeLength, distHuffData, this.distHuffTree);
        } else if (this.BTYPE == 2) {
            int i;
            int HLIT = this.popSmallBuffer(5L);
            int HDIST = this.popSmallBuffer(5L);
            int HCLEN = this.popSmallBuffer(4L);
            int[] miniHuffData = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
            int[] seq = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
            byte[] miniHuffCodeLength = new byte[19];
            int[] miniHuffCode = new int[19];
            for (int i2 = 0; i2 < HCLEN + 4; ++i2) {
                miniHuffCodeLength[miniHuffData[i2]] = (byte)this.popSmallBuffer(3L);
            }
            ZipHelper.genHuffTree(miniHuffCode, miniHuffCodeLength);
            ZipHelper.revHuffTree(miniHuffCode, miniHuffCodeLength);
            short[] miniTree = new short[76];
            ZipHelper.convertTable2Tree(miniHuffCode, miniHuffCodeLength, seq, miniTree);
            for (i = 0; i < huffmanCodeLength.length; ++i) {
                huffmanCodeLength[i] = 0;
            }
            for (i = 0; i < distHuffCodeLength.length; ++i) {
                distHuffCodeLength[i] = 0;
            }
            byte lastVal = 0;
            int j = 0;
            while (j < HLIT + 257 + HDIST + 1) {
                int val;
                if (this.smallCodeBuffer[1] < 15L) {
                    this.refillSmallCodeBuffer();
                }
                if ((val = ZipHelper.deHuffNext(this.smallCodeBuffer, miniTree)) < 16) {
                    lastVal = (byte)val;
                    val = 1;
                } else if (val == 16) {
                    val = this.popSmallBuffer(2L) + 3;
                } else if (val == 17) {
                    lastVal = 0;
                    val = this.popSmallBuffer(3L) + 3;
                } else if (val == 18) {
                    lastVal = 0;
                    val = this.popSmallBuffer(7L) + 11;
                }
                int k = 0;
                while (k < val) {
                    if (j < HLIT + 257) {
                        huffmanCodeLength[j] = lastVal;
                    } else {
                        distHuffCodeLength[j - (HLIT + 257)] = lastVal;
                    }
                    ++k;
                    ++j;
                }
            }
            ZipHelper.genHuffTree(huffmanCode, huffmanCodeLength);
            for (int i3 = 0; i3 < huffmanData.length; ++i3) {
                huffmanData[i3] = i3;
            }
            ZipHelper.revHuffTree(huffmanCode, huffmanCodeLength);
            ZipHelper.convertTable2Tree(huffmanCode, huffmanCodeLength, huffmanData, this.huffmanTree);
            for (j = 0; j < distHuffCode.length; ++j) {
                distHuffData[j] = j;
            }
            ZipHelper.genHuffTree(distHuffCode, distHuffCodeLength);
            ZipHelper.revHuffTree(distHuffCode, distHuffCodeLength);
            ZipHelper.convertTable2Tree(distHuffCode, distHuffCodeLength, distHuffData, this.distHuffTree);
        } else {
            this.popSmallBuffer(this.smallCodeBuffer[1] & 7L);
            this.B0len = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8;
            if (this.smallCodeBuffer[1] < 15L) {
                this.refillSmallCodeBuffer();
            }
            if (this.B0len + (this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8) != 65535) {
                throw new IOException("3");
            }
            while (this.smallCodeBuffer[1] != 0L && this.B0len > 0) {
                int val = this.popSmallBuffer(8L);
                this.window[this.pProcessed] = (byte)val;
                this.pProcessed = this.pProcessed + 1 & Short.MAX_VALUE;
                this.outBuff[this.outEnd] = (byte)val;
                ++this.outEnd;
                --this.B0len;
            }
        }
        this.status = 1;
        distHuffCode = null;
        distHuffData = null;
        distHuffCodeLength = null;
        huffmanCodeLength = null;
        huffmanCode = null;
        huffmanData = null;
    }

    public int validData() throws IOException {
        this.inflate();
        if (this.status != 3) {
            return -1;
        }
        if (this.vaildData) {
            return 1;
        }
        return 0;
    }

    private int popSmallBuffer(long len) throws IOException {
        if (len == 0L) {
            return 0;
        }
        if (this.smallCodeBuffer[1] < len) {
            this.refillSmallCodeBuffer();
        }
        int ret = (int)(this.smallCodeBuffer[0] & (long)((1 << (int)len) - 1));
        this.smallCodeBuffer[0] = this.smallCodeBuffer[0] >>> (int)len;
        this.smallCodeBuffer[1] = this.smallCodeBuffer[1] - len;
        return ret;
    }

    private void refillSmallCodeBuffer() throws IOException {
        if (!this.inStreamEnded) {
            int wanted = (int)(8L - this.smallCodeBuffer[1] / 8L - 1L);
            int count = this.inStream.read(this.tmpRef, 0, wanted);
            if (count == -1) {
                this.inStreamEnded = true;
            }
            for (int i = 0; i < count; ++i) {
                this.smallCodeBuffer[0] = this.smallCodeBuffer[0] & (255L << (int)this.smallCodeBuffer[1] ^ 0xFFFFFFFFFFFFFFFFL);
                this.smallCodeBuffer[0] = this.tmpRef[i] < 0 ? this.smallCodeBuffer[0] | (long)(this.tmpRef[i] + 256) << (int)this.smallCodeBuffer[1] : this.smallCodeBuffer[0] | (long)this.tmpRef[i] << (int)this.smallCodeBuffer[1];
                this.smallCodeBuffer[1] = this.smallCodeBuffer[1] + 8L;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.outEnd - this.outStart < this.outBuff.length - 300) {
            this.inflate();
        }
        return this.outEnd - this.outStart;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        byte[] b = new byte[this.buffsize];
        for (skipped = 0L; skipped < n && this.status != 3; skipped += (long)this.read(b)) {
        }
        return skipped;
    }

    @Override
    public int read() throws IOException {
        if (this.outEnd - this.outStart == 0) {
            this.inflate();
        }
        if (this.outEnd - this.outStart == 0 && this.inStreamEnded) {
            return -1;
        }
        return this.outBuff[this.outStart++] + 256 & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int av;
        if (this.outEnd - this.outStart < this.outBuff.length - 300) {
            this.inflate();
        }
        int copyBytes = len > (av = this.available()) ? av : len;
        System.arraycopy(this.outBuff, this.outStart, b, off, copyBytes);
        this.outStart += copyBytes;
        if (copyBytes != 0) {
            return copyBytes;
        }
        return -1;
    }
}

