/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.zip;

import java.io.IOException;
import java.io.InputStream;

public final class ZipHelper {
    public static final int[] LENGTH_CODE = new int[]{0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 1, 11, 1, 13, 1, 15, 1, 17, 2, 19, 2, 23, 2, 27, 2, 31, 3, 35, 3, 43, 3, 51, 3, 59, 4, 67, 4, 83, 4, 99, 4, 115, 5, 131, 5, 163, 5, 195, 5, 227, 0, 258};
    public static final int[] DISTANCE_CODE = new int[]{0, 1, 0, 2, 0, 3, 0, 4, 1, 5, 1, 7, 2, 9, 2, 13, 3, 17, 3, 25, 4, 33, 4, 49, 5, 65, 5, 97, 6, 129, 6, 193, 7, 257, 7, 385, 8, 513, 8, 769, 9, 1025, 9, 1537, 10, 2049, 10, 3073, 11, 4097, 11, 6145, 12, 8193, 12, 12289, 13, 16385, 13, 24577};

    public static final int encodeCode(int[] Code, int distance) {
        int i;
        for (i = 0; i < Code.length >> 1 && distance >= Code[(i << 1) + 1]; ++i) {
        }
        return i - 1;
    }

    public static final void genHuffTree(int[] huffmanCode, byte[] huffmanCodeLength) {
        int maxbits = 0;
        for (int i = 0; i < huffmanCodeLength.length; ++i) {
            int length = huffmanCodeLength[i];
            maxbits = maxbits > length ? maxbits : length;
        }
        short[] bitlen_count = new short[++maxbits];
        for (int i = 0; i < huffmanCodeLength.length; ++i) {
            byte by = huffmanCodeLength[i];
            bitlen_count[by] = (short)(bitlen_count[by] + 1);
        }
        int code = 0;
        int[] next_code = new int[maxbits];
        bitlen_count[0] = 0;
        for (int bits = 1; bits < maxbits; ++bits) {
            next_code[bits] = code = code + bitlen_count[bits - 1] << 1;
        }
        for (int i = 0; i < huffmanCode.length; ++i) {
            byte length = huffmanCodeLength[i];
            if (length == 0) continue;
            huffmanCode[i] = next_code[length];
            byte by = length;
            next_code[by] = next_code[by] + 1;
        }
    }

    public static final void revHuffTree(int[] huffmanCode, byte[] huffmanCodeLength) {
        for (int i = 0; i < huffmanCode.length; ++i) {
            int tmp = huffmanCode[i];
            int reversed = 0;
            for (int j = 0; j < huffmanCodeLength[i]; ++j) {
                reversed |= tmp >>> j & 1;
                reversed <<= 1;
            }
            huffmanCode[i] = reversed >>> 1;
        }
    }

    public static final void genFixedTree(int[] huffmanCode, byte[] huffmanCodeLength, int[] distHuffCode, byte[] distHuffCodeLength) {
        int i;
        for (i = 0; i <= 143; ++i) {
            huffmanCode[i] = 48 + i;
            huffmanCodeLength[i] = 8;
        }
        for (i = 144; i <= 255; ++i) {
            huffmanCode[i] = 400 + i - 144;
            huffmanCodeLength[i] = 9;
        }
        for (i = 256; i <= 279; ++i) {
            huffmanCode[i] = i - 256;
            huffmanCodeLength[i] = 7;
        }
        for (i = 280; i < 286; ++i) {
            huffmanCode[i] = 192 + i - 280;
            huffmanCodeLength[i] = 8;
        }
        ZipHelper.revHuffTree(huffmanCode, huffmanCodeLength);
        for (int j = 0; j < distHuffCode.length; ++j) {
            distHuffCode[j] = j;
            distHuffCodeLength[j] = 5;
        }
        ZipHelper.revHuffTree(distHuffCode, distHuffCodeLength);
    }

    public static final void genTreeLength(int[] count, byte[] huffmanCodeLength, int max_len) {
        int i;
        int[] knotCount = new int[count.length];
        int[] knotPointer = new int[count.length];
        for (int i2 = 0; i2 < count.length; i2 = (int)((short)(i2 + 1))) {
            knotCount[i2] = count[i2] != 0 ? count[i2] : Integer.MAX_VALUE;
            knotPointer[i2] = i2;
        }
        int s1 = 0;
        int s2 = 0;
        block1: while (true) {
            if (knotCount[0] < knotCount[1]) {
                s1 = 0;
                s2 = 1;
            } else {
                s1 = 1;
                s2 = 0;
            }
            for (int i3 = 2; i3 < count.length; ++i3) {
                if (knotCount[i3] < knotCount[s1]) {
                    s2 = s1;
                    s1 = i3;
                    continue;
                }
                if (knotCount[i3] >= knotCount[s2]) continue;
                s2 = i3;
            }
            if (knotCount[s2] == Integer.MAX_VALUE) break;
            int n = s1;
            knotCount[n] = knotCount[n] + knotCount[s2];
            int tmp = knotPointer[s2];
            knotCount[s2] = Integer.MAX_VALUE;
            i = 0;
            while (true) {
                if (i >= count.length) continue block1;
                if (knotPointer[i] == tmp) {
                    knotPointer[i] = knotPointer[s1];
                    int n2 = i;
                    huffmanCodeLength[n2] = (byte)(huffmanCodeLength[n2] + 1);
                } else if (knotPointer[i] == knotPointer[s1]) {
                    int n3 = i;
                    huffmanCodeLength[n3] = (byte)(huffmanCodeLength[n3] + 1);
                }
                ++i;
            }
            break;
        }
        int overflowCount = 0;
        for (i = 0; i < huffmanCodeLength.length; ++i) {
            if (huffmanCodeLength[i] <= max_len) continue;
            ++overflowCount;
        }
        if (overflowCount != 0) {
            System.out.println(" fixing " + overflowCount + " overflows  because of max=" + max_len);
            short[] overflows = new short[overflowCount];
            overflowCount = 0;
            for (int i4 = 0; i4 < huffmanCodeLength.length; i4 = (int)((short)(i4 + 1))) {
                if (huffmanCodeLength[i4] <= max_len) continue;
                overflows[overflowCount++] = i4;
            }
            int minNode = 0;
            for (int i5 = 0; i5 < huffmanCodeLength.length; ++i5) {
                if (huffmanCodeLength[i5] == 0 || huffmanCodeLength[minNode] <= huffmanCodeLength[i5]) continue;
                minNode = i5;
            }
            while (overflowCount != 0) {
                int i6;
                int exendableNode = minNode;
                for (i6 = 0; i6 < huffmanCodeLength.length; ++i6) {
                    if (huffmanCodeLength[i6] >= max_len || huffmanCodeLength[exendableNode] >= huffmanCodeLength[i6]) continue;
                    exendableNode = i6;
                }
                int overflow1 = 0;
                int overflow2 = 0;
                for (i6 = 0; i6 < overflows.length; ++i6) {
                    if (huffmanCodeLength[overflows[i6]] > huffmanCodeLength[overflow1]) {
                        overflow1 = overflows[i6];
                        continue;
                    }
                    if (huffmanCodeLength[overflows[i6]] != huffmanCodeLength[overflow1]) continue;
                    overflow2 = overflows[i6];
                }
                int n = exendableNode;
                huffmanCodeLength[n] = (byte)(huffmanCodeLength[n] + 1);
                huffmanCodeLength[overflow1] = huffmanCodeLength[exendableNode];
                int n4 = overflow2;
                huffmanCodeLength[n4] = (byte)(huffmanCodeLength[n4] - 1);
                --overflowCount;
                if (huffmanCodeLength[overflow2] != max_len) continue;
                --overflowCount;
            }
        }
    }

    public static final void convertTable2Tree(int[] huffmanCode, byte[] huffmanCodeLength, int[] huffmanData, short[] huffmanTree) {
        for (int i = 0; i < huffmanTree.length; ++i) {
            huffmanTree[i] = 0;
        }
        int nextNode = 1;
        for (int i = 0; i < huffmanCode.length; i = (int)((short)(i + 1))) {
            if (huffmanCodeLength[i] == 0) continue;
            int pointer = 0;
            for (short j = 0; j < huffmanCodeLength[i]; j = (short)(j + 1)) {
                if (huffmanTree[pointer * 2] == 0) {
                    int n = nextNode;
                    nextNode = (short)(nextNode + 1);
                    huffmanTree[pointer * 2] = n;
                    int n2 = nextNode;
                    nextNode = (short)(nextNode + 1);
                    huffmanTree[pointer * 2 + 1] = n2;
                }
                pointer = huffmanTree[pointer * 2 + (huffmanCode[i] >>> j & 1)];
            }
            if (pointer < 0) {
                System.out.println("error pointer=-1");
            }
            huffmanTree[pointer * 2] = -1;
            huffmanTree[pointer * 2 + 1] = (short)huffmanData[i];
        }
    }

    public static final int deHuffNext(long[] smallCodeBuffer, short[] huffmanTree) throws IOException {
        if (smallCodeBuffer[1] < 15L) {
            System.out.println("smallCodebuffer is too small");
        }
        int pointer = 0;
        while (huffmanTree[pointer * 2] != -1) {
            pointer = huffmanTree[pointer * 2 + (int)(smallCodeBuffer[0] & 1L)];
            smallCodeBuffer[0] = smallCodeBuffer[0] >>> 1;
            smallCodeBuffer[1] = smallCodeBuffer[1] - 1L;
            if (pointer != 0) continue;
            throw new IOException("5");
        }
        return huffmanTree[pointer * 2 + 1];
    }

    public static final void skipheader(InputStream in) throws IOException {
        if (in.read() != 31 || in.read() != 139 || in.read() != 8) {
            throw new IOException("0");
        }
        int flag = in.read();
        in.skip(6L);
        if ((flag & 4) == 4) {
            in.skip(in.read() | in.read() << 8);
        }
        if ((flag & 8) == 8) {
            while (in.read() != 0) {
            }
        }
        if ((flag & 0x10) == 16) {
            while (in.read() != 0) {
            }
        }
        if ((flag & 2) == 2) {
            in.skip(2L);
        }
    }

    private static final void initCrc32Table(int[] table) {
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            table[n] = c;
        }
    }

    public static final int crc32(int[] table, int crc, byte[] buffer, int off, int len) {
        if (table[2] == 0) {
            ZipHelper.initCrc32Table(table);
        }
        crc ^= 0xFFFFFFFF;
        for (int n = 0; n < len; ++n) {
            crc = table[(crc ^ buffer[n + off]) & 0xFF] ^ crc >>> 8;
        }
        return 0xFFFFFFFF ^ crc;
    }
}

