/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.text.TextUtils;
import com.xdja.reckon.ReckonAnalyticsConfig;
import com.xdja.reckon.common.Log;
import com.xdja.reckon.function.StateListener;
import com.xdja.reckon.service.ReckonService;
import com.xdja.reckon.share.SharePrefUtil;

public class ReckonAgent
implements ReckonService.RepotrStateListener {
    private static final String TAG = ReckonAgent.class.getSimpleName();
    private static ReckonAgent reckonAgent;
    private Context mContext;
    private ReckonAnalyticsConfig mConfig;
    private ReckonService.ReportBinder reportBinder;
    private StateListener stateListener;
    private String mPersonId;
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.i(TAG, "\u7ed1\u5b9a\u7edf\u8ba1\u670d\u52a1");
            ReckonAgent.this.reportBinder = (ReckonService.ReportBinder)service;
            ReckonAgent.this.reportBinder.addSateListener(ReckonAgent.this.stateListener);
            ReckonAgent.this.reportBinder.startReport(ReckonAgent.this.mPersonId, ReckonAgent.this);
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.i(TAG, "\u89e3\u7ed1\u7edf\u8ba1\u670d\u52a1");
        }
    };

    private ReckonAgent(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReckonAgent getInstance(Context context) {
        if (reckonAgent != null) return reckonAgent;
        Class<ReckonAgent> clazz = ReckonAgent.class;
        synchronized (ReckonAgent.class) {
            if (reckonAgent != null) return reckonAgent;
            reckonAgent = new ReckonAgent(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reckonAgent;
        }
    }

    public ReckonAgent config(String address, String port) {
        SharePrefUtil.saveString(this.mContext, "ip", address);
        SharePrefUtil.saveString(this.mContext, "port", port);
        return reckonAgent;
    }

    public ReckonAgent addStateListener(StateListener stateListener) {
        if (stateListener != null) {
            this.stateListener = stateListener;
            if (this.reportBinder != null) {
                this.reportBinder.addSateListener(stateListener);
            }
        }
        return reckonAgent;
    }

    public ReckonAgent startAnalytics(String personId) {
        this.mPersonId = personId;
        if (!TextUtils.isEmpty((CharSequence)this.mPersonId)) {
            Intent intent = new Intent(this.mContext, ReckonService.class);
            this.mContext.bindService(intent, this.serviceConnection, 1);
        } else {
            Log.i(TAG, "Reckon\u521d\u59cb\u5316\u5931\u8d25,\u672a\u83b7\u53d6\u5230\u7528\u6237id");
        }
        return reckonAgent;
    }

    public void startWithConfigure(String personID, ReckonAnalyticsConfig config) {
        this.startAnalytics(personID);
        this.mConfig = config;
    }

    public void stopAnalytics() {
        if (null != this.reportBinder) {
            this.reportBinder.stopReport();
        }
    }

    @Override
    public void onSuccess() {
    }

    @Override
    public void onStopReport() {
        this.mContext.unbindService(this.serviceConnection);
    }

    @Override
    public void onError() {
        this.mContext.unbindService(this.serviceConnection);
    }
}

