/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.api;

import android.content.Context;
import com.xdja.reckon.api.AppInfoApi;
import com.xdja.reckon.api.Constants;
import com.xdja.reckon.api.DeviceApi;
import com.xdja.reckon.api.UserApi;
import com.xdja.reckon.device.NetWorkUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class APIManager {
    private Context mContext;
    public static APIManager apiManager;
    private File httpCacheDirectory;
    private int cacheSize = 0xA00000;
    private Cache cache;
    private Object monitor = new Object();
    private Interceptor REWRITE_CACHE_CONTROL_INTERCEPTOR;
    private HttpLoggingInterceptor httpLoggingInterceptor;
    private OkHttpClient client;
    private DeviceApi deviceApi;
    private UserApi userApi;
    private AppInfoApi appInfoApi;

    public APIManager(Context context) {
        this.mContext = context;
        this.initOkHttpCilent();
    }

    private void initOkHttpCilent() {
        this.httpCacheDirectory = new File(this.mContext.getCacheDir(), "reckonCache");
        this.cache = new Cache(this.httpCacheDirectory, (long)this.cacheSize);
        this.REWRITE_CACHE_CONTROL_INTERCEPTOR = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (NetWorkUtil.isNetWorkAvailable(APIManager.this.mContext)) {
                    int maxAge = 60;
                    return originalResponse.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", "public, max-age=" + maxAge).build();
                }
                int maxStale = 2419200;
                return originalResponse.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale).build();
            }
        };
        this.httpLoggingInterceptor = new HttpLoggingInterceptor();
        this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.client = new OkHttpClient.Builder().addNetworkInterceptor(this.REWRITE_CACHE_CONTROL_INTERCEPTOR).addInterceptor((Interceptor)this.httpLoggingInterceptor).connectTimeout(5L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APIManager getInstance(Context context) {
        if (apiManager != null) return apiManager;
        Class<APIManager> clazz = APIManager.class;
        synchronized (APIManager.class) {
            if (apiManager != null) return apiManager;
            apiManager = new APIManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return apiManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceApi getDeviceApiService() {
        if (this.deviceApi == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.deviceApi == null) {
                    this.deviceApi = (DeviceApi)new Retrofit.Builder().baseUrl(Constants.getServerAddress(this.mContext)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(DeviceApi.class);
                }
            }
        }
        return this.deviceApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserApi getUserApiService() {
        if (this.userApi == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.userApi == null) {
                    this.userApi = (UserApi)new Retrofit.Builder().baseUrl(Constants.getServerAddress(this.mContext)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(UserApi.class);
                }
            }
        }
        return this.userApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppInfoApi getAppInfoApiService() {
        if (this.appInfoApi == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.appInfoApi == null) {
                    this.appInfoApi = (AppInfoApi)new Retrofit.Builder().baseUrl(Constants.getServerAddress(this.mContext)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(this.client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(AppInfoApi.class);
                }
            }
        }
        return this.appInfoApi;
    }
}

