/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.device;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;

public class PhoneInfoUtils {
    private static TelephonyManager getTelephonyManager(Context context) {
        TelephonyManager telephonyManager = null;
        try {
            if (context != null) {
                telephonyManager = (TelephonyManager)context.getSystemService("phone");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return telephonyManager;
    }

    public static String getImei(Context context) {
        String imei = null;
        if (context != null) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    imei = telephonyManager.getDeviceId();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imei;
    }

    public static String getImsi(Context context) {
        String imsi = null;
        if (context != null) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    imsi = telephonyManager.getSubscriberId();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imsi;
    }

    public static String getPhoneNumber(Context context) {
        String phoneNumber = null;
        TelephonyManager telephonyManager = PhoneInfoUtils.getTelephonyManager(context);
        if (telephonyManager != null) {
            phoneNumber = telephonyManager.getLine1Number();
        }
        return phoneNumber;
    }

    public static String getCarrier(Context context) {
        String operator;
        String carrier = null;
        TelephonyManager telephonyManager = PhoneInfoUtils.getTelephonyManager(context);
        if (telephonyManager != null && (operator = telephonyManager.getSimOperator()) != null) {
            if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007")) {
                carrier = "\u4e2d\u56fd\u79fb\u52a8";
            } else if (operator.equals("46001")) {
                carrier = "\u4e2d\u56fd\u8054\u901a";
            } else if (operator.equals("46003")) {
                carrier = "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return carrier;
    }

    public static String GetNetworkType(Context context) {
        String strNetworkType = "";
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = "WIFI";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                Log.e((String)"TAG", (String)("Network getSubtypeName : " + _strSubTypeName));
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = "2G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = "3G";
                        break;
                    }
                    case 13: {
                        strNetworkType = "4G";
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3G" : _strSubTypeName;
                    }
                }
                Log.e((String)"TAG", (String)("Network getSubtype : " + Integer.valueOf(networkType).toString()));
            }
        }
        Log.e((String)"TAG", (String)("Network Type : " + strNetworkType));
        return strNetworkType;
    }

    public static final String getAPN(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            return networkInfo.getExtraInfo();
        }
        return null;
    }
}

