/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.model;

import android.content.Context;
import com.xdja.reckon.device.BluetoothUtils;
import com.xdja.reckon.device.GPSUtils;
import com.xdja.reckon.device.NFCUtils;
import com.xdja.reckon.device.WifiUtils;
import com.xdja.reckon.function.AppManager;
import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;
import java.util.ArrayList;
import java.util.List;

public class AppResUsed {
    private String deviceId;
    private String appId;
    private String personId;
    private List<ResStateTypesBean> resStateTypes;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public List<ResStateTypesBean> getResStateTypes() {
        return this.resStateTypes;
    }

    public void setResStateTypes(List<ResStateTypesBean> resStateTypes) {
        this.resStateTypes = resStateTypes;
    }

    public static AppResUsed buildEntity(Context context) {
        AppResUsed appResUsed = new AppResUsed();
        appResUsed.setPersonId(PersonManager.getLocalPersonID(context));
        appResUsed.setDeviceId(DeviceManager.getLocalDeviceID(context));
        appResUsed.setAppId(AppManager.getLocalAppID(context));
        ArrayList<ResStateTypesBean> list = new ArrayList<ResStateTypesBean>();
        list.add(new ResStateTypesBean("rt0001", BluetoothUtils.isEnable() ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0002", WifiUtils.isEnable(context) ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0003", GPSUtils.isEnable(context) ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0004", NFCUtils.hasNfc(context) ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0005", "0"));
        list.add(new ResStateTypesBean("rt0006", "0"));
        list.add(new ResStateTypesBean("rt0007", "0"));
        appResUsed.setResStateTypes(list);
        return appResUsed;
    }

    public static class ResStateTypesBean {
        private String resState;
        private String resStateType;

        public ResStateTypesBean(String resStateType, String resState) {
            this.resState = resState;
            this.resStateType = resStateType;
        }

        public String getResState() {
            return this.resState;
        }

        public void setResState(String resState) {
            this.resState = resState;
        }

        public String getResStateType() {
            return this.resStateType;
        }

        public void setResStateType(String resStateType) {
            this.resStateType = resStateType;
        }
    }
}

