package com.xdja.reckon.function;

import android.content.Context;
import android.text.TextUtils;

import com.xdja.reckon.device.PhoneInfoUtils;
import com.xdja.reckon.share.SharePreConstants;
import com.xdja.reckon.share.SharePrefUtil;

/**
 * Created by Guojie on 16/9/18.
 */

public class DeviceManager extends BaseManager {
    /**
     * 本地是否已缓存deviceI
     *
     * @param context
     * @return
     */
    public static boolean isExistDeviceID(Context context) {
        String deviceId = SharePrefUtil.getString(context, SharePreConstants.DEVICE_ID, null);
        return !TextUtils.isEmpty(deviceId);
    }

    /**
     * 保存后台获取的deviceID
     *
     * @param context
     * @param deviceId
     */
    public static void saveDeviceID(Context context, String deviceId) {
        SharePrefUtil.saveString(context, SharePreConstants.DEVICE_ID, deviceId);
    }

    /**
     * 获取本地保存的deviceID
     *
     * @param context
     * @return
     */
    public static String getLocalDeviceID(Context context) {
        String deviceId = SharePrefUtil.getString(context, SharePreConstants.DEVICE_ID, null);
        return deviceId;
    }

    /**
     * 保存设备信息
     */
    public static final void saveDeviceInfo(Context context) {
        String currentDeviceInfo = PhoneInfoUtils.getImei(context);
        SharePrefUtil.saveString(context, SharePreConstants.DEVICE_IDFO, currentDeviceInfo);
    }

    /**
     * 判断设备信息是否一致
     *
     * @param context
     * @return
     */
    public static boolean isSameDevice(Context context) {

        String cacheDeviceInfo = SharePrefUtil.getString(context, SharePreConstants.DEVICE_IDFO, "");
        String currentDeviceInfo = PhoneInfoUtils.getImei(context);
        return currentDeviceInfo.equals(cacheDeviceInfo);
    }
}
