package com.xdja.reckon.model;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;

/**
 * App信息,获取应用ID
 *
 * @author Guojie
 *         on 16/9/6.
 */

public class AppInfo {

    private static final String TAG = AppInfo.class.getSimpleName();
    private String personId;
    private String deviceId;
    private String appPackage;
    private String appName;
    private String appVersionName;
    private String appVersionCode;
    private long installTime;

    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppVersionName() {
        return appVersionName;
    }

    public void setAppVersionName(String appVersionName) {
        this.appVersionName = appVersionName;
    }

    public String getAppVersionCode() {
        return appVersionCode;
    }

    public void setAppVersionCode(String appVersionCode) {
        this.appVersionCode = appVersionCode;
    }

    public long getInstallTime() {
        return installTime;
    }

    public void setInstallTime(long installTime) {
        this.installTime = installTime;
    }

    public static AppInfo buildEntity(Context context) {
        AppInfo appInfo = new AppInfo();
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            appInfo.setPersonId(PersonManager.getLocalPersonID(context));
            appInfo.setDeviceId(DeviceManager.getLocalDeviceID(context));
            appInfo.setAppName(packageInfo.applicationInfo.loadLabel(pm).toString());
            appInfo.setAppPackage(packageInfo.packageName);
            appInfo.setAppVersionCode(packageInfo.versionCode + "");
            appInfo.setAppVersionName(packageInfo.versionName);
            appInfo.setInstallTime(packageInfo.firstInstallTime);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return appInfo;
    }
}
