package com.xdja.reckon.model;

import android.content.Context;

import com.xdja.reckon.device.BluetoothUtils;
import com.xdja.reckon.device.GPSUtils;
import com.xdja.reckon.device.NFCUtils;
import com.xdja.reckon.device.WifiUtils;
import com.xdja.reckon.function.AppManager;
import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;
import com.xdja.reckon.share.SharePrefUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Guojie
 *         on 2016/9/23.
 */

public class AppResUsed {


    /**
     * resStateTypes : [{"resState":"1","resStateType":"rt0001"}]
     * deviceId : ff8080815755df08015755f8c8670008
     * appId : c8d72e155fcd49afae19dc20bce385db
     * personId : 12014033019594423
     */

    private String deviceId;
    private String appId;
    private String personId;
    /**
     * resState : 1
     * resStateType : rt0001
     */

    private List<ResStateTypesBean> resStateTypes;

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public List<ResStateTypesBean> getResStateTypes() {
        return resStateTypes;
    }

    public void setResStateTypes(List<ResStateTypesBean> resStateTypes) {
        this.resStateTypes = resStateTypes;
    }

    public static class ResStateTypesBean {
        private String resState;
        private String resStateType;

        public ResStateTypesBean( String resStateType,String resState) {
            this.resState = resState;
            this.resStateType = resStateType;
        }

        public String getResState() {
            return resState;
        }

        public void setResState(String resState) {
            this.resState = resState;
        }

        public String getResStateType() {
            return resStateType;
        }

        public void setResStateType(String resStateType) {
            this.resStateType = resStateType;
        }
    }
    public static AppResUsed buildEntity(Context context){
        AppResUsed appResUsed=new AppResUsed();
        appResUsed.setPersonId(PersonManager.getLocalPersonID(context));
        appResUsed.setDeviceId(DeviceManager.getLocalDeviceID(context));
        appResUsed.setAppId(AppManager.getLocalAppID(context));
        List<ResStateTypesBean> list=new ArrayList<>();
        list.add(new ResStateTypesBean("rt0001",BluetoothUtils.isEnable() == true ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0002", WifiUtils.isEnable(context) == true ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0003", GPSUtils.isEnable(context) == true ? "1" : "0"));
        list.add(new ResStateTypesBean("rt0004", NFCUtils.hasNfc(context)==true?"1":"0"));
        list.add(new ResStateTypesBean("rt0005","0"));
        list.add(new ResStateTypesBean("rt0006","0"));
        list.add(new ResStateTypesBean("rt0007","0"));
        appResUsed.setResStateTypes(list);
        return appResUsed;
    }
}
