package com.xdja.reckon;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.text.TextUtils;

import com.xdja.reckon.function.StateListener;
import com.xdja.reckon.service.ReckonService;
import com.xdja.reckon.share.SharePreConstants;
import com.xdja.reckon.share.SharePrefUtil;
import com.xdja.reckon.common.Log;

import java.util.List;

/**
 * Created by Guojie on 16/9/6.
 */

public class ReckonAgent implements ReckonService.RepotrStateListener {
    private static final String TAG = ReckonAgent.class.getSimpleName();
    private static ReckonAgent reckonAgent;
    private Context mContext;
    private ReckonAnalyticsConfig mConfig;
    private ReckonService.ReportBinder reportBinder;
    private StateListener stateListener;
    private boolean flag;
    /**
     * 用户ID
     */
    private String mPersonId;
    private ServiceConnection serviceConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.i(TAG, "绑定统计服务");
            reportBinder = (ReckonService.ReportBinder) service;
            reportBinder.addSateListener(stateListener);
            reportBinder.startReport(mPersonId, ReckonAgent.this);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.i(TAG, "解绑统计服务");
            flag = false;
        }
    };

    private ReckonAgent(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /**
     * 获取reckonAgent实例
     *
     * @param context
     * @return
     */
    public static ReckonAgent getInstance(Context context) {
        if (reckonAgent == null) {
            synchronized (ReckonAgent.class) {
                if (reckonAgent == null) {
                    reckonAgent = new ReckonAgent(context);
                }
            }
        }
        return reckonAgent;
    }

    /**
     * @param address 统计服务后台地址
     * @param port    统计服务端口
     * @return
     */
    public ReckonAgent config(String address, String port) {
        SharePrefUtil.saveString(mContext, SharePreConstants.IP, address);
        SharePrefUtil.saveString(mContext, SharePreConstants.PORT, port);
        return reckonAgent;
    }

    public ReckonAgent addStateListener(StateListener stateListener) {
        if (stateListener != null) {
            this.stateListener = stateListener;
            if (reportBinder != null) {
                reportBinder.addSateListener(stateListener);
            }
        }
        return reckonAgent;
    }

    /**
     * 开启分析,外部程序调用入口
     *
     * @param personId
     */
    public ReckonAgent startAnalytics(String personId) {
        mPersonId = personId;
        if (!TextUtils.isEmpty(mPersonId)) {
            Intent intent = new Intent(mContext, ReckonService.class);
            flag = mContext.bindService(intent, serviceConnection, Context.BIND_AUTO_CREATE);
        } else {
            Log.i(TAG, "Reckon初始化失败,未获取到用户id");
        }
        return reckonAgent;
    }

    /**
     * 预留接口
     *
     * @param personID
     * @param config
     */
    public void startWithConfigure(String personID, ReckonAnalyticsConfig config) {
        startAnalytics(personID);
        mConfig = config;
    }

    /**
     * 停止分析上报
     */
    public void stopAnalytics() {
        if (null != reportBinder) {
            reportBinder.stopReport();
        }
    }

    @Override
    public void onSuccess() {

    }

    @Override
    public void onStopReport() {
        if (flag&&isserviceRunning(mContext,ReckonService.class.getName())) {
            mContext.unbindService(serviceConnection);
        }
    }

    @Override
    public void onError() {
        if (flag&&isserviceRunning(mContext,ReckonService.class.getName())) {
            mContext.unbindService(serviceConnection);
        }
    }
    private boolean isserviceRunning(Context context, String serviceName) {
        ActivityManager myAM = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningServiceInfo> myList = myAM.getRunningServices(40);
        if (myList.size() <= 0) {
            return false;
        }

        for (int i = 0; i < myList.size(); i++) {
            String mName = myList.get(i).service.getClassName().toString();
            String packageName = myList.get(i).service.getPackageName();
            if (mName.equals(serviceName) && packageName.equals(context.getPackageName())) {
                Log.i("ygj", "统计服务正在运行");
                return true;
            }
        }

        return false;
    }
}
